/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.executor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Locale;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.SparkException$;
import org.apache.spark.executor.ProcfsMetrics;
import org.apache.spark.executor.ProcfsMetricsGetter$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ub!B\u000e\u001d\u0001y!\u0003\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\t\u000by\u0002A\u0011A \t\u000f\r\u0003!\u0019!C\u0005\t\"1A\n\u0001Q\u0001\n\u0015Cq!\u0014\u0001C\u0002\u0013%a\n\u0003\u0004S\u0001\u0001\u0006Ia\u0014\u0005\b'\u0002\u0011\r\u0011\"\u0003U\u0011\u0019A\u0006\u0001)A\u0005+\"9\u0011\f\u0001a\u0001\n\u0013q\u0005b\u0002.\u0001\u0001\u0004%Ia\u0017\u0005\u0007C\u0002\u0001\u000b\u0015B(\t\u000f\t\u0004!\u0019!C\u0005G\"1q\r\u0001Q\u0001\n\u0011D\u0001\u0002\u001b\u0001\t\u0006\u0004%IA\u0014\u0005\u0006S\u0002!IA\u001b\u0005\u0006W\u0002!I\u0001\u001c\u0005\u0007[\u0002!\t\u0001\b8\t\u000bI\u0004A\u0011B:\t\ru\u0004A\u0011\u0001\u000f\u007f\u0011!\tY\u0001\u0001C\u0001=\u00055q\u0001CA\b9!\u0005a$!\u0005\u0007\u000fma\u0002\u0012\u0001\u0010\u0002\u0014!1aH\u0006C\u0001\u0003+A\u0011\"a\u0006\u0017\u0005\u0004%)!!\u0007\t\u000f\u0005ma\u0003)A\u0007\u0001\"I\u0011Q\u0004\f\u0012\u0002\u0013\u0005\u0011q\u0004\u0002\u0014!J|7MZ:NKR\u0014\u0018nY:HKR$XM\u001d\u0006\u0003;y\t\u0001\"\u001a=fGV$xN\u001d\u0006\u0003?\u0001\nQa\u001d9be.T!!\t\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0013aA8sON\u0019\u0001!J\u0016\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g!\tas&D\u0001.\u0015\tqc$\u0001\u0005j]R,'O\\1m\u0013\t\u0001TFA\u0004M_\u001e<\u0017N\\4\u0002\u0013A\u0014xn\u00194t\t&\u00148\u0001\u0001\t\u0003imr!!N\u001d\u0011\u0005Y:S\"A\u001c\u000b\u0005a\u0012\u0014A\u0002\u001fs_>$h(\u0003\u0002;O\u00051\u0001K]3eK\u001aL!\u0001P\u001f\u0003\rM#(/\u001b8h\u0015\tQt%\u0001\u0004=S:LGO\u0010\u000b\u0003\u0001\n\u0003\"!\u0011\u0001\u000e\u0003qAq!\r\u0002\u0011\u0002\u0003\u00071'\u0001\bqe>\u001cgm]*uCR4\u0015\u000e\\3\u0016\u0003\u0015\u0003\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\t1\fgn\u001a\u0006\u0002\u0015\u0006!!.\u0019<b\u0013\tat)A\bqe>\u001cgm]*uCR4\u0015\u000e\\3!\u0003\u001d!Xm\u001d;j]\u001e,\u0012a\u0014\t\u0003MAK!!U\u0014\u0003\u000f\t{w\u000e\\3b]\u0006AA/Z:uS:<\u0007%\u0001\u0005qC\u001e,7+\u001b>f+\u0005)\u0006C\u0001\u0014W\u0013\t9vE\u0001\u0003M_:<\u0017!\u00039bO\u0016\u001c\u0016N_3!\u0003-I7/\u0011<bS2\f'\r\\3\u0002\u001f%\u001c\u0018I^1jY\u0006\u0014G.Z0%KF$\"\u0001X0\u0011\u0005\u0019j\u0016B\u00010(\u0005\u0011)f.\u001b;\t\u000f\u0001T\u0011\u0011!a\u0001\u001f\u0006\u0019\u0001\u0010J\u0019\u0002\u0019%\u001c\u0018I^1jY\u0006\u0014G.\u001a\u0011\u0002\u0007ALG-F\u0001e!\t1S-\u0003\u0002gO\t\u0019\u0011J\u001c;\u0002\tALG\rI\u0001\u0012SN\u0004&o\\2gg\u00063\u0018-\u001b7bE2,\u0017AC2p[B,H/\u001a)jIR\tA-A\bd_6\u0004X\u000f^3QC\u001e,7+\u001b>f)\u0005)\u0016AE2p[B,H/\u001a)s_\u000e,7o\u001d+sK\u0016$\u0012a\u001c\t\u0004iA$\u0017BA9>\u0005\r\u0019V\r^\u0001\rO\u0016$8\t[5mIBKGm\u001d\u000b\u0003ir\u00042!\u001e>e\u001b\u00051(BA<y\u0003\u001diW\u000f^1cY\u0016T!!_\u0014\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002|m\nY\u0011I\u001d:bs\n+hMZ3s\u0011\u0015\u0011'\u00031\u0001e\u0003y\tG\r\u001a)s_\u000e47/T3ue&\u001c7O\u0012:p[>sW\r\u0015:pG\u0016\u001c8\u000fF\u0003\u0000\u0003\u000b\tI\u0001E\u0002B\u0003\u0003I1!a\u0001\u001d\u00055\u0001&o\\2gg6+GO]5dg\"1\u0011qA\nA\u0002}\f!\"\u00197m\u001b\u0016$(/[2t\u0011\u0015\u00117\u00031\u0001e\u0003E\u0019w.\u001c9vi\u0016\fE\u000e\\'fiJL7m\u001d\u000b\u0002\u007f\u0006\u0019\u0002K]8dMNlU\r\u001e:jGN<U\r\u001e;feB\u0011\u0011IF\n\u0003-\u0015\"\"!!\u0005\u0002\u0013A$&/Z3J]\u001a|W#\u0001!\u0002\u0015A$&/Z3J]\u001a|\u0007%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u000b\u0003\u0003CQ3aMA\u0012W\t\t)\u0003\u0005\u0003\u0002(\u0005ERBAA\u0015\u0015\u0011\tY#!\f\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0018O\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0012\u0011\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ProcfsMetricsGetter
implements Logging {
    private boolean isProcfsAvailable;
    private final String procfsDir;
    private final String procfsStatFile;
    private final boolean testing;
    private final long pageSize;
    private boolean isAvailable;
    private final int pid;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$1() {
        return ProcfsMetricsGetter$.MODULE$.$lessinit$greater$default$1();
    }

    public static ProcfsMetricsGetter pTreeInfo() {
        return ProcfsMetricsGetter$.MODULE$.pTreeInfo();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String procfsStatFile() {
        return this.procfsStatFile;
    }

    private boolean testing() {
        return this.testing;
    }

    private long pageSize() {
        return this.pageSize;
    }

    private boolean isAvailable() {
        return this.isAvailable;
    }

    private void isAvailable_$eq(boolean x$1) {
        this.isAvailable = x$1;
    }

    private int pid() {
        return this.pid;
    }

    private boolean isProcfsAvailable$lzycompute() {
        ProcfsMetricsGetter procfsMetricsGetter = this;
        synchronized (procfsMetricsGetter) {
            if (!this.bitmap$0) {
                boolean bl;
                if (this.testing()) {
                    bl = true;
                } else {
                    Try procDirExists = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> Files.exists(Paths.get($this.procfsDir, new String[0]), new LinkOption[0])).recover((PartialFunction)new Serializable(this){
                        private static final long serialVersionUID = 0L;
                        private final /* synthetic */ ProcfsMetricsGetter $outer;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 instanceof IOException) {
                                IOException iOException = (IOException)A1;
                                this.$outer.logWarning((Function0<String>)(Function0 & Serializable)() -> "Exception checking for procfs dir", iOException);
                                object = BoxesRunTime.boxToBoolean((boolean)false);
                            } else {
                                object = function1.apply(x1);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            boolean bl = throwable instanceof IOException;
                            return bl;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1()}, serializedLambda);
                        }
                    });
                    boolean shouldPollProcessTreeMetrics = BoxesRunTime.unboxToBoolean((Object)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.EXECUTOR_PROCESS_TREE_METRICS_ENABLED()));
                    bl = BoxesRunTime.unboxToBoolean((Object)procDirExists.get()) && shouldPollProcessTreeMetrics;
                }
                this.isProcfsAvailable = bl;
                this.bitmap$0 = true;
            }
        }
        return this.isProcfsAvailable;
    }

    private boolean isProcfsAvailable() {
        return !this.bitmap$0 ? this.isProcfsAvailable$lzycompute() : this.isProcfsAvailable;
    }

    private int computePid() {
        int n;
        if (!this.isAvailable() || this.testing()) {
            return -1;
        }
        try {
            String[] cmd = (String[])((Object[])new String[]{"bash", "-c", "echo $PPID"});
            String out = Utils$.MODULE$.executeAndGetOutput((Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)cmd), Utils$.MODULE$.executeAndGetOutput$default$2(), Utils$.MODULE$.executeAndGetOutput$default$3(), Utils$.MODULE$.executeAndGetOutput$default$4());
            n = Integer.parseInt(out.split("\n")[0]);
        }
        catch (SparkException e) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Exception when trying to compute process tree. As a result reporting of ProcessTree metrics is stopped", e);
            this.isAvailable_$eq(false);
            n = -1;
        }
        return n;
    }

    private long computePageSize() {
        long l;
        if (this.testing()) {
            return 4096L;
        }
        try {
            String[] cmd = (String[])((Object[])new String[]{"getconf", "PAGESIZE"});
            String out = Utils$.MODULE$.executeAndGetOutput((Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)cmd), Utils$.MODULE$.executeAndGetOutput$default$2(), Utils$.MODULE$.executeAndGetOutput$default$3(), Utils$.MODULE$.executeAndGetOutput$default$4());
            l = Integer.parseInt(out.split("\n")[0]);
        }
        catch (Exception e) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Exception when trying to compute pagesize, as a result reporting of ProcessTree metrics is stopped");
            this.isAvailable_$eq(false);
            l = 0L;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public Set<Object> computeProcessTree() {
        void var1_1;
        if (!this.isAvailable() || this.testing()) {
            return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        }
        Set ptree = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        ptree = (Set)ptree.$plus((Object)BoxesRunTime.boxToInteger((int)this.pid()));
        Queue queue = Queue$.MODULE$.empty();
        queue.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.pid()));
        while (!queue.isEmpty()) {
            int p = BoxesRunTime.unboxToInt((Object)queue.dequeue());
            ArrayBuffer<Object> c = this.getChildPids(p);
            if (c.isEmpty()) continue;
            queue.$plus$plus$eq(c);
            ptree = (Set)ptree.$plus$plus((IterableOnce)c.toSet());
        }
        return var1_1;
    }

    private ArrayBuffer<Object> getChildPids(int pid) {
        ArrayBuffer arrayBuffer;
        try {
            ProcessBuilder builder = new ProcessBuilder("pgrep", "-P", Integer.toString(pid));
            Process process = builder.start();
            ArrayBuffer childPidsInInt = ArrayBuffer$.MODULE$.empty();
            Thread stdoutThread = Utils$.MODULE$.processStreamByLine("read stdout for pgrep", process.getInputStream(), (Function1<String, BoxedUnit>)(Function1 & Serializable)s -> {
                this.appendChildPid$1(s, childPidsInInt);
                return BoxedUnit.UNIT;
            });
            StringBuilder errorStringBuilder = new StringBuilder();
            Thread stdErrThread = Utils$.MODULE$.processStreamByLine("stderr for pgrep", process.getErrorStream(), (Function1<String, BoxedUnit>)(Function1 & Serializable)line -> {
                errorStringBuilder.append(line);
                return BoxedUnit.UNIT;
            });
            int exitCode = process.waitFor();
            stdoutThread.join();
            stdErrThread.join();
            String errorString = errorStringBuilder.toString();
            if (exitCode != 0 && exitCode > 2) {
                String cmd = Predef$.MODULE$.wrapRefArray(builder.command().toArray()).mkString(" ");
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(39).append("Process ").append(cmd).append(" exited with code ").append(exitCode).append(" and stderr: ").append(errorString).toString());
                throw SparkException$.MODULE$.internalError(new java.lang.StringBuilder(26).append("Process ").append(cmd).append(" exited with code ").append(exitCode).toString(), "EXECUTOR");
            }
            arrayBuffer = childPidsInInt;
        }
        catch (Exception e) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Exception when trying to compute process tree. As a result reporting of ProcessTree metrics is stopped.", e);
            this.isAvailable_$eq(false);
            arrayBuffer = ArrayBuffer$.MODULE$.empty();
        }
        return arrayBuffer;
    }

    public ProcfsMetrics addProcfsMetricsFromOneProcess(ProcfsMetrics allMetrics, int pid) {
        ProcfsMetrics procfsMetrics;
        try {
            File pidDir = new File(this.procfsDir, Integer.toString(pid));
            procfsMetrics = (ProcfsMetrics)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> this.openReader$1(pidDir), (Function1 & Serializable)in -> {
                ProcfsMetrics procfsMetrics;
                String procInfo = in.readLine();
                int commStartIndex = procInfo.indexOf(40);
                int commEndIndex = procInfo.lastIndexOf(41) + 1;
                String[] pidArray = (String[])((Object[])new String[]{procInfo.substring(0, commStartIndex).trim()});
                String[] commArray = (String[])((Object[])new String[]{procInfo.substring(commStartIndex, commEndIndex)});
                String[] splitAfterComm = procInfo.substring(commEndIndex).trim().split(" ");
                String[] procInfoSplit = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])pidArray), (Object)commArray, ClassTag$.MODULE$.apply(String.class))), (Object)splitAfterComm, ClassTag$.MODULE$.apply(String.class));
                long vmem = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(procInfoSplit[22]));
                long rssMem = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(procInfoSplit[23])) * this.pageSize();
                if (procInfoSplit[1].toLowerCase(Locale.US).contains("java")) {
                    procfsMetrics = allMetrics.copy(allMetrics.jvmVmemTotal() + vmem, allMetrics.jvmRSSTotal() + rssMem, allMetrics.copy$default$3(), allMetrics.copy$default$4(), allMetrics.copy$default$5(), allMetrics.copy$default$6());
                } else if (procInfoSplit[1].toLowerCase(Locale.US).contains("python")) {
                    long x$1 = allMetrics.pythonVmemTotal() + vmem;
                    long x$2 = allMetrics.pythonRSSTotal() + rssMem;
                    long x$3 = allMetrics.copy$default$1();
                    long x$4 = allMetrics.copy$default$2();
                    long x$5 = allMetrics.copy$default$5();
                    long x$6 = allMetrics.copy$default$6();
                    procfsMetrics = allMetrics.copy(x$3, x$4, x$1, x$2, x$5, x$6);
                } else {
                    long x$7 = allMetrics.otherVmemTotal() + vmem;
                    long x$8 = allMetrics.otherRSSTotal() + rssMem;
                    long x$9 = allMetrics.copy$default$1();
                    long x$10 = allMetrics.copy$default$2();
                    long x$11 = allMetrics.copy$default$3();
                    long x$12 = allMetrics.copy$default$4();
                    procfsMetrics = allMetrics.copy(x$9, x$10, x$11, x$12, x$7, x$8);
                }
                return procfsMetrics;
            });
        }
        catch (IOException f) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "There was a problem with reading the stat file of the process. ", f);
            throw f;
        }
        return procfsMetrics;
    }

    public ProcfsMetrics computeAllMetrics() {
        ProcfsMetrics procfsMetrics;
        Object object = new Object();
        try {
            if (!this.isAvailable()) {
                return new ProcfsMetrics(0L, 0L, 0L, 0L, 0L, 0L);
            }
            Set<Object> pids = this.computeProcessTree();
            ObjectRef allMetrics = ObjectRef.create((Object)new ProcfsMetrics(0L, 0L, 0L, 0L, 0L, 0L));
            pids.foreach((Function1)(JFunction1.mcVI.sp & Serializable)p -> {
                try {
                    allMetrics$2.elem = this.addProcfsMetricsFromOneProcess((ProcfsMetrics)allMetrics$2.elem, p);
                    if (!this.isAvailable()) {
                        throw new NonLocalReturnControl(object, (Object)new ProcfsMetrics(0L, 0L, 0L, 0L, 0L, 0L));
                    }
                }
                catch (IOException iOException) {
                    throw new NonLocalReturnControl(object, (Object)new ProcfsMetrics(0L, 0L, 0L, 0L, 0L, 0L));
                }
            });
            procfsMetrics = (ProcfsMetrics)allMetrics.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                procfsMetrics = (ProcfsMetrics)ex.value();
            }
            throw ex;
        }
        return procfsMetrics;
    }

    private final void appendChildPid$1(String s, ArrayBuffer childPidsInInt$1) {
        block0: {
            String string = s;
            String string2 = "";
            if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
            this.logTrace((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(18).append("Found a child pid:").append(s).toString());
            childPidsInInt$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)Integer.parseInt(s)));
        }
    }

    private final BufferedReader openReader$1(File pidDir$1) {
        File f = new File(pidDir$1, this.procfsStatFile());
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8));
    }

    public ProcfsMetricsGetter(String procfsDir) {
        this.procfsDir = procfsDir;
        Logging.$init$((Logging)this);
        this.procfsStatFile = "stat";
        this.testing = Utils$.MODULE$.isTesting();
        this.pageSize = this.computePageSize();
        this.isAvailable = this.isProcfsAvailable();
        this.pid = this.computePid();
    }
}

