/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.resource;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.api.resource.ResourceDiscoveryPlugin;
import org.apache.spark.internal.Logging;
import org.apache.spark.resource.ResourceInformation;
import org.apache.spark.resource.ResourceInformation$;
import org.apache.spark.resource.ResourceRequest;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0005\u00113Aa\u0001\u0003\u0001\u001b!)1\u0005\u0001C\u0001I!)q\u0005\u0001C!Q\ti\"+Z:pkJ\u001cW\rR5tG>4XM]=TGJL\u0007\u000f\u001e)mk\u001eLgN\u0003\u0002\u0006\r\u0005A!/Z:pkJ\u001cWM\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u0017;A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001875\t\u0001D\u0003\u0002\u00063)\u0011!DB\u0001\u0004CBL\u0017B\u0001\u000f\u0019\u0005]\u0011Vm]8ve\u000e,G)[:d_Z,'/\u001f)mk\u001eLg\u000e\u0005\u0002\u001fC5\tqD\u0003\u0002!\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002#?\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001&!\t1\u0003!D\u0001\u0005\u0003A!\u0017n]2pm\u0016\u0014(+Z:pkJ\u001cW\rF\u0002*e]\u00022AK\u00170\u001b\u0005Y#B\u0001\u0017\u0013\u0003\u0011)H/\u001b7\n\u00059Z#\u0001C(qi&|g.\u00197\u0011\u0005\u0019\u0002\u0014BA\u0019\u0005\u0005M\u0011Vm]8ve\u000e,\u0017J\u001c4pe6\fG/[8o\u0011\u0015\u0019$\u00011\u00015\u0003\u001d\u0011X-];fgR\u0004\"AJ\u001b\n\u0005Y\"!a\u0004*fg>,(oY3SKF,Xm\u001d;\t\u000ba\u0012\u0001\u0019A\u001d\u0002\u0013M\u0004\u0018M]6D_:4\u0007C\u0001\u001e<\u001b\u00051\u0011B\u0001\u001f\u0007\u0005%\u0019\u0006/\u0019:l\u0007>tg\r\u000b\u0002\u0001}A\u0011qHQ\u0007\u0002\u0001*\u0011\u0011IB\u0001\u000bC:tw\u000e^1uS>t\u0017BA\"A\u00051!UM^3m_B,'/\u00119j\u0001")
public class ResourceDiscoveryScriptPlugin
implements ResourceDiscoveryPlugin,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public Optional<ResourceInformation> discoverResource(ResourceRequest request, SparkConf sparkConf) {
        Optional<String> script = request.discoveryScript();
        String resourceName = request.id().resourceName();
        if (script.isPresent()) {
            File scriptFile = new File(script.get());
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Discovering resources for ").append(resourceName).append(" with script: ").append(scriptFile).toString());
            if (!scriptFile.exists()) {
                throw new SparkException(new StringBuilder(14).append(new StringBuilder(31).append("Resource script: ").append(scriptFile).append(" to discover ").append(resourceName).append(" ").toString()).append("doesn't exist!").toString());
            }
        } else {
            throw new SparkException(new StringBuilder(34).append(new StringBuilder(41).append("User is expecting to use resource: ").append(resourceName).append(", but ").toString()).append("didn't specify a discovery script!").toString());
        }
        String output = Utils$.MODULE$.executeAndGetOutput((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{script.get()}))), new File("."), Utils$.MODULE$.executeAndGetOutput$default$3(), Utils$.MODULE$.executeAndGetOutput$default$4());
        ResourceInformation result = ResourceInformation$.MODULE$.parseJson(output);
        if (!result.name().equals(resourceName)) {
            throw new SparkException(new StringBuilder(0).append(new StringBuilder(46).append("Error running the resource discovery script ").append((Object)script.get()).append(": ").toString()).append(new StringBuilder(54).append("script returned resource name ").append(result.name()).append(" and we were expecting ").append(resourceName).append(".").toString()).toString());
        }
        return Optional.of(result);
    }

    public ResourceDiscoveryScriptPlugin() {
        Logging.$init$((Logging)this);
    }
}

