/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FileSourceConstantMetadataStructField$;
import org.apache.spark.sql.catalyst.expressions.FileSourceGeneratedMetadataStructField$;
import org.apache.spark.sql.catalyst.expressions.FileSourceMetadataAttribute$;
import org.apache.spark.sql.catalyst.expressions.GetArrayStructFields;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.InheritAnalysisRules;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.PrettyAttribute;
import org.apache.spark.sql.catalyst.expressions.PrettyPythonUDF;
import org.apache.spark.sql.catalyst.expressions.PythonFuncExpression;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.QuotingUtils$;
import org.apache.spark.sql.catalyst.util.SparkStringUtils$;
import org.apache.spark.sql.catalyst.util.package;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.SparkErrorUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.sparkproject.guava.io.ByteStreams;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class package$
implements Logging {
    public static final package$ MODULE$ = new package$();
    private static final String METADATA_COL_ATTR_KEY;
    private static final String QUALIFIED_ACCESS_ONLY;
    private static final String AUTO_GENERATED_ALIAS;
    private static final Seq<String> INTERNAL_METADATA_KEYS;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        METADATA_COL_ATTR_KEY = "__metadata_col";
        QUALIFIED_ACCESS_ONLY = "__qualified_access_only";
        AUTO_GENERATED_ALIAS = "__autoGeneratedAlias";
        INTERNAL_METADATA_KEYS = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.AUTO_GENERATED_ALIAS(), MODULE$.METADATA_COL_ATTR_KEY(), MODULE$.QUALIFIED_ACCESS_ONLY(), FileSourceMetadataAttribute$.MODULE$.FILE_SOURCE_METADATA_COL_ATTR_KEY(), FileSourceConstantMetadataStructField$.MODULE$.FILE_SOURCE_CONSTANT_METADATA_COL_ATTR_KEY(), FileSourceGeneratedMetadataStructField$.MODULE$.FILE_SOURCE_GENERATED_METADATA_COL_ATTR_KEY()}));
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public <A> A quietly(Function0<A> f) {
        Object object;
        PrintStream origErr = System.err;
        PrintStream origOut = System.out;
        try {
            System.setErr(new PrintStream(new OutputStream(){

                public final void write(int x$1) {
                    package$.org$apache$spark$sql$catalyst$util$package$$$anonfun$quietly$1(x$1);
                }
            }));
            System.setOut(new PrintStream(new OutputStream(){

                public final void write(int x$1) {
                    package$.org$apache$spark$sql$catalyst$util$package$$$anonfun$quietly$3(x$1);
                }
            }));
            object = f.apply();
        }
        finally {
            System.setErr(origErr);
            System.setOut(origOut);
        }
        return (A)object;
    }

    public String fileToString(File file, Charset encoding) {
        String string;
        try (FileInputStream inStream = new FileInputStream(file);){
            string = new String(ByteStreams.toByteArray((InputStream)inStream), encoding);
        }
        return string;
    }

    public Charset fileToString$default$2() {
        return StandardCharsets.UTF_8;
    }

    public byte[] resourceToBytes(String resource, ClassLoader classLoader) {
        byte[] byArray;
        try (InputStream inStream = classLoader.getResourceAsStream(resource);){
            byArray = ByteStreams.toByteArray((InputStream)inStream);
        }
        return byArray;
    }

    public ClassLoader resourceToBytes$default$2() {
        return Utils$.MODULE$.getSparkClassLoader();
    }

    public String resourceToString(String resource, String encoding, ClassLoader classLoader) {
        return new String(this.resourceToBytes(resource, classLoader), encoding);
    }

    public String resourceToString$default$2() {
        return StandardCharsets.UTF_8.name();
    }

    public ClassLoader resourceToString$default$3() {
        return Utils$.MODULE$.getSparkClassLoader();
    }

    public File stringToFile(File file, String str) {
        Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> new PrintWriter(file), (Function1 & Serializable)out -> {
            out.write(str);
            return BoxedUnit.UNIT;
        });
        return file;
    }

    public Seq<String> sideBySide(String left, String right) {
        return SparkStringUtils$.MODULE$.sideBySide(left, right);
    }

    public Seq<String> sideBySide(Seq<String> left, Seq<String> right) {
        return SparkStringUtils$.MODULE$.sideBySide(left, right);
    }

    public String stackTraceToString(Throwable t) {
        return SparkErrorUtils$.MODULE$.stackTraceToString(t);
    }

    public Expression usePrettyExpression(Expression e) {
        return (Expression)e.transform(new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Cast cast;
                Object object;
                boolean bl = false;
                Literal literal = null;
                A1 A1 = x1;
                if (A1 instanceof Attribute) {
                    Attribute attribute = (Attribute)A1;
                    object = new PrettyAttribute(attribute);
                    return (B1)object;
                }
                if (A1 instanceof Literal) {
                    bl = true;
                    literal = (Literal)A1;
                    Object s = literal.value();
                    DataType dataType = literal.dataType();
                    if (s instanceof UTF8String) {
                        UTF8String uTF8String = (UTF8String)s;
                        if (StringType$.MODULE$.equals(dataType)) {
                            object = new PrettyAttribute(uTF8String.toString(), (DataType)StringType$.MODULE$);
                            return (B1)object;
                        }
                    }
                }
                if (bl) {
                    Object v = literal.value();
                    DataType t = literal.dataType();
                    if (t instanceof NumericType) {
                        NumericType numericType = (NumericType)t;
                        if (v != null) {
                            object = new PrettyAttribute(v.toString(), (DataType)numericType);
                            return (B1)object;
                        }
                    }
                }
                if (bl) {
                    Object object2 = literal.value();
                    DataType dataType = literal.dataType();
                    if (object2 == null) {
                        object = new PrettyAttribute("NULL", dataType);
                        return (B1)object;
                    }
                }
                if (A1 instanceof GetStructField) {
                    GetStructField getStructField = (GetStructField)A1;
                    String name = (String)getStructField.name().getOrElse((Function0 & Serializable)() -> getStructField.childSchema().apply(getStructField.ordinal()).name());
                    object = new PrettyAttribute(new StringBuilder(1).append(package$.MODULE$.usePrettyExpression(getStructField.child()).sql()).append(".").append(name).toString(), getStructField.dataType());
                    return (B1)object;
                }
                if (A1 instanceof GetArrayStructFields) {
                    GetArrayStructFields getArrayStructFields = (GetArrayStructFields)A1;
                    object = new PrettyAttribute(new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)package$.MODULE$.usePrettyExpression(getArrayStructFields.child())), ".")).append(getArrayStructFields.field().name()).toString(), getArrayStructFields.dataType());
                    return (B1)object;
                }
                if (A1 instanceof InheritAnalysisRules) {
                    A1 A12 = A1;
                    object = new PrettyAttribute(((InheritAnalysisRules)((Object)A12)).makeSQLString((Seq<String>)((Seq)((InheritAnalysisRules)((Object)A12)).parameters().map((Function1 & Serializable)e -> package$.MODULE$.toPrettySQL((Expression)e)))), A12.dataType());
                    return (B1)object;
                }
                if (A1 instanceof Cast && !BoxesRunTime.unboxToBoolean((Object)(cast = (Cast)A1).getTagValue(Cast$.MODULE$.USER_SPECIFIED_CAST()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) {
                    object = new PrettyAttribute(package$.MODULE$.usePrettyExpression(cast.child()).sql(), cast.dataType());
                    return (B1)object;
                }
                if (A1 instanceof PythonFuncExpression) {
                    PythonFuncExpression pythonFuncExpression = (PythonFuncExpression)((Object)A1);
                    object = new PrettyPythonUDF(pythonFuncExpression.name(), ((Expression)((Object)pythonFuncExpression)).dataType(), ((TreeNode)((Object)pythonFuncExpression)).children());
                    return (B1)object;
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Expression x1) {
                Cast cast;
                Object object;
                boolean bl = false;
                Literal literal = null;
                Expression expression = x1;
                if (expression instanceof Attribute) {
                    return true;
                }
                if (expression instanceof Literal) {
                    bl = true;
                    literal = (Literal)expression;
                    Object s = literal.value();
                    DataType dataType = literal.dataType();
                    if (s instanceof UTF8String && StringType$.MODULE$.equals(dataType)) {
                        return true;
                    }
                }
                if (bl) {
                    Object v = literal.value();
                    DataType t = literal.dataType();
                    if (t instanceof NumericType && v != null) {
                        return true;
                    }
                }
                if (bl && (object = literal.value()) == null) {
                    return true;
                }
                if (expression instanceof GetStructField) {
                    return true;
                }
                if (expression instanceof GetArrayStructFields) {
                    return true;
                }
                if (expression instanceof InheritAnalysisRules) {
                    return true;
                }
                if (expression instanceof Cast && !BoxesRunTime.unboxToBoolean((Object)(cast = (Cast)expression).getTagValue(Cast$.MODULE$.USER_SPECIFIED_CAST()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) {
                    return true;
                }
                if (!(expression instanceof PythonFuncExpression)) return false;
                return true;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.expressions.GetStructField ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$applyOrElse$3(), $anonfun$isDefinedAt$1()}, serializedLambda);
            }
        });
    }

    public String quoteIdentifier(String name) {
        return QuotingUtils$.MODULE$.quoteIdentifier(name);
    }

    public String quoteNameParts(Seq<String> name) {
        return QuotingUtils$.MODULE$.quoteNameParts(name);
    }

    public String quoteIfNeeded(String part) {
        return QuotingUtils$.MODULE$.quoteIfNeeded(part);
    }

    public String toPrettySQL(Expression e) {
        return this.usePrettyExpression(e).sql();
    }

    public String escapeSingleQuotedString(String str) {
        return QuotingUtils$.MODULE$.escapeSingleQuotedString(str);
    }

    public <T> String truncatedString(Seq<T> seq, String start, String sep, String end, int maxFields) {
        return SparkStringUtils$.MODULE$.truncatedString(seq, start, sep, end, maxFields);
    }

    public <T> String truncatedString(Seq<T> seq, String sep, int maxFields) {
        return SparkStringUtils$.MODULE$.truncatedString(seq, "", sep, "", maxFields);
    }

    public String METADATA_COL_ATTR_KEY() {
        return METADATA_COL_ATTR_KEY;
    }

    public String QUALIFIED_ACCESS_ONLY() {
        return QUALIFIED_ACCESS_ONLY;
    }

    public package.MetadataColumnHelper MetadataColumnHelper(Attribute attr) {
        return new package.MetadataColumnHelper(attr);
    }

    public String AUTO_GENERATED_ALIAS() {
        return AUTO_GENERATED_ALIAS;
    }

    public Seq<String> INTERNAL_METADATA_KEYS() {
        return INTERNAL_METADATA_KEYS;
    }

    public StructType removeInternalMetadata(StructType schema) {
        return StructType$.MODULE$.apply((Seq)schema.map((Function1 & Serializable)field -> {
            ObjectRef builder = ObjectRef.create((Object)new MetadataBuilder().withMetadata(field.metadata()));
            MODULE$.INTERNAL_METADATA_KEYS().foreach((Function1 & Serializable)key -> {
                builder.elem = ((MetadataBuilder)builder.elem).remove(key);
                return BoxedUnit.UNIT;
            });
            Metadata x$1 = ((MetadataBuilder)builder.elem).build();
            String x$2 = field.copy$default$1();
            DataType x$3 = field.copy$default$2();
            boolean x$4 = field.copy$default$3();
            return field.copy(x$2, x$3, x$4, x$1);
        }));
    }

    public static final /* synthetic */ void org$apache$spark$sql$catalyst$util$package$$$anonfun$quietly$1(int x$1) {
    }

    public static final /* synthetic */ void org$apache$spark$sql$catalyst$util$package$$$anonfun$quietly$3(int x$2) {
    }

    private package$() {
    }
}

