/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.python;

import java.io.Serializable;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.api.python.BasePythonRunner;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.execution.GroupedIterator$;
import org.apache.spark.sql.vectorized.ArrowColumnVector;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class PandasGroupUtils$ {
    public static PandasGroupUtils$ MODULE$;

    static {
        new PandasGroupUtils$();
    }

    public <T> Iterator<InternalRow> executePython(Iterator<T> data, Seq<Attribute> output, BasePythonRunner<T, ColumnarBatch> runner) {
        TaskContext context = TaskContext$.MODULE$.get();
        Iterator columnarBatchIter = runner.compute(data, context.partitionId(), context);
        UnsafeProjection unsafeProj = UnsafeProjection$.MODULE$.create(output, output);
        return columnarBatchIter.flatMap((Function1 & Serializable & scala.Serializable)batch -> {
            ArrowColumnVector structVector = (ArrowColumnVector)batch.column(0);
            IndexedSeq outputVectors = (IndexedSeq)output.indices().map((Function1 & Serializable & scala.Serializable)x$1 -> structVector.getChild(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
            ColumnarBatch flattenedBatch = new ColumnarBatch((ColumnVector[])outputVectors.toArray(ClassTag$.MODULE$.apply(ColumnVector.class)));
            flattenedBatch.setNumRows(batch.numRows());
            return (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(flattenedBatch.rowIterator()).asScala();
        }).map((Function1)unsafeProj);
    }

    public Iterator<Tuple2<InternalRow, Iterator<InternalRow>>> groupAndProject(Iterator<InternalRow> input, Seq<Attribute> groupingAttributes, Seq<Attribute> inputSchema, Seq<Attribute> dedupSchema) {
        Iterator<Tuple2<InternalRow, Iterator<InternalRow>>> groupedIter = GroupedIterator$.MODULE$.apply(input, groupingAttributes, inputSchema);
        UnsafeProjection dedupProj = UnsafeProjection$.MODULE$.create(dedupSchema, inputSchema);
        return groupedIter.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                InternalRow k = (InternalRow)tuple2._1();
                Iterator groupedRowIter = (Iterator)tuple2._2();
                return new Tuple2((Object)k, (Object)groupedRowIter.map((Function1)dedupProj));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Tuple2<Seq<Attribute>, int[]> resolveArgOffsets(Seq<Attribute> attributes, Seq<Attribute> groupingAttributes) {
        Seq dataAttributes = (Seq)attributes.drop(groupingAttributes.length());
        Seq groupingIndicesInData = (Seq)groupingAttributes.map((Function1 & Serializable & scala.Serializable)attribute -> BoxesRunTime.boxToInteger((int)dataAttributes.indexWhere((Function1 & Serializable & scala.Serializable)other -> BoxesRunTime.boxToBoolean((boolean)attribute.semanticEquals(other)))), Seq$.MODULE$.canBuildFrom());
        ArrayBuffer groupingArgOffsets = new ArrayBuffer();
        ArrayBuffer nonDupGroupingAttributes = new ArrayBuffer();
        int nonDupGroupingSize = groupingIndicesInData.count((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 == -1);
        ((IterableLike)groupingAttributes.zip((GenIterable)groupingIndicesInData, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Attribute attribute = (Attribute)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (index == -1) {
                    groupingArgOffsets.$plus$eq((Object)BoxesRunTime.boxToInteger((int)nonDupGroupingAttributes.length()));
                    return nonDupGroupingAttributes.$plus$eq((Object)attribute);
                }
                return groupingArgOffsets.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(index + nonDupGroupingSize)));
            }
            throw new MatchError((Object)tuple2);
        });
        Range dataArgOffsets = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(nonDupGroupingAttributes.length()), nonDupGroupingAttributes.length() + dataAttributes.length());
        int argOffsetsLength = groupingAttributes.length() + dataArgOffsets.length() + 1;
        int[] argOffsets = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{argOffsetsLength, groupingAttributes.length()})).$plus$plus((GenTraversableOnce)groupingArgOffsets, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).$plus$plus((GenTraversableOnce)dataArgOffsets, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        ArrayBuffer dedupAttributes = (ArrayBuffer)nonDupGroupingAttributes.$plus$plus((GenTraversableOnce)dataAttributes);
        return new Tuple2((Object)dedupAttributes.toSeq(), (Object)argOffsets);
    }

    private PandasGroupUtils$() {
        MODULE$ = this;
    }
}

