/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches;

import org.apache.datasketches.BoundsOnRatiosInSampledSets;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Summary;

public final class BoundsOnRatiosInTupleSketchedSets {
    private BoundsOnRatiosInTupleSketchedSets() {
    }

    public static <S extends Summary> double getLowerBoundForBoverA(Sketch<S> sketchA, Sketch<S> sketchB) {
        int countA;
        long thetaLongA = sketchA.getThetaLong();
        long thetaLongB = sketchB.getThetaLong();
        BoundsOnRatiosInTupleSketchedSets.checkThetas(thetaLongA, thetaLongB);
        int countB = sketchB.getRetainedEntries();
        int n = countA = thetaLongB == thetaLongA ? sketchA.getRetainedEntries() : sketchA.getCountLessThanThetaLong(thetaLongB);
        if (countA <= 0) {
            return 0.0;
        }
        double f = (double)thetaLongB / 9.223372036854776E18;
        return BoundsOnRatiosInSampledSets.getLowerBoundForBoverA(countA, countB, f);
    }

    public static <S extends Summary> double getLowerBoundForBoverA(Sketch<S> sketchA, org.apache.datasketches.theta.Sketch sketchB) {
        int countA;
        long thetaLongA = sketchA.getThetaLong();
        long thetaLongB = sketchB.getThetaLong();
        BoundsOnRatiosInTupleSketchedSets.checkThetas(thetaLongA, thetaLongB);
        int countB = sketchB.getRetainedEntries();
        int n = countA = thetaLongB == thetaLongA ? sketchA.getRetainedEntries() : sketchA.getCountLessThanThetaLong(thetaLongB);
        if (countA <= 0) {
            return 0.0;
        }
        double f = (double)thetaLongB / 9.223372036854776E18;
        return BoundsOnRatiosInSampledSets.getLowerBoundForBoverA(countA, countB, f);
    }

    public static <S extends Summary> double getUpperBoundForBoverA(Sketch<S> sketchA, Sketch<S> sketchB) {
        int countA;
        long thetaLongA = sketchA.getThetaLong();
        long thetaLongB = sketchB.getThetaLong();
        BoundsOnRatiosInTupleSketchedSets.checkThetas(thetaLongA, thetaLongB);
        int countB = sketchB.getRetainedEntries();
        int n = countA = thetaLongB == thetaLongA ? sketchA.getRetainedEntries() : sketchA.getCountLessThanThetaLong(thetaLongB);
        if (countA <= 0) {
            return 1.0;
        }
        double f = (double)thetaLongB / 9.223372036854776E18;
        return BoundsOnRatiosInSampledSets.getUpperBoundForBoverA(countA, countB, f);
    }

    public static <S extends Summary> double getUpperBoundForBoverA(Sketch<S> sketchA, org.apache.datasketches.theta.Sketch sketchB) {
        int countA;
        long thetaLongA = sketchA.getThetaLong();
        long thetaLongB = sketchB.getThetaLong();
        BoundsOnRatiosInTupleSketchedSets.checkThetas(thetaLongA, thetaLongB);
        int countB = sketchB.getRetainedEntries(true);
        int n = countA = thetaLongB == thetaLongA ? sketchA.getRetainedEntries() : sketchA.getCountLessThanThetaLong(thetaLongB);
        if (countA <= 0) {
            return 1.0;
        }
        double f = (double)thetaLongB / 9.223372036854776E18;
        return BoundsOnRatiosInSampledSets.getUpperBoundForBoverA(countA, countB, f);
    }

    public static <S extends Summary> double getEstimateOfBoverA(Sketch<S> sketchA, Sketch<S> sketchB) {
        int countA;
        long thetaLongA = sketchA.getThetaLong();
        long thetaLongB = sketchB.getThetaLong();
        BoundsOnRatiosInTupleSketchedSets.checkThetas(thetaLongA, thetaLongB);
        int countB = sketchB.getRetainedEntries();
        int n = countA = thetaLongB == thetaLongA ? sketchA.getRetainedEntries() : sketchA.getCountLessThanThetaLong(thetaLongB);
        if (countA <= 0) {
            return 0.5;
        }
        return (double)countB / (double)countA;
    }

    public static <S extends Summary> double getEstimateOfBoverA(Sketch<S> sketchA, org.apache.datasketches.theta.Sketch sketchB) {
        int countA;
        long thetaLongA = sketchA.getThetaLong();
        long thetaLongB = sketchB.getThetaLong();
        BoundsOnRatiosInTupleSketchedSets.checkThetas(thetaLongA, thetaLongB);
        int countB = sketchB.getRetainedEntries(true);
        int n = countA = thetaLongB == thetaLongA ? sketchA.getRetainedEntries() : sketchA.getCountLessThanThetaLong(thetaLongB);
        if (countA <= 0) {
            return 0.5;
        }
        return (double)countB / (double)countA;
    }

    static void checkThetas(long thetaLongA, long thetaLongB) {
        if (thetaLongB > thetaLongA) {
            throw new SketchesArgumentException("ThetaLongB cannot be > ThetaLongA.");
        }
    }
}

