/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.feature.ChiSqSelector;
import org.apache.spark.mllib.feature.ChiSqSelectorModel;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction1;

public final class ChiSqSelectorExample$ {
    public static ChiSqSelectorExample$ MODULE$;

    static {
        new ChiSqSelectorExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("ChiSqSelectorExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = MLUtils$.MODULE$.loadLibSVMFile(sc, "data/mllib/sample_libsvm_data.txt");
        RDD discretizedData = data.map((Function1 & java.io.Serializable & Serializable)lp -> new LabeledPoint(lp.label(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(lp.features().toArray())).map((Function1)(JFunction1.mcDD.sp & java.io.Serializable & Serializable)x -> RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(x / (double)16)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))), ClassTag$.MODULE$.apply(LabeledPoint.class));
        ChiSqSelector selector = new ChiSqSelector(50);
        ChiSqSelectorModel transformer = selector.fit(discretizedData);
        RDD filteredData = discretizedData.map((Function1 & java.io.Serializable & Serializable)lp -> new LabeledPoint(lp.label(), transformer.transform(lp.features())), ClassTag$.MODULE$.apply(LabeledPoint.class));
        Predef$.MODULE$.println((Object)"filtered data: ");
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredData.collect())).foreach((Function1 & java.io.Serializable & Serializable)x -> {
            Predef$.MODULE$.println((Object)x);
            return BoxedUnit.UNIT;
        });
        sc.stop();
    }

    private ChiSqSelectorExample$() {
        MODULE$ = this;
    }
}

