/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MonthsBetween$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(timestamp1, timestamp2[, roundOff]) - If `timestamp1` is later than `timestamp2`, then the result\n      is positive. If `timestamp1` and `timestamp2` are on the same day of month, or both\n      are the last day of month, time of day will be ignored. Otherwise, the difference is\n      calculated based on 31 days per month, and rounded to 8 digits unless roundOff=false.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('1997-02-28 10:30:00', '1996-10-30');\n       3.94959677\n      > SELECT _FUNC_('1997-02-28 10:30:00', '1996-10-30', false);\n       3.9495967741935485\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t-c\u0001\u0002\u0016,\u0001bB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\t1\u0002\u0011\t\u0012)A\u0005+\"A\u0011\f\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005[\u0001\tE\t\u0015!\u0003V\u0011!Y\u0006A!f\u0001\n\u0003!\u0006\u0002\u0003/\u0001\u0005#\u0005\u000b\u0011B+\t\u0011u\u0003!Q3A\u0005\u0002yC\u0001\"\u001c\u0001\u0003\u0012\u0003\u0006Ia\u0018\u0005\u0006]\u0002!\ta\u001c\u0005\u0006]\u0002!\t!\u001e\u0005\u0006]\u0002!\t\u0001\u001f\u0005\u0006y\u0002!\t\u0005\u0016\u0005\u0006{\u0002!\t\u0005\u0016\u0005\u0006}\u0002!\t\u0005\u0016\u0005\u0007\u007f\u0002!\t%!\u0001\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"!9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0002bBA\u0018\u0001\u0011\u0005\u0013\u0011\u0007\u0005\b\u0003\u0007\u0002A\u0011IA#\u0011\u001d\t\t\u0007\u0001C!\u0003GBq!!\u001a\u0001\t#\n9\u0007C\u0005\u0002v\u0001\t\t\u0011\"\u0001\u0002x!I\u0011\u0011\u0011\u0001\u0012\u0002\u0013\u0005\u00111\u0011\u0005\n\u00033\u0003\u0011\u0013!C\u0001\u0003\u0007C\u0011\"a'\u0001#\u0003%\t!a!\t\u0013\u0005u\u0005!%A\u0005\u0002\u0005}\u0005\"CAR\u0001\u0005\u0005I\u0011IAS\u0011%\t)\fAA\u0001\n\u0003\t9\fC\u0005\u0002@\u0002\t\t\u0011\"\u0001\u0002B\"I\u0011q\u0019\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u001a\u0005\n\u0003/\u0004\u0011\u0011!C\u0001\u00033D\u0011\"a9\u0001\u0003\u0003%\t%!:\b\u0013\t%1&!A\t\u0002\t-a\u0001\u0003\u0016,\u0003\u0003E\tA!\u0004\t\r9\u0014C\u0011\u0001B\u000e\u0011%\u0011iBIA\u0001\n\u000b\u0012y\u0002C\u0005\u0003\"\t\n\t\u0011\"!\u0003$!I!Q\u0006\u0012\u0012\u0002\u0013\u0005\u0011q\u0014\u0005\n\u0005_\u0011\u0013\u0011!CA\u0005cA\u0011Ba\u0010##\u0003%\t!a(\t\u0013\t\u0005#%!A\u0005\n\t\r#!D'p]RD7OQ3uo\u0016,gN\u0003\u0002-[\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tqs&\u0001\u0005dCR\fG._:u\u0015\t\u0001\u0014'A\u0002tc2T!AM\u001a\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q*\u0014AB1qC\u000eDWMC\u00017\u0003\ry'oZ\u0002\u0001'\u001d\u0001\u0011(\u0010!D\u0015B\u0003\"AO\u001e\u000e\u0003-J!\u0001P\u0016\u0003#Q+'O\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002;}%\u0011qh\u000b\u0002\u0018)&lWMW8oK\u0006;\u0018M]3FqB\u0014Xm]:j_:\u0004\"AO!\n\u0005\t[#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005\u0011;eB\u0001\u001eF\u0013\t15&A\u0004qC\u000e\\\u0017mZ3\n\u0005!K%A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003\r.\u0002\"a\u0013(\u000e\u00031S\u0011!T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f2\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002L#&\u0011!\u000b\u0014\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006I\u0006$X-M\u000b\u0002+B\u0011!HV\u0005\u0003/.\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019!\u0017\r^32A\u0005)A-\u0019;fe\u00051A-\u0019;fe\u0001\n\u0001B]8v]\u0012|eMZ\u0001\ne>,h\u000eZ(gM\u0002\n!\u0002^5nKj{g.Z%e+\u0005y\u0006cA&aE&\u0011\u0011\r\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\rTgB\u00013i!\t)G*D\u0001g\u0015\t9w'\u0001\u0004=e>|GOP\u0005\u0003S2\u000ba\u0001\u0015:fI\u00164\u0017BA6m\u0005\u0019\u0019FO]5oO*\u0011\u0011\u000eT\u0001\fi&lWMW8oK&#\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0006aF\u00148\u000f\u001e\t\u0003u\u0001AQaU\u0005A\u0002UCQ!W\u0005A\u0002UCQaW\u0005A\u0002UCq!X\u0005\u0011\u0002\u0003\u0007q\fF\u0002qm^DQa\u0015\u0006A\u0002UCQ!\u0017\u0006A\u0002U#B\u0001]={w\")1k\u0003a\u0001+\")\u0011l\u0003a\u0001+\")1l\u0003a\u0001+\u0006)a-\u001b:ti\u000611/Z2p]\u0012\fQ\u0001\u001e5je\u0012\f!\"\u001b8qkR$\u0016\u0010]3t+\t\t\u0019\u0001\u0005\u0004\u0002\u0006\u00055\u00111\u0003\b\u0005\u0003\u000f\tYAD\u0002f\u0003\u0013I\u0011!T\u0005\u0003\r2KA!a\u0004\u0002\u0012\t\u00191+Z9\u000b\u0005\u0019c\u0005\u0003BA\u000b\u00037i!!a\u0006\u000b\u0007\u0005eq&A\u0003usB,7/\u0003\u0003\u0002\u001e\u0005]!\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,WCAA\u0012!\u0011\t)\"!\n\n\t\u0005\u001d\u0012q\u0003\u0002\t\t\u0006$\u0018\rV=qK\u0006aq/\u001b;i)&lWMW8oKR\u0019Q(!\f\t\u000bu\u000b\u0002\u0019\u00012\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0011\u0005M\u0012\u0011HA\u001f\u0003\u0003\u00022aSA\u001b\u0013\r\t9\u0004\u0014\u0002\u0004\u0003:L\bbBA\u001e%\u0001\u0007\u00111G\u0001\u0003iFBq!a\u0010\u0013\u0001\u0004\t\u0019$\u0001\u0002ue!11L\u0005a\u0001\u0003g\t\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005\u001d\u00131KA/!\u0011\tI%a\u0014\u000e\u0005\u0005-#bAA'W\u000591m\u001c3fO\u0016t\u0017\u0002BA)\u0003\u0017\u0012\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003+\u001a\u0002\u0019AA,\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u0013\nI&\u0003\u0003\u0002\\\u0005-#AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003?\u001a\u0002\u0019AA$\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012AY\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$r\u0001]A5\u0003[\n\t\b\u0003\u0004\u0002lU\u0001\r!V\u0001\t]\u0016<h)\u001b:ti\"1\u0011qN\u000bA\u0002U\u000b\u0011B\\3x'\u0016\u001cwN\u001c3\t\r\u0005MT\u00031\u0001V\u0003!qWm\u001e+iSJ$\u0017\u0001B2paf$\u0012\u0002]A=\u0003w\ni(a \t\u000fM3\u0002\u0013!a\u0001+\"9\u0011L\u0006I\u0001\u0002\u0004)\u0006bB.\u0017!\u0003\u0005\r!\u0016\u0005\b;Z\u0001\n\u00111\u0001`\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\"+\u0007U\u000b9i\u000b\u0002\u0002\nB!\u00111RAK\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006E\u0015!C;oG\",7m[3e\u0015\r\t\u0019\nT\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAL\u0003\u001b\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005\u0005&fA0\u0002\b\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a*\u0011\t\u0005%\u00161W\u0007\u0003\u0003WSA!!,\u00020\u0006!A.\u00198h\u0015\t\t\t,\u0001\u0003kCZ\f\u0017bA6\u0002,\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0018\t\u0004\u0017\u0006m\u0016bAA_\u0019\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111GAb\u0011%\t)-HA\u0001\u0002\u0004\tI,A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0017\u0004b!!4\u0002T\u0006MRBAAh\u0015\r\t\t\u000eT\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAk\u0003\u001f\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111\\Aq!\rY\u0015Q\\\u0005\u0004\u0003?d%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u000b|\u0012\u0011!a\u0001\u0003g\ta!Z9vC2\u001cH\u0003BAn\u0003OD\u0011\"!2!\u0003\u0003\u0005\r!a\r)'\u0001\tY/!=\u0002t\u0006]\u0018\u0011`A\u007f\u0003\u007f\u0014\u0019A!\u0002\u0011\u0007i\ni/C\u0002\u0002p.\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002v\u0006\u0019\u0019A\u0003\u0011!A\u0001zf)\u0016(D?\"\"\u0018.\\3ti\u0006l\u0007/\r\u0017!i&lWm\u001d;b[B\u00144\f\f\u0011s_VtGm\u00144g;&\u0002S\u0006I%gA\u0001$\u0018.\\3ti\u0006l\u0007/\r1!SN\u0004C.\u0019;fe\u0002\"\b.\u00198!ARLW.Z:uC6\u0004(\u0007\u0019\u0017!i\",g\u000e\t;iK\u0002\u0012Xm];mi*\u0001\u0003\u0005\t\u0011!A%\u001c\b\u0005]8tSRLg/\u001a\u0018!\u0013\u001a\u0004\u0003\r^5nKN$\u0018-\u001c92A\u0002\ng\u000e\u001a\u0011ai&lWm\u001d;b[B\u0014\u0004\rI1sK\u0002zg\u000e\t;iK\u0002\u001a\u0018-\\3!I\u0006L\be\u001c4![>tG\u000f\u001b\u0017!_J\u0004#m\u001c;i\u0015\u0001\u0002\u0003\u0005\t\u0011!CJ,\u0007\u0005\u001e5fA1\f7\u000f\u001e\u0011eCf\u0004sN\u001a\u0011n_:$\b\u000e\f\u0011uS6,\u0007e\u001c4!I\u0006L\be^5mY\u0002\u0012W\rI5h]>\u0014X\r\u001a\u0018!\u001fRDWM]<jg\u0016d\u0003\u0005\u001e5fA\u0011LgMZ3sK:\u001cW\rI5t\u0015\u0001\u0002\u0003\u0005\t\u0011!G\u0006d7-\u001e7bi\u0016$\u0007EY1tK\u0012\u0004sN\u001c\u00114c\u0001\"\u0017-_:!a\u0016\u0014\b%\\8oi\"d\u0003%\u00198eAI|WO\u001c3fI\u0002\"x\u000e\t\u001d!I&<\u0017\u000e^:!k:dWm]:!e>,h\u000eZ(gMv2\u0017\r\\:f])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tY0AA=\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013'O\u001d8[A\u0012TF\r\u001d!cAR4\u0007\r\u001e1a\u001db\u0003eJ\u0019:sYj\u0013\u0007M\u00174a\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a/sQJT'\u000f\u001c8o)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%M\u001d:o5\u0002$'\f\u001a9AE\u0002$h\r\u0019;aA:C\u0006I\u00142se2T&\r\u0019.gA:C\u0006\t4bYN,\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00114]e\"\u0014(N\u001d7o]\"\u0014'O\u001a6ia*$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t\u0005\u0011A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0005\u000f\tQ!\r\u00186]A\nQ\"T8oi\"\u001c()\u001a;xK\u0016t\u0007C\u0001\u001e#'\u0011\u0011#q\u0002)\u0011\u0013\tE!qC+V+~\u0003XB\u0001B\n\u0015\r\u0011)\u0002T\u0001\beVtG/[7f\u0013\u0011\u0011IBa\u0005\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0006\u0002\u0003\f\u0005AAo\\*ue&tw\r\u0006\u0002\u0002(\u0006)\u0011\r\u001d9msRI\u0001O!\n\u0003(\t%\"1\u0006\u0005\u0006'\u0016\u0002\r!\u0016\u0005\u00063\u0016\u0002\r!\u0016\u0005\u00067\u0016\u0002\r!\u0016\u0005\b;\u0016\u0002\n\u00111\u0001`\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005g\u0011Y\u0004\u0005\u0003LA\nU\u0002cB&\u00038U+VkX\u0005\u0004\u0005sa%A\u0002+va2,G\u0007\u0003\u0005\u0003>\u001d\n\t\u00111\u0001q\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u000b\u0002B!!+\u0003H%!!\u0011JAV\u0005\u0019y%M[3di\u0002")
public class MonthsBetween
extends TernaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression date1;
    private final Expression date2;
    private final Expression roundOff;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$4() {
        return MonthsBetween$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Expression, Expression, Expression, Option<String>>> unapply(MonthsBetween monthsBetween) {
        return MonthsBetween$.MODULE$.unapply(monthsBetween);
    }

    public static Option<String> apply$default$4() {
        return MonthsBetween$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Option<String>>, MonthsBetween> tupled() {
        return MonthsBetween$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Option<String>, MonthsBetween>>>> curried() {
        return MonthsBetween$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        MonthsBetween monthsBetween = this;
        synchronized (monthsBetween) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        MonthsBetween monthsBetween = this;
        synchronized (monthsBetween) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if (!this.bitmap$trans$0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression date1() {
        return this.date1;
    }

    public Expression date2() {
        return this.date2;
    }

    public Expression roundOff() {
        return this.roundOff;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression first() {
        return this.date1();
    }

    @Override
    public Expression second() {
        return this.date2();
    }

    @Override
    public Expression third() {
        return this.roundOff();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TimestampType$.MODULE$, (List)new .colon.colon((Object)TimestampType$.MODULE$, (List)new .colon.colon((Object)BooleanType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object t1, Object t2, Object roundOff) {
        return BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(BoxesRunTime.unboxToLong((Object)t1), BoxesRunTime.unboxToLong((Object)t2), BoxesRunTime.unboxToBoolean((Object)roundOff), this.zoneId()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(d1, d2, roundOff) -> new StringBuilder(22).append(dtu).append(".monthsBetween(").append((String)d1).append(", ").append((String)d2).append(", ").append((String)roundOff).append(", ").append(zid).append(")").toString());
    }

    @Override
    public String prettyName() {
        return "months_between";
    }

    @Override
    public MonthsBetween withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird, this.copy$default$4());
    }

    public MonthsBetween copy(Expression date1, Expression date2, Expression roundOff, Option<String> timeZoneId) {
        return new MonthsBetween(date1, date2, roundOff, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.date1();
    }

    public Expression copy$default$2() {
        return this.date2();
    }

    public Expression copy$default$3() {
        return this.roundOff();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "MonthsBetween";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.date1();
            }
            case 1: {
                return this.date2();
            }
            case 2: {
                return this.roundOff();
            }
            case 3: {
                return this.timeZoneId();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MonthsBetween;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MonthsBetween)) return false;
        boolean bl = true;
        if (!bl) return false;
        MonthsBetween monthsBetween = (MonthsBetween)x$1;
        Expression expression = this.date1();
        Expression expression2 = monthsBetween.date1();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.date2();
        Expression expression4 = monthsBetween.date2();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.roundOff();
        Expression expression6 = monthsBetween.roundOff();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = monthsBetween.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!monthsBetween.canEqual(this)) return false;
        return true;
    }

    public MonthsBetween(Expression date1, Expression date2, Expression roundOff, Option<String> timeZoneId) {
        this.date1 = date1;
        this.date2 = date2;
        this.roundOff = roundOff;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public MonthsBetween(Expression date1, Expression date2) {
        this(date1, date2, Literal$.MODULE$.TrueLiteral(), (Option<String>)None$.MODULE$);
    }

    public MonthsBetween(Expression date1, Expression date2, Expression roundOff) {
        this(date1, date2, roundOff, (Option<String>)None$.MODULE$);
    }
}

