/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.clustering.KMeans;
import org.apache.spark.ml.clustering.KMeansModel;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.r.KMeansWrapper;
import org.apache.spark.ml.r.RWrapperUtils$;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class KMeansWrapper$
implements MLReadable<KMeansWrapper> {
    public static final KMeansWrapper$ MODULE$ = new KMeansWrapper$();

    static {
        MLReadable.$init$(MODULE$);
    }

    private boolean $lessinit$greater$default$4() {
        return false;
    }

    public KMeansWrapper fit(Dataset<Row> data, String formula, int k, int maxIter, String initMode, String seed, int initSteps, double tol) {
        RFormula rFormula = new RFormula().setFormula(formula).setFeaturesCol("features");
        RWrapperUtils$.MODULE$.checkDataColumns(rFormula, data);
        Model rFormulaModel = rFormula.fit((Dataset)data);
        StructType schema = ((RFormulaModel)rFormulaModel).transform(data).schema();
        Attribute[] featureAttrs = (Attribute[])AttributeGroup$.MODULE$.fromStructField(schema.apply(((RFormulaModel)rFormulaModel).getFeaturesCol())).attributes().get();
        String[] features = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])featureAttrs), (Function1 & Serializable)x$2 -> (String)x$2.name().get(), ClassTag$.MODULE$.apply(String.class));
        KMeans kMeans = new KMeans().setK(k).setMaxIter(maxIter).setInitMode(initMode).setFeaturesCol(rFormula.getFeaturesCol()).setInitSteps(initSteps).setTol(tol);
        Object object = seed != null && seed.length() > 0 ? kMeans.setSeed(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(seed))) : BoxedUnit.UNIT;
        Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormulaModel, kMeans})).fit((Dataset)data);
        KMeansModel kMeansModel = (KMeansModel)((PipelineModel)pipeline).stages()[1];
        long[] size = kMeansModel.summary().clusterSizes();
        return new KMeansWrapper((PipelineModel)pipeline, features, size, this.$lessinit$greater$default$4());
    }

    @Override
    public MLReader<KMeansWrapper> read() {
        return new KMeansWrapper.KMeansWrapperReader();
    }

    @Override
    public KMeansWrapper load(String path) {
        return (KMeansWrapper)MLReadable.load$(this, path);
    }

    private KMeansWrapper$() {
    }
}

