/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.SampledRDDs;
import org.apache.spark.examples.mllib.SampledRDDs$Params$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.PairRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class SampledRDDs$ {
    public static final SampledRDDs$ MODULE$ = new SampledRDDs$();

    public void main(String[] args) {
        SampledRDDs.Params defaultParams = new SampledRDDs.Params(SampledRDDs$Params$.MODULE$.apply$default$1());
        OptionParser<SampledRDDs.Params> parser = new OptionParser<SampledRDDs.Params>(defaultParams){
            {
                this.head((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SampledRDDs: an example app for randomly generated and sampled RDDs."}));
                this.opt("input", Read$.MODULE$.stringRead()).text("Input path to labeled examples in LIBSVM format, default: " + defaultParams$1.input()).action((Function2 & Serializable)(x, c) -> c.copy((String)x));
                this.note(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |For example, the following command runs this app:\n        |\n        | bin/spark-submit --class org.apache.spark.examples.mllib.SampledRDDs \\\n        |  examples/target/scala-*/spark-examples-*.jar\n        ")));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(java.lang.String org.apache.spark.examples.mllib.SampledRDDs$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (option instanceof Some) {
            Some some = (Some)option;
            SampledRDDs.Params params = (SampledRDDs.Params)some.value();
            this.run(params);
            return;
        }
        throw package$.MODULE$.exit(1);
    }

    public void run(SampledRDDs.Params params) {
        SparkConf conf = new SparkConf().setAppName("SampledRDDs with " + params);
        SparkContext sc = new SparkContext(conf);
        double fraction = 0.1;
        RDD examples = MLUtils$.MODULE$.loadLibSVMFile(sc, params.input());
        long numExamples = examples.count();
        if (numExamples == 0L) {
            throw new RuntimeException("Error: Data file had no samples to load.");
        }
        Predef$.MODULE$.println((Object)("Loaded data with " + numExamples + " examples from file: " + params.input()));
        int expectedSampleSize = (int)((double)numExamples * fraction);
        Predef$.MODULE$.println((Object)("Sampling RDD using fraction " + fraction + ".  Expected sample size = " + expectedSampleSize + "."));
        RDD sampledRDD = examples.sample(true, fraction, examples.sample$default$3());
        Predef$.MODULE$.println((Object)("  RDD.sample(): sample has " + sampledRDD.count() + " examples"));
        LabeledPoint[] sampledArray = (LabeledPoint[])examples.takeSample(true, expectedSampleSize, examples.takeSample$default$3());
        Predef$.MODULE$.println((Object)("  RDD.takeSample(): sample has " + sampledArray.length + " examples"));
        Predef$.MODULE$.println();
        RDD keyedRDD = examples.map((Function1 & Serializable)lp -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)((int)lp.label())), (Object)lp.features()), ClassTag$.MODULE$.apply(Tuple2.class));
        Predef$.MODULE$.println((Object)"  Keyed data using label (Int) as key ==> Orig");
        Map keyCounts = RDD$.MODULE$.rddToPairRDDFunctions(keyedRDD, (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Int$.MODULE$).countByKey();
        scala.collection.immutable.Map fractions = ((IterableOnceOps)keyCounts.keys().map((Function1 & Serializable)x$1 -> SampledRDDs$.$anonfun$run$2(fraction, BoxesRunTime.unboxToInt((Object)x$1)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        PairRDDFunctions qual$1 = RDD$.MODULE$.rddToPairRDDFunctions(keyedRDD, (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Int$.MODULE$);
        boolean x$12 = true;
        scala.collection.immutable.Map x$2 = fractions;
        long x$3 = qual$1.sampleByKey$default$3();
        RDD sampledByKeyRDD = qual$1.sampleByKey(true, (Map)x$2, x$3);
        Map keyCountsB = RDD$.MODULE$.rddToPairRDDFunctions(sampledByKeyRDD, (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Int$.MODULE$).countByKey();
        long sizeB = BoxesRunTime.unboxToLong((Object)keyCountsB.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        Predef$.MODULE$.println((Object)("  Sampled " + sizeB + " examples using approximate stratified sampling (by label). ==> Approx Sample"));
        PairRDDFunctions qual$2 = RDD$.MODULE$.rddToPairRDDFunctions(keyedRDD, (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Int$.MODULE$);
        boolean x$4 = true;
        scala.collection.immutable.Map x$5 = fractions;
        long x$6 = qual$2.sampleByKeyExact$default$3();
        RDD sampledByKeyRDDExact = qual$2.sampleByKeyExact(true, (Map)x$5, x$6);
        Map keyCountsBExact = RDD$.MODULE$.rddToPairRDDFunctions(sampledByKeyRDDExact, (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Int$.MODULE$).countByKey();
        long sizeBExact = BoxesRunTime.unboxToLong((Object)keyCountsBExact.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        Predef$.MODULE$.println((Object)("  Sampled " + sizeBExact + " examples using exact stratified sampling (by label). ==> Exact Sample"));
        Predef$.MODULE$.println((Object)"   \tFractions of examples with key");
        Predef$.MODULE$.println((Object)"Key\tOrig\tApprox Sample\tExact Sample");
        ((IterableOnceOps)keyCounts.keys().toSeq().sorted((Ordering)Ordering.Int$.MODULE$)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)key -> {
            double origFrac = (double)BoxesRunTime.unboxToLong((Object)keyCounts.apply((Object)BoxesRunTime.boxToInteger((int)key))) / (double)numExamples;
            double approxFrac = sizeB != 0L ? (double)BoxesRunTime.unboxToLong((Object)keyCountsB.getOrElse((Object)BoxesRunTime.boxToInteger((int)key), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) / (double)sizeB : 0.0;
            double exactFrac = sizeBExact != 0L ? (double)BoxesRunTime.unboxToLong((Object)keyCountsBExact.getOrElse((Object)BoxesRunTime.boxToInteger((int)key), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) / (double)sizeBExact : 0.0;
            Predef$.MODULE$.println((Object)(key + "\t" + origFrac + "\t" + approxFrac + "\t" + exactFrac));
        });
        sc.stop();
    }

    public static final /* synthetic */ Tuple2 $anonfun$run$2(double fraction$1, int x$1) {
        return new Tuple2.mcID.sp(x$1, fraction$1);
    }

    private SampledRDDs$() {
    }
}

