/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayBinaryLike;
import org.apache.spark.sql.catalyst.expressions.ArraySetLike;
import org.apache.spark.sql.catalyst.expressions.ArrayUnion$;
import org.apache.spark.sql.catalyst.expressions.BinaryArrayExpressionWithImplicitCast;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.util.SQLOpenHashSet;
import org.apache.spark.sql.util.SQLOpenHashSet$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ExpressionDescription(usage="\n    _FUNC_(array1, array2) - Returns an array of the elements in the union of array1 and array2,\n      without duplicates.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), array(1, 3, 5));\n       [1,2,3,5]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\u00055h\u0001\u0002\u000f\u001e\u0001*B\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\"AQ\n\u0001BK\u0002\u0013\u0005\u0001\n\u0003\u0005O\u0001\tE\t\u0015!\u0003J\u0011\u0015y\u0005\u0001\"\u0001Q\u0011!!\u0006\u0001#b\u0001\n\u0003)\u0006\"B2\u0001\t\u0003\"\u0007\"\u00027\u0001\t\u0003j\u0007\"B>\u0001\t\u0003b\bbBA\u0006\u0001\u0011E\u0013Q\u0002\u0005\n\u0003/\u0001\u0011\u0011!C\u0001\u00033A\u0011\"a\b\u0001#\u0003%\t!!\t\t\u0013\u0005]\u0002!%A\u0005\u0002\u0005\u0005\u0002\"CA\u001d\u0001\u0005\u0005I\u0011IA\u001e\u0011%\tY\u0005AA\u0001\n\u0003\ti\u0005C\u0005\u0002V\u0001\t\t\u0011\"\u0001\u0002X!I\u0011Q\f\u0001\u0002\u0002\u0013\u0005\u0013q\f\u0005\n\u0003[\u0002\u0011\u0011!C\u0001\u0003_B\u0011\"!\u001f\u0001\u0003\u0003%\t%a\u001f\t\u0013\u0005}\u0004!!A\u0005B\u0005\u0005u!CAS;\u0005\u0005\t\u0012AAT\r!aR$!A\t\u0002\u0005%\u0006BB(\u0017\t\u0003\t\t\rC\u0005\u0002DZ\t\t\u0011\"\u0012\u0002F\"I\u0011q\u0019\f\u0002\u0002\u0013\u0005\u0015\u0011\u001a\u0005\n\u0003\u001f4\u0012\u0011!CA\u0003#D\u0011\"a9\u0017\u0003\u0003%I!!:\u0003\u0015\u0005\u0013(/Y=V]&|gN\u0003\u0002\u001f?\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0001\u0013%\u0001\u0005dCR\fG._:u\u0015\t\u00113%A\u0002tc2T!\u0001J\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\u0002\u0001'\u0019\u00011f\f\u001a6wA\u0011A&L\u0007\u0002;%\u0011a&\b\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"\u0001\f\u0019\n\u0005Ej\"aD!se\u0006L()\u001b8befd\u0015n[3\u0011\u00051\u001a\u0014B\u0001\u001b\u001e\u0005q\u0019u.\u001c9mKb$\u0016\u0010]3NKJ<\u0017N\\4FqB\u0014Xm]:j_:\u0004\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002=\t:\u0011QH\u0011\b\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001&\na\u0001\u0010:p_Rt\u0014\"\u0001\u001d\n\u0005\r;\u0014a\u00029bG.\fw-Z\u0005\u0003\u000b\u001a\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!aQ\u001c\u0002\t1,g\r^\u000b\u0002\u0013B\u0011AFS\u0005\u0003\u0017v\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u00051A(\u001b8jiz\"2!\u0015*T!\ta\u0003\u0001C\u0003H\u000b\u0001\u0007\u0011\nC\u0003N\u000b\u0001\u0007\u0011*A\u0005fm\u0006dWK\\5p]V\ta\u000bE\u00037/fK\u0016,\u0003\u0002Yo\tIa)\u001e8di&|gN\r\t\u00035vk\u0011a\u0017\u0006\u00039~\tA!\u001e;jY&\u0011al\u0017\u0002\n\u0003J\u0014\u0018-\u001f#bi\u0006D#A\u00021\u0011\u0005Y\n\u0017B\u000128\u0005%!(/\u00198tS\u0016tG/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002fQ*\u0004\"A\u000e4\n\u0005\u001d<$aA!os\")\u0011n\u0002a\u0001K\u00061\u0011N\u001c9viFBQa[\u0004A\u0002\u0015\fa!\u001b8qkR\u0014\u0014!\u00033p\u000f\u0016t7i\u001c3f)\rqG/\u001f\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003cv\tqaY8eK\u001e,g.\u0003\u0002ta\nAQ\t\u001f9s\u0007>$W\rC\u0003v\u0011\u0001\u0007a/A\u0002dib\u0004\"a\\<\n\u0005a\u0004(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006u\"\u0001\rA\\\u0001\u0003KZ\f!\u0002\u001d:fiRLh*Y7f+\u0005i\bc\u0001@\u0002\u00069\u0019q0!\u0001\u0011\u0005y:\u0014bAA\u0002o\u00051\u0001K]3eK\u001aLA!a\u0002\u0002\n\t11\u000b\u001e:j]\u001eT1!a\u00018\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003R\u0003\u001f\t\u0019\u0002\u0003\u0004\u0002\u0012)\u0001\r!S\u0001\b]\u0016<H*\u001a4u\u0011\u0019\t)B\u0003a\u0001\u0013\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLH#B)\u0002\u001c\u0005u\u0001bB$\f!\u0003\u0005\r!\u0013\u0005\b\u001b.\u0001\n\u00111\u0001J\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\t+\u0007%\u000b)c\u000b\u0002\u0002(A!\u0011\u0011FA\u001a\u001b\t\tYC\u0003\u0003\u0002.\u0005=\u0012!C;oG\",7m[3e\u0015\r\t\tdN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001b\u0003W\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u001f!\u0011\ty$!\u0013\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\nA\u0001\\1oO*\u0011\u0011qI\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\b\u0005\u0005\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA(!\r1\u0014\u0011K\u0005\u0004\u0003':$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA3\u0002Z!I\u00111\f\t\u0002\u0002\u0003\u0007\u0011qJ\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0005\u0004#BA2\u0003S*WBAA3\u0015\r\t9gN\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA6\u0003K\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011OA<!\r1\u00141O\u0005\u0004\u0003k:$a\u0002\"p_2,\u0017M\u001c\u0005\t\u00037\u0012\u0012\u0011!a\u0001K\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\ti$! \t\u0013\u0005m3#!AA\u0002\u0005=\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002r\u0005\r\u0005\u0002CA.)\u0005\u0005\t\u0019A3)'\u0001\t9)!$\u0002\u0010\u0006M\u0015QSAM\u00037\u000by*!)\u0011\u00071\nI)C\u0002\u0002\fv\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0012\u0006q(\u0002\t\u0011!A}3UKT\"`Q\u0005\u0014(/Y=2Y\u0001\n'O]1ze%\u0002S\u0006\t*fiV\u0014hn\u001d\u0011b]\u0002\n'O]1zA=4\u0007\u0005\u001e5fA\u0015dW-\\3oiN\u0004\u0013N\u001c\u0011uQ\u0016\u0004SO\\5p]\u0002zg\rI1se\u0006L\u0018\u0007I1oI\u0002\n'O]1ze1R\u0001\u0005\t\u0011!A\u0001:\u0018\u000e\u001e5pkR\u0004C-\u001e9mS\u000e\fG/Z:/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005]\u0015!\u0017\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00152Y\u0001\u0012D\u0006I\u001a*Y\u0001\n'O]1zQEb\u0003e\r\u0017!k%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.2YIb3\u0007L\u001b^\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAO\u0003-\t'O]1z?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005\r\u0016!\u0002\u001a/i9\u0002\u0014AC!se\u0006LXK\\5p]B\u0011AFF\n\u0006-\u0005-\u0016q\u0017\t\b\u0003[\u000b\u0019,S%R\u001b\t\tyKC\u0002\u00022^\nqA];oi&lW-\u0003\u0003\u00026\u0006=&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011\u0011XA`\u001b\t\tYL\u0003\u0003\u0002>\u0006\u0015\u0013AA5p\u0013\r)\u00151\u0018\u000b\u0003\u0003O\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003{\tQ!\u00199qYf$R!UAf\u0003\u001bDQaR\rA\u0002%CQ!T\rA\u0002%\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002T\u0006}\u0007#\u0002\u001c\u0002V\u0006e\u0017bAAlo\t1q\n\u001d;j_:\u0004RANAn\u0013&K1!!88\u0005\u0019!V\u000f\u001d7fe!A\u0011\u0011\u001d\u000e\u0002\u0002\u0003\u0007\u0011+A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a:\u0011\t\u0005}\u0012\u0011^\u0005\u0005\u0003W\f\tE\u0001\u0004PE*,7\r\u001e")
public class ArrayUnion
extends BinaryExpression
implements ArrayBinaryLike,
ComplexTypeMergingExpression,
Serializable {
    private transient Function2<ArrayData, ArrayData, ArrayData> evalUnion;
    private final Expression left;
    private final Expression right;
    private transient scala.collection.immutable.Seq<DataType> inputTypesForMerging;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private transient boolean canUseSpecializedHashSet;
    private transient Ordering<Object> ordering;
    private Tuple2<String, String> org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71;
    private transient String hsPostFix;
    private transient String hsTypeName;
    private transient String hsValueCast;
    private transient String nullValueHolder;
    private transient DataType elementType;
    private volatile transient int bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayUnion x$0) {
        return ArrayUnion$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayUnion> tupled() {
        return ArrayUnion$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayUnion>> curried() {
        return ArrayUnion$.MODULE$.curried();
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public DataType dataType() {
        return ComplexTypeMergingExpression.dataType$(this);
    }

    @Override
    public /* synthetic */ TypeCheckResult org$apache$spark$sql$catalyst$expressions$ArrayBinaryLike$$super$checkInputDataTypes() {
        return BinaryArrayExpressionWithImplicitCast.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullIntolerant() {
        return ArrayBinaryLike.nullIntolerant$(this);
    }

    @Override
    public DataType dt() {
        return ArrayBinaryLike.dt$(this);
    }

    @Override
    public DataType et() {
        return ArrayBinaryLike.et$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ArrayBinaryLike.checkInputDataTypes$(this);
    }

    @Override
    public boolean resultArrayElementNullable() {
        return ArraySetLike.resultArrayElementNullable$(this);
    }

    @Override
    public String genGetValue(String array, String i) {
        return ArraySetLike.genGetValue$(this, array, i);
    }

    @Override
    public String withResultArrayNullCheck(String body, String value, String nullElementIndex) {
        return ArraySetLike.withResultArrayNullCheck$(this, body, value, nullElementIndex);
    }

    @Override
    public String buildResultArray(String builder, String value, String size, String nullElementIndex, String functionName) {
        return ArraySetLike.buildResultArray$(this, builder, value, size, nullElementIndex, functionName);
    }

    @Override
    public scala.collection.immutable.Seq<AbstractDataType> inputTypes() {
        return BinaryArrayExpressionWithImplicitCast.inputTypes$(this);
    }

    @Override
    public boolean leftArrayElementNullable() {
        return BinaryArrayExpressionWithImplicitCast.leftArrayElementNullable$(this);
    }

    @Override
    public boolean rightArrayElementNullable() {
        return BinaryArrayExpressionWithImplicitCast.rightArrayElementNullable$(this);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(scala.collection.immutable.Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    private scala.collection.immutable.Seq<DataType> inputTypesForMerging$lzycompute() {
        ArrayUnion arrayUnion = this;
        synchronized (arrayUnion) {
            if ((this.bitmap$trans$0 & 2) == 0) {
                this.inputTypesForMerging = ComplexTypeMergingExpression.inputTypesForMerging$(this);
                this.bitmap$trans$0 |= 2;
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public scala.collection.immutable.Seq<DataType> inputTypesForMerging() {
        if ((this.bitmap$trans$0 & 2) == 0) {
            return this.inputTypesForMerging$lzycompute();
        }
        return this.inputTypesForMerging;
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        ArrayUnion arrayUnion = this;
        synchronized (arrayUnion) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    private boolean canUseSpecializedHashSet$lzycompute() {
        ArrayUnion arrayUnion = this;
        synchronized (arrayUnion) {
            if ((this.bitmap$trans$0 & 4) == 0) {
                this.canUseSpecializedHashSet = ArraySetLike.canUseSpecializedHashSet$(this);
                this.bitmap$trans$0 |= 4;
            }
        }
        return this.canUseSpecializedHashSet;
    }

    @Override
    public boolean canUseSpecializedHashSet() {
        if ((this.bitmap$trans$0 & 4) == 0) {
            return this.canUseSpecializedHashSet$lzycompute();
        }
        return this.canUseSpecializedHashSet;
    }

    private Ordering<Object> ordering$lzycompute() {
        ArrayUnion arrayUnion = this;
        synchronized (arrayUnion) {
            if ((this.bitmap$trans$0 & 8) == 0) {
                this.ordering = ArraySetLike.ordering$(this);
                this.bitmap$trans$0 |= 8;
            }
        }
        return this.ordering;
    }

    @Override
    public Ordering<Object> ordering() {
        if ((this.bitmap$trans$0 & 8) == 0) {
            return this.ordering$lzycompute();
        }
        return this.ordering;
    }

    private Tuple2<String, String> org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71$lzycompute() {
        ArrayUnion arrayUnion = this;
        synchronized (arrayUnion) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71 = ArraySetLike.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71;
    }

    @Override
    public /* synthetic */ Tuple2 org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71;
    }

    private String hsPostFix$lzycompute() {
        ArrayUnion arrayUnion = this;
        synchronized (arrayUnion) {
            if ((this.bitmap$trans$0 & 0x10) == 0) {
                this.hsPostFix = ArraySetLike.hsPostFix$(this);
                this.bitmap$trans$0 |= 0x10;
            }
        }
        return this.hsPostFix;
    }

    @Override
    public String hsPostFix() {
        if ((this.bitmap$trans$0 & 0x10) == 0) {
            return this.hsPostFix$lzycompute();
        }
        return this.hsPostFix;
    }

    private String hsTypeName$lzycompute() {
        ArrayUnion arrayUnion = this;
        synchronized (arrayUnion) {
            if ((this.bitmap$trans$0 & 0x20) == 0) {
                this.hsTypeName = ArraySetLike.hsTypeName$(this);
                this.bitmap$trans$0 |= 0x20;
            }
        }
        return this.hsTypeName;
    }

    @Override
    public String hsTypeName() {
        if ((this.bitmap$trans$0 & 0x20) == 0) {
            return this.hsTypeName$lzycompute();
        }
        return this.hsTypeName;
    }

    private String hsValueCast$lzycompute() {
        ArrayUnion arrayUnion = this;
        synchronized (arrayUnion) {
            if ((this.bitmap$trans$0 & 0x40) == 0) {
                this.hsValueCast = ArraySetLike.hsValueCast$(this);
                this.bitmap$trans$0 |= 0x40;
            }
        }
        return this.hsValueCast;
    }

    @Override
    public String hsValueCast() {
        if ((this.bitmap$trans$0 & 0x40) == 0) {
            return this.hsValueCast$lzycompute();
        }
        return this.hsValueCast;
    }

    private String nullValueHolder$lzycompute() {
        ArrayUnion arrayUnion = this;
        synchronized (arrayUnion) {
            if ((this.bitmap$trans$0 & 0x80) == 0) {
                this.nullValueHolder = ArraySetLike.nullValueHolder$(this);
                this.bitmap$trans$0 |= 0x80;
            }
        }
        return this.nullValueHolder;
    }

    @Override
    public String nullValueHolder() {
        if ((this.bitmap$trans$0 & 0x80) == 0) {
            return this.nullValueHolder$lzycompute();
        }
        return this.nullValueHolder;
    }

    private DataType elementType$lzycompute() {
        ArrayUnion arrayUnion = this;
        synchronized (arrayUnion) {
            if ((this.bitmap$trans$0 & 0x100) == 0) {
                this.elementType = BinaryArrayExpressionWithImplicitCast.elementType$(this);
                this.bitmap$trans$0 |= 0x100;
            }
        }
        return this.elementType;
    }

    @Override
    public DataType elementType() {
        if ((this.bitmap$trans$0 & 0x100) == 0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private Function2<ArrayData, ArrayData, ArrayData> evalUnion$lzycompute() {
        ArrayUnion arrayUnion = this;
        synchronized (arrayUnion) {
            if ((this.bitmap$trans$0 & 1) == 0) {
                this.evalUnion = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? (Function2 & Serializable)(array1, array2) -> {
                    ArrayBuffer arrayBuffer = new ArrayBuffer();
                    SQLOpenHashSet<Object> hs = new SQLOpenHashSet<Object>(ClassTag$.MODULE$.Any());
                    Function1<Object, BoxedUnit> withNaNCheckFunc = SQLOpenHashSet$.MODULE$.withNaNCheckFunc(this.elementType(), hs, (Function1<Object, BoxedUnit>)(Function1 & Serializable)value -> {
                        ArrayUnion.$anonfun$evalUnion$2(this, hs, arrayBuffer, value);
                        return BoxedUnit.UNIT;
                    }, (Function1<Object, BoxedUnit>)(Function1 & Serializable)valueNaN -> {
                        arrayBuffer.$plus$eq(valueNaN);
                        return BoxedUnit.UNIT;
                    });
                    Function2<ArrayData, Object, BoxedUnit> withNullCheckFunc = SQLOpenHashSet$.MODULE$.withNullCheckFunc(this.elementType(), hs, (Function1<Object, BoxedUnit>)(Function1 & Serializable)value -> {
                        withNaNCheckFunc.apply(value);
                        return BoxedUnit.UNIT;
                    }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> arrayBuffer.$plus$eq(null));
                    new .colon.colon(array1, (List)new .colon.colon(array2, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)array -> {
                        ArrayUnion.$anonfun$evalUnion$6(withNullCheckFunc, array);
                        return BoxedUnit.UNIT;
                    });
                    return new GenericArrayData((Seq<Object>)arrayBuffer);
                } : (Function2 & Serializable)(array1, array2) -> {
                    ArrayBuffer arrayBuffer = new ArrayBuffer();
                    BooleanRef alreadyIncludeNull = BooleanRef.create((boolean)false);
                    new .colon.colon(array1, (List)new .colon.colon(array2, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)x$72 -> {
                        x$72.foreach(this.elementType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(x$73, elem) -> {
                            ArrayUnion.$anonfun$evalUnion$9($this, alreadyIncludeNull$1, arrayBuffer$4, BoxesRunTime.unboxToInt((Object)x$73), elem);
                            return BoxedUnit.UNIT;
                        });
                        return BoxedUnit.UNIT;
                    });
                    return new GenericArrayData((Seq<Object>)arrayBuffer);
                };
                this.bitmap$trans$0 |= 1;
            }
        }
        return this.evalUnion;
    }

    public Function2<ArrayData, ArrayData, ArrayData> evalUnion() {
        if ((this.bitmap$trans$0 & 1) == 0) {
            return this.evalUnion$lzycompute();
        }
        return this.evalUnion;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        ArrayData array1 = (ArrayData)input1;
        ArrayData array2 = (ArrayData)input2;
        return this.evalUnion().apply((Object)array1, (Object)array2);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String i = ctx.freshName("i");
        String value = ctx.freshName("value");
        String size = ctx.freshName("size");
        if (this.canUseSpecializedHashSet()) {
            String jt = CodeGenerator$.MODULE$.javaType(this.elementType());
            String ptName = CodeGenerator$.MODULE$.primitiveTypeName(jt);
            return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(array1, array2) -> {
                String nullElementIndex = ctx.freshName("nullElementIndex");
                String builder = ctx.freshName("builder");
                String array3 = ctx.freshName("array");
                String arrays = ctx.freshName("arrays");
                String arrayDataIdx = ctx.freshName("arrayDataIdx");
                String openHashSet = SQLOpenHashSet.class.getName();
                String classTag = "scala.reflect.ClassTag$.MODULE$." + this.hsTypeName() + "()";
                String hashSet = ctx.freshName("hashSet");
                String arrayBuilder = ArrayBuilder.class.getName();
                String arrayBuilderClass = arrayBuilder + "$of" + ptName;
                String body = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |if (!" + hashSet + ".contains(" + this.hsValueCast() + value + ")) {\n             |  if (++" + size + " > " + 0x7FFFFFF0 + ") {\n             |    break;\n             |  }\n             |  " + hashSet + ".add" + this.hsPostFix() + "(" + this.hsValueCast() + value + ");\n             |  " + builder + ".$plus$eq(" + value + ");\n             |}\n           "));
                Function2 & Serializable withNaNCheckCodeGenerator = (Function2 & Serializable)(array, index) -> jt + " " + value + " = " + this.genGetValue((String)array, (String)index) + ";" + SQLOpenHashSet$.MODULE$.withNaNCheckCode(this.elementType(), value, hashSet, body, (Function1<String, String>)(Function1 & Serializable)valueNaN -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                   |" + size + "++;\n                   |" + builder + ".$plus$eq(" + valueNaN + ");\n                     ")));
                String processArray = SQLOpenHashSet$.MODULE$.withNullCheckCode(this.resultArrayElementNullable(), this.resultArrayElementNullable(), array3, i, hashSet, (Function2<String, String, String>)withNaNCheckCodeGenerator, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |" + nullElementIndex + " = " + size + ";\n             |" + size + "++;\n             |" + builder + ".$plus$eq(" + this.nullValueHolder() + ");\n           ")));
                String declareNullTrackVariables = this.resultArrayElementNullable() ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |int " + nullElementIndex + " = -1;\n           ")) : "";
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |" + openHashSet + " " + hashSet + " = new " + openHashSet + this.hsPostFix() + "(" + classTag + ");\n           |" + declareNullTrackVariables + "\n           |int " + size + " = 0;\n           |" + arrayBuilderClass + " " + builder + " = new " + arrayBuilderClass + "();\n           |ArrayData[] " + arrays + " = new ArrayData[]{" + array1 + ", " + array2 + "};\n           |for (int " + arrayDataIdx + " = 0; " + arrayDataIdx + " < 2; " + arrayDataIdx + "++) {\n           |  ArrayData " + array3 + " = " + arrays + "[" + arrayDataIdx + "];\n           |  for (int " + i + " = 0; " + i + " < " + array3 + ".numElements(); " + i + "++) {\n           |    " + processArray + "\n           |  }\n           |}\n           |" + this.buildResultArray(builder, ExprValue$.MODULE$.exprValueToString(ev.value()), size, nullElementIndex, this.prettyName()) + "\n         "));
            });
        }
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(array1, array2) -> {
            String expr = ctx.addReferenceObj("arrayUnionExpr", this, ctx.addReferenceObj$default$3());
            return ev.value() + " = (ArrayData)" + expr + ".nullSafeEval(" + array1 + ", " + array2 + ");";
        });
    }

    @Override
    public String prettyName() {
        return "array_union";
    }

    @Override
    public ArrayUnion withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArrayUnion copy(Expression left, Expression right) {
        return new ArrayUnion(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayUnion";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayUnion;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayUnion)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayUnion arrayUnion = (ArrayUnion)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayUnion.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayUnion.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayUnion.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$evalUnion$2(ArrayUnion $this, SQLOpenHashSet hs$2, ArrayBuffer arrayBuffer$3, Object value) {
        if (!hs$2.contains(value)) {
            if (arrayBuffer$3.size() > 0x7FFFFFF0) {
                throw QueryExecutionErrors$.MODULE$.arrayFunctionWithElementsExceedLimitError($this.prettyName(), arrayBuffer$3.size());
            }
            arrayBuffer$3.$plus$eq(value);
            hs$2.add(value);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$evalUnion$6(Function2 withNullCheckFunc$1, ArrayData array) {
        for (int i = 0; i < array.numElements(); ++i) {
            withNullCheckFunc$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i));
        }
    }

    public static final /* synthetic */ void $anonfun$evalUnion$9(ArrayUnion $this, BooleanRef alreadyIncludeNull$1, ArrayBuffer arrayBuffer$4, int x$73, Object elem) {
        boolean found = false;
        if (elem == null) {
            if (alreadyIncludeNull$1.elem) {
                found = true;
            } else {
                alreadyIncludeNull$1.elem = true;
            }
        } else {
            for (int j = 0; !found && j < arrayBuffer$4.size(); ++j) {
                Object va = arrayBuffer$4.apply(j);
                if (va == null || !$this.ordering().equiv(va, elem)) continue;
                found = true;
            }
        }
        if (!found) {
            if (arrayBuffer$4.length() > 0x7FFFFFF0) {
                throw QueryExecutionErrors$.MODULE$.arrayFunctionWithElementsExceedLimitError($this.prettyName(), arrayBuffer$4.length());
            }
            arrayBuffer$4.$plus$eq(elem);
            return;
        }
    }

    public ArrayUnion(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        BinaryArrayExpressionWithImplicitCast.$init$(this);
        ArraySetLike.$init$(this);
        ArrayBinaryLike.$init$(this);
        ComplexTypeMergingExpression.$init$(this);
    }
}

