/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.InterpretedOrdering;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.Collect;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.ListAgg$;
import org.apache.spark.sql.catalyst.expressions.aggregate.SupportsOrderingWithinGroup;
import org.apache.spark.sql.catalyst.types.PhysicalDataType$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.DataTypeErrors$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.ByteArray;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ExpressionDescription(usage="\n    _FUNC_(expr[, delimiter])[ WITHIN GROUP (ORDER BY key [ASC | DESC] [,...])] - Returns\n    the concatenation of non-NULL input values, separated by the delimiter ordered by key.\n    If all values are NULL, NULL is returned.\n    ", arguments="\n    Arguments:\n      * expr - a string or binary expression to be concatenated.\n      * delimiter - an optional string or binary foldable expression used to separate the input values.\n        If NULL, the concatenation will be performed without a delimiter. Default is NULL.\n      * key - an optional expression for ordering the input values. Multiple keys can be specified.\n        If none are specified, the order of the rows in the result is non-deterministic.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES ('a'), ('b'), ('c') AS tab(col);\n       abc\n      > SELECT _FUNC_(col) WITHIN GROUP (ORDER BY col DESC) FROM VALUES ('a'), ('b'), ('c') AS tab(col);\n       cba\n      > SELECT _FUNC_(col) FROM VALUES ('a'), (NULL), ('b') AS tab(col);\n       ab\n      > SELECT _FUNC_(col) FROM VALUES ('a'), ('a') AS tab(col);\n       aa\n      > SELECT _FUNC_(DISTINCT col) FROM VALUES ('a'), ('a'), ('b') AS tab(col);\n       ab\n      > SELECT _FUNC_(col, ', ') FROM VALUES ('a'), ('b'), ('c') AS tab(col);\n       a, b, c\n      > SELECT _FUNC_(col) FROM VALUES (NULL), (NULL) AS tab(col);\n       NULL\n  ", note="\n    * If the order is not specified, the function is non-deterministic because\n    the order of the rows may be non-deterministic after a shuffle.\n    * If DISTINCT is specified, then expr and key must be the same expression.\n  ", group="agg_funcs", since="4.0.0")
@ScalaSignature(bytes="\u0006\u0005\rmc\u0001B#G\u0001VC\u0001B \u0001\u0003\u0016\u0004%\ta \u0005\u000b\u0003\u000f\u0001!\u0011#Q\u0001\n\u0005\u0005\u0001\"CA\u0005\u0001\tU\r\u0011\"\u0001\u0000\u0011)\tY\u0001\u0001B\tB\u0003%\u0011\u0011\u0001\u0005\u000b\u0003\u001b\u0001!Q3A\u0005\u0002\u0005=\u0001BCA\u000f\u0001\tE\t\u0015!\u0003\u0002\u0012!Q\u0011q\u0004\u0001\u0003\u0016\u0004%\t!!\t\t\u0015\u0005%\u0002A!E!\u0002\u0013\t\u0019\u0003\u0003\u0006\u0002,\u0001\u0011)\u001a!C\u0001\u0003CA!\"!\f\u0001\u0005#\u0005\u000b\u0011BA\u0012\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!a\u0010\u0001\t\u0003\n\t\u0005C\u0004\u0002J\u0001!\t%!\u0011\t\u000f\u0005-\u0003\u0001\"\u0011\u0002B!9\u0011Q\n\u0001\u0005B\u0005=\u0003BCA.\u0001!\u0015\r\u0011\"\u0015\u0002^!Q\u00111\u000e\u0001\t\u0006\u0004%\t!!\u0011\t\u000f\u0005=\u0002\u0001\"\u0001\u0002n!9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0004bBA<\u0001\u0011\u0005\u0013\u0011\t\u0005\b\u0003s\u0002A\u0011IA>\u0011\u001d\ti\b\u0001C!\u0003\u007fBq!a#\u0001\t\u0003\ni\tC\u0004\u0002\u0014\u0002!\t%!&\t\r5\u0003A\u0011IAR\u0011\u001d\tI\f\u0001C!\u0003wCq!!2\u0001\t\u0003\n9\rC\u0004\u0002V\u0002!\t%a6\t\u0011\u0005u\u0007\u0001)C\u0005\u0003?D\u0001\"a9\u0001A\u0013%\u0011Q\u001d\u0005\t\u0003k\u0004\u0001\u0015\"\u0003\u0002x\"A\u00111 \u0001!\n\u0013\ti\u0010C\u0004\u0003 \u0001!\t%!\u0018\t\u000f\t\u0005\u0002\u0001\"\u0011\u0003$!A!1\u0006\u0001!\n\u0013\u0011i\u0003C\u0004\u00036\u0001!\tFa\u000e\t\u000f\tu\u0002\u0001\"\u0011\u0003@!A!1\t\u0001!\n\u0013\u0011)\u0005C\u0004\u0003L\u0001!\tF!\u0014\t\u0011\te\u0003\u0001)C\u0005\u00057B\u0011B!\u001a\u0001\u0003\u0003%\tAa\u001a\t\u0013\tM\u0004!%A\u0005\u0002\tU\u0004\"\u0003BF\u0001E\u0005I\u0011\u0001B;\u0011%\u0011i\tAI\u0001\n\u0003\u0011y\tC\u0005\u0003\u0014\u0002\t\n\u0011\"\u0001\u0003\u0016\"I!\u0011\u0014\u0001\u0012\u0002\u0013\u0005!Q\u0013\u0005\n\u00057\u0003\u0011\u0011!C!\u0005;C\u0011B!,\u0001\u0003\u0003%\t!!\t\t\u0013\t=\u0006!!A\u0005\u0002\tE\u0006\"\u0003B\\\u0001\u0005\u0005I\u0011\tB]\u0011%\u0011\u0019\rAA\u0001\n\u0003\u0011)\rC\u0005\u0003J\u0002\t\t\u0011\"\u0011\u0003L\"I!q\u001a\u0001\u0002\u0002\u0013\u0005#\u0011[\u0004\n\u0007\u00031\u0015\u0011!E\u0001\u0007\u00071\u0001\"\u0012$\u0002\u0002#\u00051Q\u0001\u0005\b\u0003_9D\u0011AB\u000f\u0011%\u0019ybNA\u0001\n\u000b\u001a\t\u0003C\u0005\u0004$]\n\t\u0011\"!\u0004&!I1\u0011G\u001c\u0012\u0002\u0013\u0005!Q\u000f\u0005\n\u0007g9\u0014\u0013!C\u0001\u0005\u001fC\u0011b!\u000e8#\u0003%\tA!&\t\u0013\r]r'%A\u0005\u0002\tU\u0005\"CB\u001do\u0005\u0005I\u0011QB\u001e\u0011%\u0019IeNI\u0001\n\u0003\u0011)\bC\u0005\u0004L]\n\n\u0011\"\u0001\u0003\u0010\"I1QJ\u001c\u0012\u0002\u0013\u0005!Q\u0013\u0005\n\u0007\u001f:\u0014\u0013!C\u0001\u0005+C\u0011b!\u00158\u0003\u0003%Iaa\u0015\u0003\u000f1K7\u000f^!hO*\u0011q\tS\u0001\nC\u001e<'/Z4bi\u0016T!!\u0013&\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u00172\u000b\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u001b:\u000b1a]9m\u0015\ty\u0005+A\u0003ta\u0006\u00148N\u0003\u0002R%\u00061\u0011\r]1dQ\u0016T\u0011aU\u0001\u0004_J<7\u0001A\n\u0007\u0001YC7n\u001c:\u0011\u0007]C&,D\u0001G\u0013\tIfIA\u0004D_2dWm\u0019;\u0011\u0007m\u0013G-D\u0001]\u0015\tif,A\u0004nkR\f'\r\\3\u000b\u0005}\u0003\u0017AC2pY2,7\r^5p]*\t\u0011-A\u0003tG\u0006d\u0017-\u0003\u0002d9\nY\u0011I\u001d:bs\n+hMZ3s!\t)g-D\u0001a\u0013\t9\u0007MA\u0002B]f\u0004\"aV5\n\u0005)4%aG*vaB|'\u000f^:Pe\u0012,'/\u001b8h/&$\b.\u001b8He>,\b\u000f\u0005\u0002m[6\t\u0001*\u0003\u0002o\u0011\n1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002fa&\u0011\u0011\u000f\u0019\u0002\b!J|G-^2u!\t\u00198P\u0004\u0002us:\u0011Q\u000f_\u0007\u0002m*\u0011q\u000fV\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005L!A\u001f1\u0002\u000fA\f7m[1hK&\u0011A0 \u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003u\u0002\fQa\u00195jY\u0012,\"!!\u0001\u0011\u00071\f\u0019!C\u0002\u0002\u0006!\u0013!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u0005IA-\u001a7j[&$XM]\u0001\u000bI\u0016d\u0017.\\5uKJ\u0004\u0013\u0001E8sI\u0016\u0014X\t\u001f9sKN\u001c\u0018n\u001c8t+\t\t\t\u0002E\u0003t\u0003'\t9\"C\u0002\u0002\u0016u\u00141aU3r!\ra\u0017\u0011D\u0005\u0004\u00037A%!C*peR|%\u000fZ3s\u0003Ey'\u000fZ3s\u000bb\u0004(/Z:tS>t7\u000fI\u0001\u0017[V$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fiV\u0011\u00111\u0005\t\u0004K\u0006\u0015\u0012bAA\u0014A\n\u0019\u0011J\u001c;\u0002/5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\u0004\u0013\u0001F5oaV$\u0018iZ4Ck\u001a4WM](gMN,G/A\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\u0002\rqJg.\u001b;?)1\t\u0019$!\u000e\u00028\u0005e\u00121HA\u001f!\t9\u0006\u0001\u0003\u0004\u007f\u0017\u0001\u0007\u0011\u0011\u0001\u0005\n\u0003\u0013Y\u0001\u0013!a\u0001\u0003\u0003A\u0011\"!\u0004\f!\u0003\u0005\r!!\u0005\t\u0013\u0005}1\u0002%AA\u0002\u0005\r\u0002\"CA\u0016\u0017A\u0005\t\u0019AA\u0012\u00039y'\u000fZ3sS:<g)\u001b7mK\u0012,\"!a\u0011\u0011\u0007\u0015\f)%C\u0002\u0002H\u0001\u0014qAQ8pY\u0016\fg.A\njg>\u0013H-\u001a:j]\u001el\u0015M\u001c3bi>\u0014\u00180A\njg\u0012K7\u000f^5oGR\u001cV\u000f\u001d9peR,G-A\fxSRDwJ\u001d3fe&twmV5uQ&twI]8vaR!\u0011\u0011KA,!\r9\u00161K\u0005\u0004\u0003+2%!E!hOJ,w-\u0019;f\rVt7\r^5p]\"9\u0011\u0011L\bA\u0002\u0005E\u0011aE8sI\u0016\u0014\u0018N\\4XSRD\u0017N\\$s_V\u0004\u0018!\u00052vM\u001a,'/\u00127f[\u0016tG\u000fV=qKV\u0011\u0011q\f\t\u0005\u0003C\n9'\u0004\u0002\u0002d)\u0019\u0011Q\r'\u0002\u000bQL\b/Z:\n\t\u0005%\u00141\r\u0002\t\t\u0006$\u0018\rV=qK\u0006\u0011b.Z3e'\u00064Xm\u0014:eKJ4\u0016\r\\;f)\u0011\t\u0019$a\u001c\t\ry\u0014\u0002\u0019AA\u0001)\u0019\t\u0019$a\u001d\u0002v!1ap\u0005a\u0001\u0003\u0003Aq!!\u0003\u0014\u0001\u0004\t\t!\u0001\u0005ok2d\u0017M\u00197f\u0003]\u0019'/Z1uK\u0006;wM]3hCRLwN\u001c\"vM\u001a,'\u000fF\u0001[\u0003u9\u0018\u000e\u001e5OK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$H\u0003BAA\u0003\u000f\u00032aVAB\u0013\r\t)I\u0012\u0002\u0014\u00136\u0004XM]1uSZ,\u0017iZ4sK\u001e\fG/\u001a\u0005\b\u0003\u00133\u0002\u0019AA\u0012\u0003eqWm^'vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u00027]LG\u000f\u001b(fo&s\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3u)\u0011\t\t)a$\t\u000f\u0005Eu\u00031\u0001\u0002$\u00059b.Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u000eI\u00164\u0017-\u001e7u%\u0016\u001cX\u000f\u001c;\u0016\u0005\u0005]\u0005#B3\u0002\u001a\u0006u\u0015bAANA\n1q\n\u001d;j_:\u00042\u0001\\AP\u0013\r\t\t\u000b\u0013\u0002\b\u0019&$XM]1m)\u0011\t)+!.\u0011\t\u0005\u001d\u0016q\u0016\b\u0005\u0003S\u000bY\u000b\u0005\u0002vA&\u0019\u0011Q\u00161\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t,a-\u0003\rM#(/\u001b8h\u0015\r\ti\u000b\u0019\u0005\b\u0003oK\u0002\u0019AA\"\u0003)I7\u000fR5ti&t7\r^\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAA_!\u0015\u0019\u00181CA`!\u0011\t\t'!1\n\t\u0005\r\u00171\r\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\"!!3\u0011\t\u0005-\u0017\u0011[\u0007\u0003\u0003\u001bT1!a4K\u0003!\tg.\u00197zg&\u001c\u0018\u0002BAj\u0003\u001b\u0014q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\u0005KZ\fG\u000eF\u0002e\u00033Da!a7\u001d\u0001\u0004Q\u0016A\u00022vM\u001a,'/\u0001\u0006t_J$()\u001e4gKJ$2AWAq\u0011\u0019\tY.\ba\u00015\u0006q!-\u001e4gKJ|%\u000fZ3sS:<WCAAt!\u0015\u0019\u0018\u0011^Aw\u0013\r\tY/ \u0002\t\u001fJ$WM]5oOB!\u0011q^Ay\u001b\u0005Q\u0015bAAz\u0015\nY\u0011J\u001c;fe:\fGNU8x\u0003M\u0019wN\\2biN[\u0017\u000e\u001d9j]\u001etU\u000f\u001c7t)\r!\u0017\u0011 \u0005\u0007\u00037|\u0002\u0019\u0001.\u0002#\u001d,G\u000fR3mS6LG/\u001a:WC2,X-\u0006\u0002\u0002\u0000B91O!\u0001\u0003\u0006\tM\u0011b\u0001B\u0002{\n1Q)\u001b;iKJ\u0004BAa\u0002\u0003\u00105\u0011!\u0011\u0002\u0006\u0005\u0003K\u0012YAC\u0002\u0003\u000e9\u000ba!\u001e8tC\u001a,\u0017\u0002\u0002B\t\u0005\u0013\u0011!\"\u0016+GqM#(/\u001b8h!\u0015)'Q\u0003B\r\u0013\r\u00119\u0002\u0019\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004K\nm\u0011b\u0001B\u000fA\n!!)\u001f;f\u0003!!\u0017\r^1UsB,\u0017AB;qI\u0006$X\rF\u0003[\u0005K\u00119\u0003\u0003\u0004\u0002\\\n\u0002\rA\u0017\u0005\b\u0005S\u0011\u0003\u0019AAw\u0003\u0015Ig\u000e];u\u0003=)g/\u00197Pe\u0012,'OV1mk\u0016\u001cH\u0003\u0002B\u0018\u0005c\u0001Ba]A\nI\"9!1G\u0012A\u0002\u00055\u0018aC5oi\u0016\u0014h.\u00197S_^\facY8om\u0016\u0014H\u000fV8Ck\u001a4WM]#mK6,g\u000e\u001e\u000b\u0004I\ne\u0002B\u0002B\u001eI\u0001\u0007A-A\u0003wC2,X-\u0001\u0005dQ&dGM]3o+\t\u0011\t\u0005E\u0003t\u0003'\t\t!A\tjg>\u0013H-\u001a:D_6\u0004\u0018\r^5cY\u0016$B!a\u0011\u0003H!9!\u0011\n\u0014A\u0002\u0005E\u0011!C:p[\u0016|%\u000fZ3s\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000e\u0006\u0003\u0002\u0002\t=\u0003b\u0002B)O\u0001\u0007!1K\u0001\f]\u0016<8\t[5mIJ,g\u000eE\u0003t\u0005+\n\t!C\u0002\u0003Xu\u0014!\"\u00138eKb,GmU3r\u0003Ay'\u000fZ3s-\u0006dW/Z:GS\u0016dG-\u0006\u0002\u0003^A)1/a\u0005\u0003`A!\u0011\u0011\rB1\u0013\u0011\u0011\u0019'a\u0019\u0003\u0017M#(/^2u\r&,G\u000eZ\u0001\u0005G>\u0004\u0018\u0010\u0006\u0007\u00024\t%$1\u000eB7\u0005_\u0012\t\b\u0003\u0005\u007fSA\u0005\t\u0019AA\u0001\u0011%\tI!\u000bI\u0001\u0002\u0004\t\t\u0001C\u0005\u0002\u000e%\u0002\n\u00111\u0001\u0002\u0012!I\u0011qD\u0015\u0011\u0002\u0003\u0007\u00111\u0005\u0005\n\u0003WI\u0003\u0013!a\u0001\u0003G\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003x)\"\u0011\u0011\u0001B=W\t\u0011Y\b\u0005\u0003\u0003~\t\u001dUB\u0001B@\u0015\u0011\u0011\tIa!\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BCA\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t%%q\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\tJ\u000b\u0003\u0002\u0012\te\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005/SC!a\t\u0003z\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003 B!!\u0011\u0015BV\u001b\t\u0011\u0019K\u0003\u0003\u0003&\n\u001d\u0016\u0001\u00027b]\u001eT!A!+\u0002\t)\fg/Y\u0005\u0005\u0003c\u0013\u0019+\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007\u0011\u0014\u0019\fC\u0005\u00036F\n\t\u00111\u0001\u0002$\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa/\u0011\u000b\tu&q\u00183\u000e\u0003yK1A!1_\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\r#q\u0019\u0005\t\u0005k\u001b\u0014\u0011!a\u0001I\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011yJ!4\t\u0013\tUF'!AA\u0002\u0005\r\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002D\tM\u0007\u0002\u0003B[k\u0005\u0005\t\u0019\u00013)7\u0001\u00119N!8\u0003`\n\r(Q\u001dBu\u0005W\u0014yO!=\u0003v\n](1 B\u007f!\ra'\u0011\\\u0005\u0004\u00057D%!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005C\f\u0011\u0011\u001b\u0006!A\u0001\u0002sLR+O\u0007~CS\r\u001f9s72\u0002C-\u001a7j[&$XM]/*7\u0002:\u0016\n\u0016%J\u001d\u0002:%kT+QA!z%\u000bR#SA\tK\u0006e[3zAm\u000b5k\u0011\u0011}A\u0011+5kQ/!72rcFL/*;\u0002j\u0003EU3ukJt7O\u0003\u0011!A\u0001\"\b.\u001a\u0011d_:\u001c\u0017\r^3oCRLwN\u001c\u0011pM\u0002rwN\\\u0017O+2c\u0005%\u001b8qkR\u0004c/\u00197vKNd\u0003e]3qCJ\fG/\u001a3!Ef\u0004C\u000f[3!I\u0016d\u0017.\\5uKJ\u0004sN\u001d3fe\u0016$\u0007EY=!W\u0016LhF\u0003\u0011!A\u0001Je\rI1mY\u00022\u0018\r\\;fg\u0002\n'/\u001a\u0011O+2cE\u0006\t(V\u00192\u0003\u0013n\u001d\u0011sKR,(O\\3e])\u0001\u0003\u0005\t\u0011\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018E\u0001Bt\u0003\r\u001d&\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011fqB\u0014\b%\f\u0011bAM$(/\u001b8hA=\u0014\bEY5oCJL\b%\u001a=qe\u0016\u001c8/[8oAQ|\u0007EY3!G>t7-\u0019;f]\u0006$X\r\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0011,G.[7ji\u0016\u0014\b%\f\u0011b]\u0002z\u0007\u000f^5p]\u0006d\u0007e\u001d;sS:<\u0007e\u001c:!E&t\u0017M]=!M>dG-\u00192mK\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011vg\u0016$\u0007\u0005^8!g\u0016\u0004\u0018M]1uK\u0002\"\b.\u001a\u0011j]B,H\u000f\t<bYV,7O\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!\u0013\u001a\u0004c*\u0016'MY\u0001\"\b.\u001a\u0011d_:\u001c\u0017\r^3oCRLwN\u001c\u0011xS2d\u0007EY3!a\u0016\u0014hm\u001c:nK\u0012\u0004s/\u001b;i_V$\b%\u0019\u0011eK2LW.\u001b;fe:\u0002C)\u001a4bk2$\b%[:!\u001dVcEJ\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!W\u0016L\b%\f\u0011b]\u0002z\u0007\u000f^5p]\u0006d\u0007%\u001a=qe\u0016\u001c8/[8oA\u0019|'\u000fI8sI\u0016\u0014\u0018N\\4!i\",\u0007%\u001b8qkR\u0004c/\u00197vKNt\u0003%T;mi&\u0004H.\u001a\u0011lKf\u001c\beY1oA\t,\u0007e\u001d9fG&4\u0017.\u001a3/\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001Je\r\t8p]\u0016\u0004\u0013M]3!gB,7-\u001b4jK\u0012d\u0003\u0005\u001e5fA=\u0014H-\u001a:!_\u001a\u0004C\u000f[3!e><8\u000fI5oAQDW\r\t:fgVdG\u000fI5tA9|g.\f3fi\u0016\u0014X.\u001b8jgRL7M\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0003n\u0006!YP\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015d_2L\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002Bs%Y\u0014*Y\u0001BsEY\u0014*Y\u0001BseY\u0014*A\u0005\u001b\u0006\u0005^1cQ\r|G.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!C\n\u001c'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2pY&\u0002s+\u0013+I\u0013:\u0003sIU(V!\u0002BsJ\u0015#F%\u0002\u0012\u0015\fI2pY\u0002\"UiU\"*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)O\u0005<\u0013\u0006\f\u0011)O\t<\u0013\u0006\f\u0011)O\r<\u0013\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u00192b\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u001aw\u000e\\\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u0015(C\u001eJC\u0006\t\u0015O+2c\u0015\u0006\f\u0011)O\t<\u0013\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003%\u00192\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\r|G.\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0014bO%b\u0003\u0005K\u0014bO%\u0002\u0013i\u0015\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0017M\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015E\u0013N#\u0016JT\"UA\r|G.\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0014bO%b\u0003\u0005K\u0014bO%b\u0003\u0005K\u0014cO%\u0002\u0013i\u0015\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001\n'M\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015d_2d\u0003e\n\u0017!O%\u0002cIU(NAY\u000bE*V#TA!:\u0013mJ\u0015-A!:#mJ\u0015-A!:3mJ\u0015!\u0003N\u0003C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011bY\u0001\u0012G\u0006I2\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\r|G.\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005\u000b(V\u00192KC\u0006\t\u0015O+2c\u0015\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003%\u0001\u0003o_R,\u0017E\u0001Bz\u0003\u0005-'\u0002\t\u0011!A)\u0002\u0013J\u001a\u0011uQ\u0016\u0004sN\u001d3fe\u0002J7\u000f\t8pi\u0002\u001a\b/Z2jM&,G\r\f\u0011uQ\u0016\u0004c-\u001e8di&|g\u000eI5tA9|g.\f3fi\u0016\u0014X.\u001b8jgRL7\r\t2fG\u0006,8/\u001a\u0006!A\u0001\u0002C\u000f[3!_J$WM\u001d\u0011pM\u0002\"\b.\u001a\u0011s_^\u001c\b%\\1zA\t,\u0007E\\8o[\u0011,G/\u001a:nS:L7\u000f^5dA\u00054G/\u001a:!C\u0002\u001a\b.\u001e4gY\u0016t#\u0002\t\u0011!A)\u0002\u0013J\u001a\u0011E\u0013N#\u0016JT\"UA%\u001c\be\u001d9fG&4\u0017.\u001a3-AQDWM\u001c\u0011fqB\u0014\b%\u00198eA-,\u0017\u0010I7vgR\u0004#-\u001a\u0011uQ\u0016\u00043/Y7fA\u0015D\bO]3tg&|gN\f\u0006!A\u0005)qM]8va\u0006\u0012!\u0011`\u0001\nC\u001e<wLZ;oGN\fQa]5oG\u0016\f#Aa@\u0002\u000bQr\u0003G\f\u0019\u0002\u000f1K7\u000f^!hOB\u0011qkN\n\u0006o\r\u001d11\u0003\t\u0011\u0007\u0013\u0019y!!\u0001\u0002\u0002\u0005E\u00111EA\u0012\u0003gi!aa\u0003\u000b\u0007\r5\u0001-A\u0004sk:$\u0018.\\3\n\t\rE11\u0002\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:,\u0004\u0003BB\u000b\u00077i!aa\u0006\u000b\t\re!qU\u0001\u0003S>L1\u0001`B\f)\t\u0019\u0019!\u0001\u0005u_N#(/\u001b8h)\t\u0011y*A\u0003baBd\u0017\u0010\u0006\u0007\u00024\r\u001d2\u0011FB\u0016\u0007[\u0019y\u0003\u0003\u0004\u007fu\u0001\u0007\u0011\u0011\u0001\u0005\n\u0003\u0013Q\u0004\u0013!a\u0001\u0003\u0003A\u0011\"!\u0004;!\u0003\u0005\r!!\u0005\t\u0013\u0005}!\b%AA\u0002\u0005\r\u0002\"CA\u0016uA\u0005\t\u0019AA\u0012\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq\"\u00199qYf$C-\u001a4bk2$H%N\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019id!\u0012\u0011\u000b\u0015\fIja\u0010\u0011\u001b\u0015\u001c\t%!\u0001\u0002\u0002\u0005E\u00111EA\u0012\u0013\r\u0019\u0019\u0005\u0019\u0002\u0007)V\u0004H.Z\u001b\t\u0013\r\u001ds(!AA\u0002\u0005M\u0012a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0007+\u0002BA!)\u0004X%!1\u0011\fBR\u0005\u0019y%M[3di\u0002")
public class ListAgg
extends Collect<ArrayBuffer<Object>>
implements SupportsOrderingWithinGroup,
ImplicitCastInputTypes,
Serializable {
    private DataType bufferElementType;
    private boolean needSaveOrderValue;
    private final Expression child;
    private final Expression delimiter;
    private final Seq<SortOrder> orderExpressions;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private volatile byte bitmap$0;

    public static int $lessinit$greater$default$5() {
        return ListAgg$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return ListAgg$.MODULE$.$lessinit$greater$default$4();
    }

    public static Seq<SortOrder> $lessinit$greater$default$3() {
        return ListAgg$.MODULE$.$lessinit$greater$default$3();
    }

    public static Expression $lessinit$greater$default$2() {
        return ListAgg$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple5<Expression, Expression, Seq<SortOrder>, Object, Object>> unapply(ListAgg x$0) {
        return ListAgg$.MODULE$.unapply(x$0);
    }

    public static int apply$default$5() {
        return ListAgg$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return ListAgg$.MODULE$.apply$default$4();
    }

    public static Seq<SortOrder> apply$default$3() {
        return ListAgg$.MODULE$.apply$default$3();
    }

    public static Expression apply$default$2() {
        return ListAgg$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple5<Expression, Expression, Seq<SortOrder>, Object, Object>, ListAgg> tupled() {
        return ListAgg$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Seq<SortOrder>, Function1<Object, Function1<Object, ListAgg>>>>> curried() {
        return ListAgg$.MODULE$.curried();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Expression delimiter() {
        return this.delimiter;
    }

    public Seq<SortOrder> orderExpressions() {
        return this.orderExpressions;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public boolean orderingFilled() {
        return this.orderExpressions().nonEmpty();
    }

    @Override
    public boolean isOrderingMandatory() {
        return false;
    }

    @Override
    public boolean isDistinctSupported() {
        return true;
    }

    @Override
    public AggregateFunction withOrderingWithinGroup(Seq<SortOrder> orderingWithinGroup) {
        Seq<SortOrder> x$1 = orderingWithinGroup;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$4();
        int x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$1, x$4, x$5);
    }

    private DataType bufferElementType$lzycompute() {
        ListAgg listAgg = this;
        synchronized (listAgg) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                DataType dataType;
                if (!this.needSaveOrderValue()) {
                    dataType = this.child().dataType();
                } else {
                    StructField structField = new StructField("value", this.child().dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                    dataType = StructType$.MODULE$.apply((Seq)this.orderValuesField().$plus$colon((Object)structField));
                }
                this.bufferElementType = dataType;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.bufferElementType;
    }

    @Override
    public DataType bufferElementType() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.bufferElementType$lzycompute();
        }
        return this.bufferElementType;
    }

    private boolean needSaveOrderValue$lzycompute() {
        ListAgg listAgg = this;
        synchronized (listAgg) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.needSaveOrderValue = !this.isOrderCompatible(this.orderExpressions());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.needSaveOrderValue;
    }

    public boolean needSaveOrderValue() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.needSaveOrderValue$lzycompute();
        }
        return this.needSaveOrderValue;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public ArrayBuffer<Object> createAggregationBuffer() {
        return ArrayBuffer$.MODULE$.empty();
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Seq<SortOrder> x$4 = this.copy$default$3();
        int x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, x$1, x$5);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Seq<SortOrder> x$4 = this.copy$default$3();
        int x$5 = this.copy$default$4();
        return this.copy(x$2, x$3, x$4, x$5, x$1);
    }

    @Override
    public Option<Literal> defaultResult() {
        return Option$.MODULE$.apply((Object)Literal$.MODULE$.create(null, this.dataType()));
    }

    @Override
    public String sql(boolean isDistinct) {
        String distinct = isDistinct ? "DISTINCT " : "";
        String withinGroup = this.orderingFilled() ? " WITHIN GROUP (ORDER BY " + ((IterableOnceOps)this.orderExpressions().map((Function1 & Serializable)x$4 -> x$4.sql())).mkString(", ") + ")" : "";
        return this.prettyName() + "(" + distinct + this.child().sql() + ", " + this.delimiter().sql() + ")" + withinGroup;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        TypeCollection typeCollection = TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), BinaryType$.MODULE$}));
        TypeCollection typeCollection2 = TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), BinaryType$.MODULE$, NullType$.MODULE$}));
        return (Seq)((SeqOps)((SeqOps)this.orderExpressions().map((Function1 & Serializable)x$5 -> AnyDataType$.MODULE$)).$plus$colon((Object)typeCollection2)).$plus$colon((Object)typeCollection);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult matchInputTypes = ExpectsInputTypes.checkInputDataTypes$(this);
        if (matchInputTypes.isFailure()) {
            return matchInputTypes;
        }
        if (!this.delimiter().foldable()) {
            return new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)DataTypeErrors$.MODULE$.toSQLId("delimiter")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)DataTypeErrors$.MODULE$.toSQLType((AbstractDataType)this.delimiter().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)TypeUtils$.MODULE$.toSQLExpr(this.delimiter()))}))));
        }
        DataType dataType = this.delimiter().dataType();
        NullType$ nullType$ = NullType$.MODULE$;
        if (!(dataType != null ? !dataType.equals(nullType$) : nullType$ != null)) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        DataType dataType2 = this.child().dataType();
        DataType dataType3 = this.delimiter().dataType();
        return TypeUtils$.MODULE$.checkForSameTypeInputExpr((Seq<DataType>)Nil$.MODULE$.$colon$colon((Object)dataType3).$colon$colon((Object)dataType2), this.prettyName());
    }

    @Override
    public Object eval(ArrayBuffer<Object> buffer) {
        if (buffer.nonEmpty()) {
            ArrayBuffer<Object> sortedBufferWithoutNulls = this.sortBuffer(buffer);
            return this.concatSkippingNulls(sortedBufferWithoutNulls);
        }
        return null;
    }

    private ArrayBuffer<Object> sortBuffer(ArrayBuffer<Object> buffer) {
        if (!this.orderingFilled()) {
            return buffer;
        }
        if (!this.needSaveOrderValue()) {
            SortOrder sortOrderExpression = (SortOrder)this.orderExpressions().head();
            Ordering ascendingOrdering = PhysicalDataType$.MODULE$.ordering(sortOrderExpression.dataType());
            SortDirection sortDirection = sortOrderExpression.direction();
            Ascending$ ascending$ = Ascending$.MODULE$;
            Ordering ordering = !(sortDirection != null ? !sortDirection.equals(ascending$) : ascending$ != null) ? ascendingOrdering : ascendingOrdering.reverse();
            return (ArrayBuffer)buffer.sorted(ordering);
        }
        return (ArrayBuffer)((StrictOptimizedIterableOps)buffer.sorted(this.bufferOrdering())).map((Function1 & Serializable)x$6 -> x$6.get(0, this.child().dataType()));
    }

    private Ordering<InternalRow> bufferOrdering() {
        Seq bufferSortOrder = (Seq)((IterableOps)this.orderExpressions().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                SortOrder originalOrder = (SortOrder)tuple2._1();
                int i = tuple2._2$mcI$sp();
                return originalOrder.copy(new BoundReference(i + 1, originalOrder.dataType(), originalOrder.child().nullable()), originalOrder.copy$default$2(), originalOrder.copy$default$3(), originalOrder.copy$default$4());
            }
            throw new MatchError((Object)tuple2);
        });
        return new InterpretedOrdering((Seq<SortOrder>)bufferSortOrder);
    }

    private Object concatSkippingNulls(ArrayBuffer<Object> buffer) {
        Left left;
        UTF8String delimiterValue;
        Right right;
        byte[] delimiterValue2;
        Either<UTF8String, byte[]> either = this.getDelimiterValue();
        if (either instanceof Right && (delimiterValue2 = (byte[])(right = (Right)either).value()) != null) {
            byte[] byArray = delimiterValue2;
            ArrayBuffer inputs = (ArrayBuffer)((StrictOptimizedIterableOps)buffer.filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ListAgg.$anonfun$concatSkippingNulls$1(x$7)))).map((Function1 & Serializable)x$8 -> (byte[])x$8);
            return ByteArray.concatWS((byte[])byArray, (byte[][])((byte[][])inputs.toSeq().toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)))));
        }
        if (either instanceof Left && (delimiterValue = (UTF8String)(left = (Left)either).value()) != null) {
            UTF8String uTF8String = delimiterValue;
            ArrayBuffer inputs = (ArrayBuffer)((StrictOptimizedIterableOps)buffer.filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ListAgg.$anonfun$concatSkippingNulls$3(x$9)))).map((Function1 & Serializable)x$10 -> (UTF8String)x$10);
            return UTF8String.concatWs((UTF8String)uTF8String, (UTF8String[])((UTF8String[])inputs.toSeq().toArray(ClassTag$.MODULE$.apply(UTF8String.class))));
        }
        throw new MatchError(either);
    }

    private Either<UTF8String, byte[]> getDelimiterValue() {
        Object delimiterValue = this.delimiter().eval(this.delimiter().eval$default$1());
        DataType dataType = this.dataType();
        if (dataType instanceof StringType) {
            return new Left((Object)(delimiterValue == null ? UTF8String.fromString((String)"") : (UTF8String)delimiterValue));
        }
        if (dataType instanceof BinaryType) {
            return new Right((Object)(delimiterValue == null ? ByteArray.EMPTY_BYTE : (byte[])delimiterValue));
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    @Override
    public ArrayBuffer<Object> update(ArrayBuffer<Object> buffer, InternalRow input) {
        Object value = this.child().eval(input);
        if (value != null) {
            Object object;
            if (!this.needSaveOrderValue()) {
                object = this.convertToBufferElement(value);
            } else {
                Object object2 = this.convertToBufferElement(value);
                object = InternalRow$.MODULE$.fromSeq((Seq<Object>)((Seq)this.evalOrderValues(input).$plus$colon(object2)));
            }
            Object v = object;
            v1 = buffer.$plus$eq(v);
        } else {
            v1 = BoxedUnit.UNIT;
        }
        return buffer;
    }

    private Seq<Object> evalOrderValues(InternalRow internalRow) {
        return (Seq)this.orderExpressions().map((Function1 & Serializable)order -> this.convertToBufferElement(order.child().eval(internalRow)));
    }

    @Override
    public Object convertToBufferElement(Object value) {
        return InternalRow$.MODULE$.copyValue(value);
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.child();
        Expression expression2 = this.delimiter();
        return (Seq)((SeqOps)this.orderExpressions().$plus$colon((Object)expression2)).$plus$colon((Object)expression);
    }

    private boolean isOrderCompatible(Seq<SortOrder> someOrder) {
        if (someOrder.isEmpty()) {
            return true;
        }
        return someOrder.size() == 1 && ((SortOrder)someOrder.head()).child().semanticEquals(this.child());
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.head(), (Expression)newChildren.apply(1), (Seq<SortOrder>)((Seq)((IndexedSeqOps)newChildren.drop(2)).map((Function1 & Serializable)x$11 -> (SortOrder)x$11)), this.copy$default$4(), this.copy$default$5());
    }

    private Seq<StructField> orderValuesField() {
        return (Seq)((IterableOps)this.orderExpressions().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                SortOrder order = (SortOrder)tuple2._1();
                int i = tuple2._2$mcI$sp();
                return new StructField("sortOrderValue[" + i + "]", order.dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public ListAgg copy(Expression child, Expression delimiter, Seq<SortOrder> orderExpressions, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ListAgg(child, delimiter, orderExpressions, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.delimiter();
    }

    public Seq<SortOrder> copy$default$3() {
        return this.orderExpressions();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ListAgg";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.delimiter();
            }
            case 2: {
                return this.orderExpressions();
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 4: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ListAgg;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "delimiter";
            }
            case 2: {
                return "orderExpressions";
            }
            case 3: {
                return "mutableAggBufferOffset";
            }
            case 4: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ListAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        ListAgg listAgg = (ListAgg)x$1;
        if (this.mutableAggBufferOffset() != listAgg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != listAgg.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = listAgg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.delimiter();
        Expression expression4 = listAgg.delimiter();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Seq<SortOrder> seq = this.orderExpressions();
        Seq<SortOrder> seq2 = listAgg.orderExpressions();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!listAgg.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$concatSkippingNulls$1(Object x$7) {
        return x$7 != null;
    }

    public static final /* synthetic */ boolean $anonfun$concatSkippingNulls$3(Object x$9) {
        return x$9 != null;
    }

    public ListAgg(Expression child, Expression delimiter, Seq<SortOrder> orderExpressions, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.delimiter = delimiter;
        this.orderExpressions = orderExpressions;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
    }

    public ListAgg(Expression child) {
        this(child, Literal$.MODULE$.apply(null), (Seq<SortOrder>)Nil$.MODULE$, 0, 0);
    }

    public ListAgg(Expression child, Expression delimiter) {
        this(child, delimiter, (Seq<SortOrder>)Nil$.MODULE$, 0, 0);
    }
}

