/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.variant;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.expressions.variant.SchemaOfVariant$;
import org.apache.spark.sql.catalyst.expressions.variant.SchemaOfVariantAgg$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.types.variant.Variant;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.unsafe.types.VariantVal;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(v) - Returns the merged schema in the SQL format of a variant column.", examples="\n    Examples:\n      > SELECT _FUNC_(parse_json(j)) FROM VALUES ('1'), ('2'), ('3') AS tab(j);\n       BIGINT\n      > SELECT _FUNC_(parse_json(j)) FROM VALUES ('{\"a\": 1}'), ('{\"b\": true}'), ('{\"c\": 1.23}') AS tab(j);\n       OBJECT<a: BIGINT, b: BOOLEAN, c: DECIMAL(3,2)>\n  ", since="4.0.0", group="variant_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0015d\u0001B\u0014)\u0001^B\u0001\u0002\u001c\u0001\u0003\u0016\u0004%\t!\u001c\u0005\t]\u0002\u0011\t\u0012)A\u0005/\"Aq\u000e\u0001BK\u0002\u0013\u0005\u0003\u000f\u0003\u0005u\u0001\tE\t\u0015!\u0003r\u0011!)\bA!f\u0001\n\u0003\u0002\b\u0002\u0003<\u0001\u0005#\u0005\u000b\u0011B9\t\u000b]\u0004A\u0011\u0001=\t\u000b]\u0004A\u0011\u0001@\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u0011\u0011\u0003\u0001\u0005B\u0005M\u0001bBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003?\u0001A\u0011IA\u0011\u0011\u001d\t\u0019\u0004\u0001C!\u0003kAq!a\u000f\u0001\t\u0003\ni\u0004C\u0004\u0002H\u0001!\t%!\u0013\t\u000f\u0005e\u0003\u0001\"\u0011\u0002\\!9\u0011\u0011\r\u0001\u0005B\u0005\r\u0004bBA;\u0001\u0011\u0005\u0013q\u000f\u0005\b\u0003\u0007\u0003A\u0011IAC\u0011\u001d\tY\t\u0001C)\u0003\u001bC\u0011\"a%\u0001\u0003\u0003%\t!!&\t\u0013\u0005u\u0005!%A\u0005\u0002\u0005}\u0005\"CA[\u0001E\u0005I\u0011AA\\\u0011%\tY\fAI\u0001\n\u0003\t9\fC\u0005\u0002>\u0002\t\t\u0011\"\u0011\u0002@\"A\u0011q\u001a\u0001\u0002\u0002\u0013\u0005\u0001\u000fC\u0005\u0002R\u0002\t\t\u0011\"\u0001\u0002T\"I\u0011\u0011\u001c\u0001\u0002\u0002\u0013\u0005\u00131\u001c\u0005\n\u0003S\u0004\u0011\u0011!C\u0001\u0003WD\u0011\"a<\u0001\u0003\u0003%\t%!=\t\u0013\u0005U\b!!A\u0005B\u0005]x!\u0003B\u000eQ\u0005\u0005\t\u0012\u0001B\u000f\r!9\u0003&!A\t\u0002\t}\u0001BB<\"\t\u0003\u00119\u0004C\u0005\u0003:\u0005\n\t\u0011\"\u0012\u0003<!I!QH\u0011\u0002\u0002\u0013\u0005%q\b\u0005\n\u0005\u000f\n\u0013\u0011!CA\u0005\u0013B\u0011Ba\u0017\"\u0003\u0003%IA!\u0018\u0003%M\u001b\u0007.Z7b\u001f\u001a4\u0016M]5b]R\fum\u001a\u0006\u0003S)\nqA^1sS\u0006tGO\u0003\u0002,Y\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tic&\u0001\u0005dCR\fG._:u\u0015\ty\u0003'A\u0002tc2T!!\r\u001a\u0002\u000bM\u0004\u0018M]6\u000b\u0005M\"\u0014AB1qC\u000eDWMC\u00016\u0003\ry'oZ\u0002\u0001'!\u0001\u0001\b\u0012%O#j\u0003\u0007cA\u001d=}5\t!H\u0003\u0002<U\u0005I\u0011mZ4sK\u001e\fG/Z\u0005\u0003{i\u0012\u0001\u0004V=qK\u0012LU\u000e]3sCRLg/Z!hOJ,w-\u0019;f!\ty$)D\u0001A\u0015\t\te&A\u0003usB,7/\u0003\u0002D\u0001\nAA)\u0019;b)f\u0004X\r\u0005\u0002F\r6\t!&\u0003\u0002HU\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005%cU\"\u0001&\u000b\u0005-s\u0013AB3se>\u00148/\u0003\u0002N\u0015\ny\u0011+^3ss\u0016\u0013(o\u001c:t\u0005\u0006\u001cX\r\u0005\u0002F\u001f&\u0011\u0001K\u000b\u0002!\t\u00164\u0017-\u001e7u'R\u0014\u0018N\\4Qe>$WoY5oO\u0016C\bO]3tg&|g\u000eE\u0002S+^k\u0011a\u0015\u0006\u0003)2\nQ\u0001\u001e:fKNL!AV*\u0003\u0013Us\u0017M]=MS.,\u0007CA#Y\u0013\tI&F\u0001\u0006FqB\u0014Xm]:j_:\u0004\"a\u00170\u000e\u0003qS\u0011!X\u0001\u0006g\u000e\fG.Y\u0005\u0003?r\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002bS:\u0011!m\u001a\b\u0003G\u001al\u0011\u0001\u001a\u0006\u0003KZ\na\u0001\u0010:p_Rt\u0014\"A/\n\u0005!d\u0016a\u00029bG.\fw-Z\u0005\u0003U.\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u001b/\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003]\u000baa\u00195jY\u0012\u0004\u0013AF7vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0016\u0003E\u0004\"a\u0017:\n\u0005Md&aA%oi\u00069R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000fI\u0001\u0015S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0002+%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3uA\u00051A(\u001b8jiz\"B!_>}{B\u0011!\u0010A\u0007\u0002Q!)An\u0002a\u0001/\")qn\u0002a\u0001c\")Qo\u0002a\u0001cR\u0011\u0011p \u0005\u0006Y\"\u0001\raV\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAA\u0003!\u0015\t\u0017qAA\u0006\u0013\r\tIa\u001b\u0002\u0004'\u0016\f\bcA \u0002\u000e%\u0019\u0011q\u0002!\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00038vY2\f'\r\\3\u0016\u0005\u0005U\u0001cA.\u0002\u0018%\u0019\u0011\u0011\u0004/\u0003\u000f\t{w\u000e\\3b]\u000692M]3bi\u0016\fum\u001a:fO\u0006$\u0018n\u001c8Ck\u001a4WM\u001d\u000b\u0002}\u00051Q\u000f\u001d3bi\u0016$RAPA\u0012\u0003OAa!!\n\r\u0001\u0004q\u0014A\u00022vM\u001a,'\u000fC\u0004\u0002*1\u0001\r!a\u000b\u0002\u000b%t\u0007/\u001e;\u0011\t\u00055\u0012qF\u0007\u0002Y%\u0019\u0011\u0011\u0007\u0017\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0006}\u0005]\u0012\u0011\b\u0005\u0007\u0003Ki\u0001\u0019\u0001 \t\r\u0005%R\u00021\u0001?\u0003\u0011)g/\u00197\u0015\t\u0005}\u0012Q\t\t\u00047\u0006\u0005\u0013bAA\"9\n\u0019\u0011I\\=\t\r\u0005\u0015b\u00021\u0001?\u0003%\u0019XM]5bY&TX\r\u0006\u0003\u0002L\u0005]\u0003#B.\u0002N\u0005E\u0013bAA(9\n)\u0011I\u001d:bsB\u00191,a\u0015\n\u0007\u0005UCL\u0001\u0003CsR,\u0007BBA\u0013\u001f\u0001\u0007a(A\u0006eKN,'/[1mSj,Gc\u0001 \u0002^!9\u0011q\f\tA\u0002\u0005-\u0013!D:u_J\fw-\u001a$pe6\fG/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u001a\u0011\t\u0005\u001d\u0014q\u000e\b\u0005\u0003S\nY\u0007\u0005\u0002d9&\u0019\u0011Q\u000e/\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t(a\u001d\u0003\rM#(/\u001b8h\u0015\r\ti\u0007X\u0001\u001eo&$\bNT3x\u001bV$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fiR!\u0011\u0011PA@!\rI\u00141P\u0005\u0004\u0003{R$aE%na\u0016\u0014\u0018\r^5wK\u0006;wM]3hCR,\u0007BBAA%\u0001\u0007\u0011/A\roK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\u0018aG<ji\"tUm^%oaV$\u0018iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0003\u0002z\u0005\u001d\u0005BBAE'\u0001\u0007\u0011/A\foK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2aVAH\u0011\u0019\t\t\n\u0006a\u0001/\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLHcB=\u0002\u0018\u0006e\u00151\u0014\u0005\bYV\u0001\n\u00111\u0001X\u0011\u001dyW\u0003%AA\u0002EDq!^\u000b\u0011\u0002\u0003\u0007\u0011/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0005&fA,\u0002$.\u0012\u0011Q\u0015\t\u0005\u0003O\u000b\t,\u0004\u0002\u0002**!\u00111VAW\u0003%)hn\u00195fG.,GMC\u0002\u00020r\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019,!+\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005e&fA9\u0002$\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002BB!\u00111YAg\u001b\t\t)M\u0003\u0003\u0002H\u0006%\u0017\u0001\u00027b]\u001eT!!a3\u0002\t)\fg/Y\u0005\u0005\u0003c\n)-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005}\u0012Q\u001b\u0005\t\u0003/\\\u0012\u0011!a\u0001c\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!8\u0011\r\u0005}\u0017Q]A \u001b\t\t\tOC\u0002\u0002dr\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9/!9\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003+\ti\u000fC\u0005\u0002Xv\t\t\u00111\u0001\u0002@\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\t-a=\t\u0011\u0005]g$!AA\u0002E\fa!Z9vC2\u001cH\u0003BA\u000b\u0003sD\u0011\"a6 \u0003\u0003\u0005\r!a\u0010)'\u0001\tiPa\u0001\u0003\u0006\t%!1\u0002B\b\u0005#\u0011)Ba\u0006\u0011\u0007\u0015\u000by0C\u0002\u0003\u0002)\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003\b\u0005auLR+O\u0007~Cc/\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011nKJ<W\r\u001a\u0011tG\",W.\u0019\u0011j]\u0002\"\b.\u001a\u0011T#2\u0003cm\u001c:nCR\u0004sN\u001a\u0011bAY\f'/[1oi\u0002\u001aw\u000e\\;n]:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005\u001b\t!\u0011\u0005\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)a\u0006\u00148/Z0kg>t\u0007F[\u0015*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)OE:\u0013\u0006\f\u0011)OI:\u0013\u0006\f\u0011)OM:\u0013\u0006I!TAQ\f'\r\u000b6*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0015jR%O)*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0003/\u0019:tK~S7o\u001c8)U&J\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002Bse\u001f\u0012bEi\u0002\u0013'`\u0014*Y\u0001Bse\u001f\u0012cEi\u0002CO];f{\u001eJC\u0006\t\u0015(w\n\u001a'E\u000f\u00112]I\u001aTpJ\u0015!\u0003N\u0003C/\u00192)U&Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0014\"K\u000b\u000e#F(\u0019\u001e!\u0005&;\u0015J\u0014+-A\tT\u0004EQ(P\u0019\u0016\u000be\n\f\u0011du\u0001\"UiQ%N\u00032C3\u0007\f\u001a*})\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0003\u0014\u0005)AG\f\u0019/a\u0005)qM]8va\u0006\u0012!\u0011D\u0001\u000em\u0006\u0014\u0018.\u00198u?\u001a,hnY:\u0002%M\u001b\u0007.Z7b\u001f\u001a4\u0016M]5b]R\fum\u001a\t\u0003u\u0006\u001aR!\tB\u0011\u0005[\u0001\u0002Ba\t\u0003*]\u000b\u0018/_\u0007\u0003\u0005KQ1Aa\n]\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u000b\u0003&\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\t=\"QG\u0007\u0003\u0005cQAAa\r\u0002J\u0006\u0011\u0011n\\\u0005\u0004U\nEBC\u0001B\u000f\u0003!!xn\u0015;sS:<GCAAa\u0003\u0015\t\u0007\u000f\u001d7z)\u001dI(\u0011\tB\"\u0005\u000bBQ\u0001\u001c\u0013A\u0002]CQa\u001c\u0013A\u0002EDQ!\u001e\u0013A\u0002E\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003L\t]\u0003#B.\u0003N\tE\u0013b\u0001B(9\n1q\n\u001d;j_:\u0004ba\u0017B*/F\f\u0018b\u0001B+9\n1A+\u001e9mKNB\u0001B!\u0017&\u0003\u0003\u0005\r!_\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B0!\u0011\t\u0019M!\u0019\n\t\t\r\u0014Q\u0019\u0002\u0007\u001f\nTWm\u0019;")
public class SchemaOfVariantAgg
extends TypedImperativeAggregate<DataType>
implements ExpectsInputTypes,
QueryErrorsBase,
DefaultStringProducingExpression,
UnaryLike<Expression>,
Serializable {
    private final Expression child;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple3<Expression, Object, Object>> unapply(SchemaOfVariantAgg x$0) {
        return SchemaOfVariantAgg$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Object, Object>, SchemaOfVariantAgg> tupled() {
        return SchemaOfVariantAgg$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Function1<Object, SchemaOfVariantAgg>>> curried() {
        return SchemaOfVariantAgg$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public DataType dataType() {
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private Seq<Expression> children$lzycompute() {
        SchemaOfVariantAgg schemaOfVariantAgg = this;
        synchronized (schemaOfVariantAgg) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)VariantType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType createAggregationBuffer() {
        return NullType$.MODULE$;
    }

    @Override
    public DataType update(DataType buffer, InternalRow input) {
        VariantVal inputVariant = (VariantVal)this.child().eval(input);
        if (inputVariant != null) {
            Variant v = new Variant(inputVariant.getValue(), inputVariant.getMetadata());
            return SchemaOfVariant$.MODULE$.mergeSchema(buffer, SchemaOfVariant$.MODULE$.schemaOf(v));
        }
        return buffer;
    }

    @Override
    public DataType merge(DataType buffer, DataType input) {
        return SchemaOfVariant$.MODULE$.mergeSchema(buffer, input);
    }

    @Override
    public Object eval(DataType buffer) {
        return UTF8String.fromString((String)SchemaOfVariant$.MODULE$.printSchema(buffer));
    }

    @Override
    public byte[] serialize(DataType buffer) {
        return buffer.json().getBytes("UTF-8");
    }

    @Override
    public DataType deserialize(byte[] storageFormat) {
        return DataType$.MODULE$.fromJson(new String(storageFormat, "UTF-8"));
    }

    @Override
    public String prettyName() {
        return "schema_of_variant_agg";
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public Expression withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    public SchemaOfVariantAgg copy(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new SchemaOfVariantAgg(child, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public int copy$default$2() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$3() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "SchemaOfVariantAgg";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SchemaOfVariantAgg;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "mutableAggBufferOffset";
            }
            case 2: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SchemaOfVariantAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        SchemaOfVariantAgg schemaOfVariantAgg = (SchemaOfVariantAgg)x$1;
        if (this.mutableAggBufferOffset() != schemaOfVariantAgg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != schemaOfVariantAgg.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = schemaOfVariantAgg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!schemaOfVariantAgg.canEqual(this)) return false;
        return true;
    }

    public SchemaOfVariantAgg(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        DefaultStringProducingExpression.$init$(this);
        UnaryLike.$init$(this);
    }

    public SchemaOfVariantAgg(Expression child) {
        this(child, 0, 0);
    }
}

