/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class VersionInfo {
    private String major;
    private String minor;
    private Integer emulationMajor;
    private Integer emulationMinor;
    private Integer minCompatibilityMajor;
    private Integer minCompatibilityMinor;
    private String gitCommit;
    private String gitVersion;
    private String gitTreeState;
    private Date buildDate;
    private String goVersion;
    private String compiler;
    private String platform;

    private VersionInfo() {
    }

    @Generated
    public String getMajor() {
        return this.major;
    }

    @Generated
    public String getMinor() {
        return this.minor;
    }

    @Generated
    public Integer getEmulationMajor() {
        return this.emulationMajor;
    }

    @Generated
    public Integer getEmulationMinor() {
        return this.emulationMinor;
    }

    @Generated
    public Integer getMinCompatibilityMajor() {
        return this.minCompatibilityMajor;
    }

    @Generated
    public Integer getMinCompatibilityMinor() {
        return this.minCompatibilityMinor;
    }

    @Generated
    public String getGitCommit() {
        return this.gitCommit;
    }

    @Generated
    public String getGitVersion() {
        return this.gitVersion;
    }

    @Generated
    public String getGitTreeState() {
        return this.gitTreeState;
    }

    @Generated
    public Date getBuildDate() {
        return this.buildDate;
    }

    @Generated
    public String getGoVersion() {
        return this.goVersion;
    }

    @Generated
    public String getCompiler() {
        return this.compiler;
    }

    @Generated
    public String getPlatform() {
        return this.platform;
    }

    public static final class Builder {
        private String major;
        private String minor;
        private Integer emulationMajor;
        private Integer emulationMinor;
        private Integer minCompatibilityMajor;
        private Integer minCompatibilityMinor;
        private String gitCommit;
        private String gitVersion;
        private String gitTreeState;
        private Date buildDate;
        private String goVersion;
        private String compiler;
        private String platform;

        public Builder() {
        }

        public Builder(VersionInfo versionInfo) {
            if (versionInfo != null) {
                this.major = versionInfo.getMajor();
                this.minor = versionInfo.getMinor();
                this.emulationMajor = versionInfo.getEmulationMajor();
                this.emulationMinor = versionInfo.getEmulationMinor();
                this.minCompatibilityMajor = versionInfo.getMinCompatibilityMajor();
                this.minCompatibilityMinor = versionInfo.getMinCompatibilityMinor();
                this.gitCommit = versionInfo.getGitCommit();
                this.gitVersion = versionInfo.getGitVersion();
                this.gitTreeState = versionInfo.getGitTreeState();
                this.buildDate = versionInfo.getBuildDate();
                this.goVersion = versionInfo.getGoVersion();
                this.compiler = versionInfo.getCompiler();
                this.platform = versionInfo.getPlatform();
            }
        }

        public Builder withBuildDate(String buildDate) throws ParseException {
            if (buildDate != null) {
                this.buildDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX").parse(buildDate);
            }
            return this;
        }

        public Builder withMajor(String major) {
            this.major = major;
            return this;
        }

        public Builder withMinor(String minor) {
            this.minor = minor;
            return this;
        }

        public Builder withEmulationMajor(Integer emulationMajor) {
            this.emulationMajor = emulationMajor;
            return this;
        }

        public Builder withEmulationMinor(Integer emulationMinor) {
            this.emulationMinor = emulationMinor;
            return this;
        }

        public Builder withMinCompatibilityMajor(Integer minCompatibilityMajor) {
            this.minCompatibilityMajor = minCompatibilityMajor;
            return this;
        }

        public Builder withMinCompatibilityMinor(Integer minCompatibilityMinor) {
            this.minCompatibilityMinor = minCompatibilityMinor;
            return this;
        }

        public Builder withGitCommit(String gitCommit) {
            this.gitCommit = gitCommit;
            return this;
        }

        public Builder withGitVersion(String gitVersion) {
            this.gitVersion = gitVersion;
            return this;
        }

        public Builder withGitTreeState(String gitTreeState) {
            this.gitTreeState = gitTreeState;
            return this;
        }

        public Builder withBuildDate(Date buildDate) {
            this.buildDate = buildDate;
            return this;
        }

        public Builder withGoVersion(String goVersion) {
            this.goVersion = goVersion;
            return this;
        }

        public Builder withCompiler(String compiler) {
            this.compiler = compiler;
            return this;
        }

        public Builder withPlatform(String platform) {
            this.platform = platform;
            return this;
        }

        public VersionInfo build() {
            VersionInfo versionInfo = new VersionInfo();
            versionInfo.compiler = this.compiler;
            versionInfo.gitCommit = this.gitCommit;
            versionInfo.minCompatibilityMajor = this.minCompatibilityMajor;
            versionInfo.goVersion = this.goVersion;
            versionInfo.platform = this.platform;
            versionInfo.gitVersion = this.gitVersion;
            versionInfo.major = this.major;
            versionInfo.emulationMajor = this.emulationMajor;
            versionInfo.emulationMinor = this.emulationMinor;
            versionInfo.minor = this.minor;
            versionInfo.minCompatibilityMinor = this.minCompatibilityMinor;
            versionInfo.gitTreeState = this.gitTreeState;
            versionInfo.buildDate = this.buildDate;
            return versionInfo;
        }
    }

    public static final class VersionKeys {
        public static final String BUILD_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssX";

        private VersionKeys() {
        }
    }
}

