/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.timestamp.datetime;

import org.apache.hadoop.hive.ql.io.parquet.timestamp.datetime.DateTimeStamp;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.datetime.JDateTimeDefault;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.datetime.JulianDateStamp;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.datetime.TimeUtil;

public class JDateTime {
    public static final int MONDAY = 1;
    protected DateTimeStamp time = new DateTimeStamp();
    protected int dayofweek;
    protected int dayofyear;
    protected boolean leap;
    protected int weekofyear;
    protected int weekofmonth;
    protected JulianDateStamp jdate;
    private static final int[] NUM_DAYS = new int[]{-1, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final int[] LEAP_NUM_DAYS = new int[]{-1, 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    protected int firstDayOfWeek = JDateTimeDefault.firstDayOfWeek;
    protected int mustHaveDayOfFirstWeek = JDateTimeDefault.mustHaveDayOfFirstWeek;
    protected int minDaysInFirstWeek = JDateTimeDefault.minDaysInFirstWeek;

    public void setJulianDate(JulianDateStamp jds) {
        this.setJdOnly(jds.clone());
        this.calculateAdditionalData();
    }

    public int getJulianDayNumber() {
        return this.jdate.getJulianDayNumber();
    }

    private void calculateAdditionalData() {
        this.leap = TimeUtil.isLeapYear(this.time.year);
        this.dayofweek = this.calcDayOfWeek();
        this.dayofyear = this.calcDayOfYear();
        this.weekofyear = this.calcWeekOfYear(this.firstDayOfWeek, this.mustHaveDayOfFirstWeek);
        this.weekofmonth = this.calcWeekNumber(this.time.day, this.dayofweek);
    }

    private void setJdOnly(JulianDateStamp jds) {
        this.jdate = jds;
        this.time = TimeUtil.fromJulianDate(jds);
    }

    public void set(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        this.jdate = TimeUtil.toJulianDate(year, month, day, hour, minute, second, millisecond);
        if (TimeUtil.isValidDateTime(year, month, day, hour, minute, second, millisecond)) {
            this.time.year = year;
            this.time.month = month;
            this.time.day = day;
            this.time.hour = hour;
            this.time.minute = minute;
            this.time.second = second;
            this.time.millisecond = millisecond;
            this.calculateAdditionalData();
        } else {
            this.setJulianDate(this.jdate);
        }
    }

    private int calcDayOfWeek() {
        int jd = (int)(this.jdate.doubleValue() + 0.5);
        return jd % 7 + 1;
    }

    private int calcDayOfYear() {
        if (this.leap) {
            return LEAP_NUM_DAYS[this.time.month] + this.time.day;
        }
        return NUM_DAYS[this.time.month] + this.time.day;
    }

    private int calcWeekOfYear(int start, int must) {
        int delta = 0;
        if (start <= this.dayofweek) {
            if (must < start) {
                delta = 7;
            }
        } else if (must >= start) {
            delta = -7;
        }
        int jd = (int)(this.jdate.doubleValue() + 0.5) + delta;
        int WeekDay = jd % 7 + 1;
        int time_year = this.time.year;
        int DayOfYearNumber = this.dayofyear + delta;
        if (DayOfYearNumber < 1) {
            DayOfYearNumber = TimeUtil.isLeapYear(--time_year) ? 366 + DayOfYearNumber : 365 + DayOfYearNumber;
        } else if (DayOfYearNumber > (this.leap ? 366 : 365)) {
            DayOfYearNumber = this.leap ? DayOfYearNumber - 366 : DayOfYearNumber - 365;
            ++time_year;
        }
        int firstDay = jd - DayOfYearNumber + 1;
        int Jan1WeekDay = firstDay % 7 + 1;
        int YearNumber = time_year;
        int WeekNumber = 52;
        if (DayOfYearNumber <= 8 - Jan1WeekDay && Jan1WeekDay > must && (Jan1WeekDay == must + 1 || Jan1WeekDay == must + 2 && TimeUtil.isLeapYear(--YearNumber))) {
            WeekNumber = 53;
        }
        int m = 365;
        if (YearNumber == time_year) {
            if (TimeUtil.isLeapYear(time_year)) {
                m = 366;
            }
            if (m - DayOfYearNumber < must - WeekDay) {
                YearNumber = time_year + 1;
                WeekNumber = 1;
            }
        }
        if (YearNumber == time_year) {
            int n = DayOfYearNumber + (7 - WeekDay) + (Jan1WeekDay - 1);
            WeekNumber = n / 7;
            if (Jan1WeekDay > must) {
                --WeekNumber;
            }
        }
        return WeekNumber;
    }

    private int calcWeekNumber(int dayOfPeriod, int dayOfWeek) {
        int periodStartDayOfWeek = (dayOfWeek - this.firstDayOfWeek - dayOfPeriod + 1) % 7;
        if (periodStartDayOfWeek < 0) {
            periodStartDayOfWeek += 7;
        }
        int weekNo = (dayOfPeriod + periodStartDayOfWeek - 1) / 7;
        if (7 - periodStartDayOfWeek >= this.minDaysInFirstWeek) {
            ++weekNo;
        }
        return weekNo;
    }

    public void set(int year, int month, int day) {
        this.set(year, month, day, 0, 0, 0, 0);
    }

    public JDateTime(int year, int month, int day) {
        this.set(year, month, day);
    }

    public int getYear() {
        return this.time.year;
    }

    public int getMonth() {
        return this.time.month;
    }

    public int getDay() {
        return this.time.day;
    }

    public JDateTime(double jd) {
        this.setJulianDate(new JulianDateStamp(jd));
    }
}

