/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.jdbc.DatabricksDialect$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u00055h\u0001\u0002\u0011\"\t2BQA\u0012\u0001\u0005\u0002\u001dCQ!\u0013\u0001\u0005B)CQ\u0001\u0017\u0001\u0005BeCQa\u0019\u0001\u0005B\u0011DQ\u0001 \u0001\u0005BuDq!!\u0003\u0001\t\u0003\nY\u0001C\u0004\u0002\u0012\u0001!\t%a\u0005\t\u000f\u0005e\u0001\u0001\"\u0011\u0002\u001c!9\u0011Q\u0004\u0001\u0005B\u0005m\u0001bBA\u0010\u0001\u0011\u0005\u00131\u0004\u0005\b\u0003C\u0001A\u0011IA\u0012\u0011\u001d\ti\u0004\u0001C!\u00037Aq!a\u0010\u0001\t\u0003\n\t\u0005C\u0004\u0002`\u0001!\t%!\u0019\t\u0011\u0005=\u0004!!A\u0005\u0002\u001dC\u0011\"!\u001d\u0001\u0003\u0003%\t%a\u001d\t\u0013\u0005}\u0004!!A\u0005\u0002\u0005\u0005\u0005\"CAB\u0001\u0005\u0005I\u0011AAC\u0011%\t\t\nAA\u0001\n\u0003\n\u0019\nC\u0005\u0002\"\u0002\t\t\u0011\"\u0001\u0002$\"I\u0011q\u0015\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0016\u0005\n\u0003[\u0003\u0011\u0011!C!\u0003_C\u0011\"!-\u0001\u0003\u0003%\t%a-\t\u0013\u0005U\u0006!!A\u0005B\u0005]v!CA^C\u0005\u0005\t\u0012BA_\r!\u0001\u0013%!A\t\n\u0005}\u0006B\u0002$\u001b\t\u0003\t9\u000eC\u0005\u00022j\t\t\u0011\"\u0012\u00024\"A\u0011\u0011\u001c\u000e\u0002\u0002\u0013\u0005u\tC\u0005\u0002\\j\t\t\u0011\"!\u0002^\"I\u00111\u001d\u000e\u0002\u0002\u0013%\u0011Q\u001d\u0002\u0012\t\u0006$\u0018M\u0019:jG.\u001cH)[1mK\u000e$(B\u0001\u0012$\u0003\u0011QGMY2\u000b\u0005\u0011*\u0013aA:rY*\u0011aeJ\u0001\u0006gB\f'o\u001b\u0006\u0003Q%\na!\u00199bG\",'\"\u0001\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001i\u0013\u0007\u000e\u001e\u0011\u00059zS\"A\u0011\n\u0005A\n#a\u0003&eE\u000e$\u0015.\u00197fGR\u0004\"A\f\u001a\n\u0005M\n#!\u0005(p\u0019\u0016<\u0017mY=K\t\n\u001bUI\u001d:peB\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t9\u0001K]8ek\u000e$\bCA\u001eD\u001d\ta\u0014I\u0004\u0002>\u00016\taH\u0003\u0002@W\u00051AH]8pizJ\u0011aN\u0005\u0003\u0005Z\nq\u0001]1dW\u0006<W-\u0003\u0002E\u000b\na1+\u001a:jC2L'0\u00192mK*\u0011!IN\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0003\"A\f\u0001\u0002\u0013\r\fg\u000eS1oI2,GCA&O!\t)D*\u0003\u0002Nm\t9!i\\8mK\u0006t\u0007\"B(\u0003\u0001\u0004\u0001\u0016aA;sYB\u0011\u0011+\u0016\b\u0003%N\u0003\"!\u0010\u001c\n\u0005Q3\u0014A\u0002)sK\u0012,g-\u0003\u0002W/\n11\u000b\u001e:j]\u001eT!\u0001\u0016\u001c\u00023%\u001cxJ\u00196fGRtu\u000e\u001e$pk:$W\t_2faRLwN\u001c\u000b\u0003\u0017jCQaW\u0002A\u0002q\u000b\u0011!\u001a\t\u0003;\u0006l\u0011A\u0018\u0006\u0003I}S\u0011\u0001Y\u0001\u0005U\u00064\u0018-\u0003\u0002c=\na1+\u0015'Fq\u000e,\u0007\u000f^5p]\u0006yq-\u001a;DCR\fG._:u)f\u0004X\rF\u0003f]N,x\u000fE\u00026M\"L!a\u001a\u001c\u0003\r=\u0003H/[8o!\tIG.D\u0001k\u0015\tY7%A\u0003usB,7/\u0003\u0002nU\nAA)\u0019;b)f\u0004X\rC\u0003p\t\u0001\u0007\u0001/A\u0004tc2$\u0016\u0010]3\u0011\u0005U\n\u0018B\u0001:7\u0005\rIe\u000e\u001e\u0005\u0006i\u0012\u0001\r\u0001U\u0001\tif\u0004XMT1nK\")a\u000f\u0002a\u0001a\u0006!1/\u001b>f\u0011\u0015AH\u00011\u0001z\u0003\tiG\r\u0005\u0002ju&\u00111P\u001b\u0002\u0010\u001b\u0016$\u0018\rZ1uC\n+\u0018\u000e\u001c3fe\u0006Yq-\u001a;K\t\n\u001bE+\u001f9f)\rq\u0018Q\u0001\t\u0004k\u0019|\bc\u0001\u0018\u0002\u0002%\u0019\u00111A\u0011\u0003\u0011)#'m\u0019+za\u0016Da!a\u0002\u0006\u0001\u0004A\u0017A\u00013u\u0003]I7oU=oi\u0006DXI\u001d:pe\n+7\u000f^#gM>\u0014H\u000fF\u0002L\u0003\u001bAa!a\u0004\u0007\u0001\u0004a\u0016!C3yG\u0016\u0004H/[8o\u0003=\tXo\u001c;f\u0013\u0012,g\u000e^5gS\u0016\u0014Hc\u0001)\u0002\u0016!1\u0011qC\u0004A\u0002A\u000bqaY8m\u001d\u0006lW-A\u0007tkB\u0004xN\u001d;t\u0019&l\u0017\u000e^\u000b\u0002\u0017\u0006q1/\u001e9q_J$8o\u00144gg\u0016$\u0018aE:vaB|'\u000f^:UC\ndWmU1na2,\u0017AD4fiR\u000b'\r\\3TC6\u0004H.\u001a\u000b\u0004!\u0006\u0015\u0002bBA\u0014\u0017\u0001\u0007\u0011\u0011F\u0001\u0007g\u0006l\u0007\u000f\\3\u0011\t\u0005-\u0012\u0011H\u0007\u0003\u0003[QA!a\f\u00022\u0005\u0011aO\r\u0006\u0005\u0003g\t)$A\u0006eCR\f7o\\;sG\u0016\u001c(bAA\u001cG\u0005IQ\r_3dkRLwN\\\u0005\u0005\u0003w\tiCA\bUC\ndWmU1na2,\u0017J\u001c4p\u00031\u0019X\u000f\u001d9peR\u001c\b*\u001b8u\u00035\u00198\r[3nCN,\u00050[:ugR91*a\u0011\u0002N\u0005m\u0003bBA#\u001b\u0001\u0007\u0011qI\u0001\u0005G>tg\u000eE\u0002^\u0003\u0013J1!a\u0013_\u0005)\u0019uN\u001c8fGRLwN\u001c\u0005\b\u0003\u001fj\u0001\u0019AA)\u0003\u001dy\u0007\u000f^5p]N\u0004B!a\u0015\u0002X5\u0011\u0011Q\u000b\u0006\u0004E\u0005E\u0012\u0002BA-\u0003+\u00121B\u0013#C\u0007>\u0003H/[8og\"1\u0011QL\u0007A\u0002A\u000baa]2iK6\f\u0017a\u00037jgR\u001c6\r[3nCN$b!a\u0019\u0002l\u00055\u0004#B\u001b\u0002f\u0005%\u0014bAA4m\t)\u0011I\u001d:bsB!Q'!\u001aQ\u0011\u001d\t)E\u0004a\u0001\u0003\u000fBq!a\u0014\u000f\u0001\u0004\t\t&\u0001\u0003d_BL\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002vA!\u0011qOA?\u001b\t\tIHC\u0002\u0002|}\u000bA\u0001\\1oO&\u0019a+!\u001f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003A\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\b\u00065\u0005cA\u001b\u0002\n&\u0019\u00111\u0012\u001c\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\u0010J\t\t\u00111\u0001q\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0013\t\u0007\u0003/\u000bi*a\"\u000e\u0005\u0005e%bAANm\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0015\u0011\u0014\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002L\u0003KC\u0011\"a$\u0015\u0003\u0003\u0005\r!a\"\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003k\nY\u000b\u0003\u0005\u0002\u0010V\t\t\u00111\u0001q\u0003!A\u0017m\u001d5D_\u0012,G#\u00019\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u001e\u0002\r\u0015\fX/\u00197t)\rY\u0015\u0011\u0018\u0005\n\u0003\u001fC\u0012\u0011!a\u0001\u0003\u000f\u000b\u0011\u0003R1uC\n\u0014\u0018nY6t\t&\fG.Z2u!\tq#dE\u0003\u001b\u0003\u0003\fi\rE\u0003\u0002D\u0006%\u0007*\u0004\u0002\u0002F*\u0019\u0011q\u0019\u001c\u0002\u000fI,h\u000e^5nK&!\u00111ZAc\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\r\t\u0005\u0003\u001f\f).\u0004\u0002\u0002R*\u0019\u00111[0\u0002\u0005%|\u0017b\u0001#\u0002RR\u0011\u0011QX\u0001\u0006CB\u0004H._\u0001\bk:\f\u0007\u000f\u001d7z)\rY\u0015q\u001c\u0005\t\u0003Ct\u0012\u0011!a\u0001\u0011\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005\u001d\b\u0003BA<\u0003SLA!a;\u0002z\t1qJ\u00196fGR\u0004")
public class DatabricksDialect
extends JdbcDialect
implements NoLegacyJDBCError,
Product {
    public static boolean unapply(DatabricksDialect x$0) {
        return DatabricksDialect$.MODULE$.unapply(x$0);
    }

    public static DatabricksDialect apply() {
        return DatabricksDialect$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public Throwable classifyException(Throwable e, String condition, Map<String, String> messageParameters, String description, boolean isRuntime) {
        return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
    }

    @Override
    public boolean canHandle(String url) {
        return url.startsWith("jdbc:databricks");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isObjectNotFoundException(SQLException e) {
        String string = e.getSQLState();
        String string2 = "42P01";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = e.getSQLState();
        String string4 = "42704";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        switch (n) {
            case -6: {
                return new Some((Object)ByteType$.MODULE$);
            }
            case 5: {
                return new Some((Object)ShortType$.MODULE$);
            }
            case 7: {
                return new Some((Object)FloatType$.MODULE$);
            }
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BOOLEAN", 16));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("DOUBLE", 8));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("STRING", 12));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BINARY", -2));
        }
        return None$.MODULE$;
    }

    @Override
    public boolean isSyntaxErrorBestEffort(SQLException exception) {
        return Option$.MODULE$.apply((Object)exception.getSQLState()).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("42")));
    }

    @Override
    public String quoteIdentifier(String colName) {
        String escapedColName = colName.replace("`", "``");
        return "`" + escapedColName + "`";
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public boolean supportsTableSample() {
        return true;
    }

    @Override
    public String getTableSample(TableSampleInfo sample) {
        return "TABLESAMPLE (" + (sample.upperBound() - sample.lowerBound()) * (double)100 + ") REPEATABLE (" + sample.seed() + ")";
    }

    @Override
    public boolean supportsHint() {
        return true;
    }

    @Override
    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        PreparedStatement stmt = conn.prepareStatement("SHOW SCHEMAS");
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            String string = rs.getString(1);
            String string2 = schema;
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        PreparedStatement stmt = conn.prepareStatement("SHOW SCHEMAS");
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            schemaBuilder.$plus$eq((Object)new String[]{rs.getString(1)});
        }
        return (String[][])schemaBuilder.result();
    }

    public DatabricksDialect copy() {
        return new DatabricksDialect();
    }

    public String productPrefix() {
        return "DatabricksDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DatabricksDialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return -537824790;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof DatabricksDialect && ((DatabricksDialect)x$1).canEqual(this);
    }

    public DatabricksDialect() {
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
    }
}

