/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.io.grpc.stub;

import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.sparkproject.com.google.errorprone.annotations.CheckReturnValue;
import org.sparkproject.connect.guava.base.Preconditions;
import org.sparkproject.io.grpc.CallCredentials;
import org.sparkproject.io.grpc.CallOptions;
import org.sparkproject.io.grpc.Channel;
import org.sparkproject.io.grpc.ClientInterceptor;
import org.sparkproject.io.grpc.ClientInterceptors;
import org.sparkproject.io.grpc.Deadline;
import org.sparkproject.io.grpc.ExperimentalApi;
import org.sparkproject.io.grpc.InternalTimeUtils;
import org.sparkproject.org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

@CheckReturnValue
@ThreadSafe
public abstract class AbstractStub<S extends AbstractStub<S>> {
    private final Channel channel;
    private final CallOptions callOptions;

    protected AbstractStub(Channel channel) {
        this(channel, CallOptions.DEFAULT);
    }

    protected AbstractStub(Channel channel, CallOptions callOptions) {
        this.channel = Preconditions.checkNotNull(channel, "channel");
        this.callOptions = Preconditions.checkNotNull(callOptions, "callOptions");
    }

    public final Channel getChannel() {
        return this.channel;
    }

    public final CallOptions getCallOptions() {
        return this.callOptions;
    }

    protected abstract S build(Channel var1, CallOptions var2);

    public static <T extends AbstractStub<T>> T newStub(StubFactory<T> factory, Channel channel) {
        return AbstractStub.newStub(factory, channel, CallOptions.DEFAULT);
    }

    public static <T extends AbstractStub<T>> T newStub(StubFactory<T> factory, Channel channel, CallOptions callOptions) {
        return factory.newStub(channel, callOptions);
    }

    public final S withDeadline(@Nullable Deadline deadline) {
        return this.build(this.channel, this.callOptions.withDeadline(deadline));
    }

    public final S withDeadlineAfter(long duration, TimeUnit unit) {
        return this.build(this.channel, this.callOptions.withDeadlineAfter(duration, unit));
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/11657")
    @IgnoreJRERequirement
    public final S withDeadlineAfter(Duration duration) {
        return this.withDeadlineAfter(InternalTimeUtils.convert(duration), TimeUnit.NANOSECONDS);
    }

    public final S withExecutor(Executor executor) {
        return this.build(this.channel, this.callOptions.withExecutor(executor));
    }

    public final S withCompression(String compressorName) {
        return this.build(this.channel, this.callOptions.withCompression(compressorName));
    }

    @Deprecated
    public final S withChannel(Channel newChannel) {
        return this.build(newChannel, this.callOptions);
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1869")
    public final <T> S withOption(CallOptions.Key<T> key, T value) {
        return this.build(this.channel, this.callOptions.withOption(key, value));
    }

    public final S withInterceptors(ClientInterceptor ... interceptors) {
        return this.build(ClientInterceptors.intercept(this.channel, interceptors), this.callOptions);
    }

    public final S withCallCredentials(CallCredentials credentials) {
        return this.build(this.channel, this.callOptions.withCallCredentials(credentials));
    }

    public final S withWaitForReady() {
        return this.build(this.channel, this.callOptions.withWaitForReady());
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2563")
    public final S withMaxInboundMessageSize(int maxSize) {
        return this.build(this.channel, this.callOptions.withMaxInboundMessageSize(maxSize));
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2563")
    public final S withMaxOutboundMessageSize(int maxSize) {
        return this.build(this.channel, this.callOptions.withMaxOutboundMessageSize(maxSize));
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/11021")
    public final S withOnReadyThreshold(int numBytes) {
        return this.build(this.channel, this.callOptions.withOnReadyThreshold(numBytes));
    }

    public static interface StubFactory<T extends AbstractStub<T>> {
        public T newStub(Channel var1, CallOptions var2);
    }
}

