/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.org.apache.arrow.vector;

import org.sparkproject.org.apache.arrow.memory.ArrowBuf;
import org.sparkproject.org.apache.arrow.memory.BufferAllocator;
import org.sparkproject.org.apache.arrow.vector.BaseFixedWidthVector;
import org.sparkproject.org.apache.arrow.vector.BitVectorHelper;
import org.sparkproject.org.apache.arrow.vector.FloatingPointVector;
import org.sparkproject.org.apache.arrow.vector.NullCheckingForGet;
import org.sparkproject.org.apache.arrow.vector.ValueIterableVector;
import org.sparkproject.org.apache.arrow.vector.ValueVector;
import org.sparkproject.org.apache.arrow.vector.complex.impl.Float4ReaderImpl;
import org.sparkproject.org.apache.arrow.vector.complex.reader.FieldReader;
import org.sparkproject.org.apache.arrow.vector.holders.Float4Holder;
import org.sparkproject.org.apache.arrow.vector.holders.NullableFloat4Holder;
import org.sparkproject.org.apache.arrow.vector.types.Types;
import org.sparkproject.org.apache.arrow.vector.types.pojo.Field;
import org.sparkproject.org.apache.arrow.vector.types.pojo.FieldType;
import org.sparkproject.org.apache.arrow.vector.util.TransferPair;

public final class Float4Vector
extends BaseFixedWidthVector
implements FloatingPointVector,
ValueIterableVector<Float> {
    public static final byte TYPE_WIDTH = 4;

    public Float4Vector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.FLOAT4.getType()), allocator);
    }

    public Float4Vector(String name, FieldType fieldType, BufferAllocator allocator) {
        this(new Field(name, fieldType, null), allocator);
    }

    public Float4Vector(Field field, BufferAllocator allocator) {
        super(field, allocator, 4);
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new Float4ReaderImpl(this);
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.FLOAT4;
    }

    public float get(int index) throws IllegalStateException {
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.getFloat((long)index * 4L);
    }

    public void get(int index, NullableFloat4Holder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getFloat((long)index * 4L);
    }

    @Override
    public Float getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return Float.valueOf(this.valueBuffer.getFloat((long)index * 4L));
    }

    private void setValue(int index, float value) {
        this.valueBuffer.setFloat((long)index * 4L, value);
    }

    public void set(int index, float value) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, NullableFloat4Holder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setBit(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void set(int index, Float4Holder holder) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, float value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableFloat4Holder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, Float4Holder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void set(int index, int isSet, float value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void setSafe(int index, int isSet, float value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    public static float get(ArrowBuf buffer, int index) {
        return buffer.getFloat((long)index * 4L);
    }

    @Override
    public void setWithPossibleTruncate(int index, double value) {
        this.set(index, (float)value);
    }

    @Override
    public void setSafeWithPossibleTruncate(int index, double value) {
        this.setSafe(index, (float)value);
    }

    @Override
    public double getValueAsDouble(int index) {
        return this.get(index);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return new TransferImpl(field, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((Float4Vector)to);
    }

    private class TransferImpl
    implements TransferPair {
        Float4Vector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new Float4Vector(ref, Float4Vector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(Field field, BufferAllocator allocator) {
            this.to = new Float4Vector(field, allocator);
        }

        public TransferImpl(Float4Vector to) {
            this.to = to;
        }

        @Override
        public Float4Vector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            Float4Vector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            Float4Vector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, Float4Vector.this);
        }
    }
}

