/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import java.util.ArrayDeque;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.AnalysisContext;
import org.apache.spark.sql.catalyst.analysis.AnalysisContext$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.resolver.CteRegistry;
import org.apache.spark.sql.catalyst.analysis.resolver.ExplicitlyUnsupportedResolverFeature;
import org.apache.spark.sql.catalyst.analysis.resolver.Resolver;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolverGuard;
import org.apache.spark.sql.catalyst.analysis.resolver.TreeNodeResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.ViewResolutionContext;
import org.apache.spark.sql.catalyst.analysis.resolver.ViewResolutionContext$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.catalyst.plans.logical.View$;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005]b\u0001\u0002\t\u0012\u0001\u0001B\u0001B\u0005\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!)q\b\u0001C\u0001\u0001\"9A\t\u0001b\u0001\n\u0013)\u0005BB%\u0001A\u0003%a\tC\u0004K\u0001\t\u0007I\u0011B&\t\ra\u0003\u0001\u0015!\u0003M\u0011\u001dI\u0006A1A\u0005\niCaa\u0018\u0001!\u0002\u0013Y\u0006\"\u00021\u0001\t\u0003\t\u0007\"B=\u0001\t\u0003Q\b\"\u0002?\u0001\t\u0003i\bbBA\n\u0001\u0011\u0005\u0013Q\u0003\u0005\b\u00037\u0001A\u0011BA\u000f\u0011\u001d\tY\u0003\u0001C\u0005\u0003[\u0011ABV5foJ+7o\u001c7wKJT!AE\n\u0002\u0011I,7o\u001c7wKJT!\u0001F\u000b\u0002\u0011\u0005t\u0017\r\\=tSNT!AF\f\u0002\u0011\r\fG/\u00197zgRT!\u0001G\r\u0002\u0007M\fHN\u0003\u0002\u001b7\u0005)1\u000f]1sW*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u00192\u0001A\u0011(!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fMB!\u0001&K\u0016,\u001b\u0005\t\u0012B\u0001\u0016\u0012\u0005A!&/Z3O_\u0012,'+Z:pYZ,'\u000f\u0005\u0002-c5\tQF\u0003\u0002/_\u00059An\\4jG\u0006d'B\u0001\u0019\u0016\u0003\u0015\u0001H.\u00198t\u0013\t\u0011TF\u0001\u0003WS\u0016<\bC\u0001\u00155\u0013\t)\u0014C\u0001\u0005SKN|GN^3s\u00039\u0019\u0017\r^1m_\u001el\u0015M\\1hKJ\u0004\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\u000f\r\fG/\u00197pO*\u0011AhF\u0001\nG>tg.Z2u_JL!AP\u001d\u0003\u001d\r\u000bG/\u00197pO6\u000bg.Y4fe\u00061A(\u001b8jiz\"2!\u0011\"D!\tA\u0003\u0001C\u0003\u0013\u0007\u0001\u00071\u0007C\u00037\u0007\u0001\u0007q'A\u0006di\u0016\u0014VmZ5tiJLX#\u0001$\u0011\u0005!:\u0015B\u0001%\u0012\u0005-\u0019E/\u001a*fO&\u001cHO]=\u0002\u0019\r$XMU3hSN$(/\u001f\u0011\u0002;M|WO]2f+:\u0014Xm]8mm\u0016$'+\u001a7bi&|gn\u0015;bG.,\u0012\u0001\u0014\t\u0004\u001bJ#V\"\u0001(\u000b\u0005=\u0003\u0016\u0001B;uS2T\u0011!U\u0001\u0005U\u00064\u0018-\u0003\u0002T\u001d\nQ\u0011I\u001d:bs\u0012+\u0017/^3\u0011\u0005U3V\"A\n\n\u0005]\u001b\"AE+oe\u0016\u001cx\u000e\u001c<fIJ+G.\u0019;j_:\fad]8ve\u000e,WK\u001c:fg>dg/\u001a3SK2\fG/[8o'R\f7m\u001b\u0011\u00025YLWm\u001e*fg>dW\u000f^5p]\u000e{g\u000e^3yiN#\u0018mY6\u0016\u0003m\u00032!\u0014*]!\tAS,\u0003\u0002_#\t)b+[3x%\u0016\u001cx\u000e\\;uS>t7i\u001c8uKb$\u0018a\u0007<jK^\u0014Vm]8mkRLwN\\\"p]R,\u0007\u0010^*uC\u000e\\\u0007%\u0001\fhKR\u001c\u0015\r^1m_\u001e\fe\u000e\u001a(b[\u0016\u001c\b/Y2f+\u0005\u0011\u0007c\u0001\u0012dK&\u0011Am\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\u0019t\u0017O\u0004\u0002hY:\u0011\u0001n[\u0007\u0002S*\u0011!nH\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011J!!\\\u0012\u0002\u000fA\f7m[1hK&\u0011q\u000e\u001d\u0002\u0004'\u0016\f(BA7$!\t\u0011hO\u0004\u0002tiB\u0011\u0001nI\u0005\u0003k\u000e\na\u0001\u0015:fI\u00164\u0017BA<y\u0005\u0019\u0019FO]5oO*\u0011QoI\u0001\u0014O\u0016$H)\u001a4bk2$8i\u001c7mCRLwN\\\u000b\u0002wB\u0019!eY9\u00029]LG\u000f[*pkJ\u001cW-\u00168sKN|GN^3e%\u0016d\u0017\r^5p]R\u0019a0a\u0004\u0015\u0007}\f)\u0001E\u0002-\u0003\u0003I1!a\u0001.\u0005-aunZ5dC2\u0004F.\u00198\t\u0011\u0005\u001dA\u0002\"a\u0001\u0003\u0013\tAAY8esB!!%a\u0003\u0000\u0013\r\tia\t\u0002\ty\tLh.Y7f}!1\u0011\u0011\u0003\u0007A\u0002Q\u000b!#\u001e8sKN|GN^3e%\u0016d\u0017\r^5p]\u00069!/Z:pYZ,GcA\u0016\u0002\u0018!1\u0011\u0011D\u0007A\u0002-\na\"\u001e8sKN|GN^3e-&,w/A\rxSRDg+[3x%\u0016\u001cx\u000e\\;uS>t7i\u001c8uKb$H\u0003BA\u0010\u0003S!B!!\t\u0002(A)!%a\t\u00009&\u0019\u0011QE\u0012\u0003\rQ+\b\u000f\\33\u0011!\t9A\u0004CA\u0002\u0005%\u0001BBA\r\u001d\u0001\u00071&\u0001\ndQ\u0016\u001c7NU3t_24XM]$vCJ$G\u0003BA\u0018\u0003k\u00012AIA\u0019\u0013\r\t\u0019d\t\u0002\u0005+:LG\u000f\u0003\u0004\u0002\u001a=\u0001\ra\u000b")
public class ViewResolver
implements TreeNodeResolver<View, View> {
    private final Resolver resolver;
    private final CatalogManager catalogManager;
    private final CteRegistry cteRegistry;
    private final ArrayDeque<UnresolvedRelation> sourceUnresolvedRelationStack;
    private final ArrayDeque<ViewResolutionContext> viewResolutionContextStack;

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    private CteRegistry cteRegistry() {
        return this.cteRegistry;
    }

    private ArrayDeque<UnresolvedRelation> sourceUnresolvedRelationStack() {
        return this.sourceUnresolvedRelationStack;
    }

    private ArrayDeque<ViewResolutionContext> viewResolutionContextStack() {
        return this.viewResolutionContextStack;
    }

    public Option<Seq<String>> getCatalogAndNamespace() {
        if (this.viewResolutionContextStack().isEmpty()) {
            return None$.MODULE$;
        }
        return this.viewResolutionContextStack().peek().catalogAndNamespace();
    }

    public Option<String> getDefaultCollation() {
        if (this.viewResolutionContextStack().isEmpty()) {
            return None$.MODULE$;
        }
        return this.viewResolutionContextStack().peek().collation();
    }

    public LogicalPlan withSourceUnresolvedRelation(UnresolvedRelation unresolvedRelation, Function0<LogicalPlan> body) {
        LogicalPlan logicalPlan;
        this.sourceUnresolvedRelationStack().push(unresolvedRelation);
        try {
            logicalPlan = (LogicalPlan)body.apply();
        }
        finally {
            this.sourceUnresolvedRelationStack().pop();
        }
        return logicalPlan;
    }

    @Override
    public View resolve(View unresolvedView) {
        this.checkResolverGuard(unresolvedView);
        Tuple2<LogicalPlan, ViewResolutionContext> tuple2 = this.withViewResolutionContext(unresolvedView, (Function0<LogicalPlan>)(Function0 & Serializable)() -> (LogicalPlan)SQLConf$.MODULE$.withExistingConf(View$.MODULE$.effectiveSQLConf(unresolvedView.desc().viewSQLConfigs(), unresolvedView.isTempView(), View$.MODULE$.effectiveSQLConf$default$3()), (Function0 & Serializable)() -> {
            LogicalPlan logicalPlan;
            this.cteRegistry().pushScope(true, true);
            try {
                logicalPlan = $this.resolver.lookupMetadataAndResolve(unresolvedView.child(), $this.resolver.lookupMetadataAndResolve$default$2());
            }
            finally {
                this.cteRegistry().popScope();
            }
            return logicalPlan;
        }));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LogicalPlan resolvedChild = (LogicalPlan)tuple2._1();
        ViewResolutionContext usedViewResolutionContext = (ViewResolutionContext)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)resolvedChild, (Object)usedViewResolutionContext);
        LogicalPlan resolvedChild2 = (LogicalPlan)tuple22._1();
        ViewResolutionContext usedViewResolutionContext2 = (ViewResolutionContext)tuple22._2();
        CaseInsensitiveStringMap options = this.sourceUnresolvedRelationStack().isEmpty() ? CaseInsensitiveStringMap.empty() : this.sourceUnresolvedRelationStack().peek().options();
        LogicalPlan x$1 = resolvedChild2;
        CaseInsensitiveStringMap x$2 = options;
        CatalogTable x$3 = unresolvedView.copy$default$1();
        boolean x$4 = unresolvedView.copy$default$2();
        return unresolvedView.copy(x$3, x$4, x$1, x$2);
    }

    private Tuple2<LogicalPlan, ViewResolutionContext> withViewResolutionContext(View unresolvedView, Function0<LogicalPlan> body) {
        return (Tuple2)AnalysisContext$.MODULE$.withAnalysisContext(unresolvedView.desc(), (Function0 & Serializable)() -> {
            Tuple2 tuple2;
            AnalysisContext currentAnalysisContext = AnalysisContext$.MODULE$.get();
            ViewResolutionContext prevContext = this.viewResolutionContextStack().isEmpty() ? new ViewResolutionContext(0, this.conf().maxNestedViewDepth(), ViewResolutionContext$.MODULE$.apply$default$3(), ViewResolutionContext$.MODULE$.apply$default$4()) : this.viewResolutionContextStack().peek();
            int x$1 = prevContext.nestedViewDepth() + 1;
            Some x$2 = new Some(unresolvedView.desc().viewCatalogAndNamespace());
            int x$3 = prevContext.copy$default$2();
            Option<String> x$4 = prevContext.copy$default$3();
            ViewResolutionContext viewResolutionContext = prevContext.copy(x$1, x$3, x$4, (Option<Seq<String>>)x$2);
            viewResolutionContext.validate(unresolvedView);
            this.viewResolutionContextStack().push(viewResolutionContext);
            try {
                tuple2 = new Tuple2(body.apply(), (Object)viewResolutionContext);
            }
            finally {
                this.viewResolutionContextStack().pop();
            }
            return tuple2;
        });
    }

    private void checkResolverGuard(View unresolvedView) {
        ResolverGuard resolverGuard = new ResolverGuard(this.catalogManager);
        if (!resolverGuard.apply(unresolvedView)) {
            throw new ExplicitlyUnsupportedResolverFeature("View body is not supported");
        }
    }

    public ViewResolver(Resolver resolver, CatalogManager catalogManager) {
        this.resolver = resolver;
        this.catalogManager = catalogManager;
        SQLConfHelper.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.cteRegistry = resolver.getCteRegistry();
        this.sourceUnresolvedRelationStack = new ArrayDeque();
        this.viewResolutionContextStack = new ArrayDeque();
    }
}

