/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.services;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.jsonrpc.services.AnnotationUtil;

public class GenericEndpoint
implements Endpoint {
    private static final Logger LOG = Logger.getLogger(GenericEndpoint.class.getName());
    private static final Object[] NO_ARGUMENTS = new Object[0];
    private final LinkedHashMap<String, Function<Object, CompletableFuture<Object>>> methodHandlers = new LinkedHashMap();
    private final List<Object> delegates;

    public GenericEndpoint(Object delegate) {
        this.delegates = Collections.singletonList(delegate);
        this.recursiveFindRpcMethods(delegate, new HashSet(), new HashSet());
    }

    public GenericEndpoint(Collection<Object> delegates) {
        this.delegates = new ArrayList<Object>(delegates);
        for (Object delegate : this.delegates) {
            this.recursiveFindRpcMethods(delegate, new HashSet(), new HashSet());
        }
    }

    protected void recursiveFindRpcMethods(Object current, Set<Class<?>> visited, Set<Class<?>> visitedForDelegate) {
        AnnotationUtil.findRpcMethods(current.getClass(), visited, methodInfo -> {
            Function<Object, CompletableFuture> handler = arg -> {
                try {
                    Method method = methodInfo.method;
                    Object[] arguments = this.getArguments(method, arg);
                    return (CompletableFuture)method.invoke(current, arguments);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
            if (this.methodHandlers.put(methodInfo.name, handler) != null) {
                throw new IllegalStateException("Multiple methods for name " + methodInfo.name);
            }
        });
        AnnotationUtil.findDelegateSegments(current.getClass(), visitedForDelegate, method -> {
            try {
                Object delegate = method.invoke(current, new Object[0]);
                if (delegate != null) {
                    this.recursiveFindRpcMethods(delegate, visited, visitedForDelegate);
                } else {
                    LOG.fine("A delegate object is null, jsonrpc methods of '" + method + "' are ignored");
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected Object[] getArguments(Method method, Object arg) {
        int parameterCount = method.getParameterCount();
        if (parameterCount == 0) {
            if (arg != null) {
                LOG.warning("Unexpected params '" + arg + "' for '" + method + "' is ignored");
            }
            return NO_ARGUMENTS;
        }
        if (arg instanceof List) {
            List arguments = (List)arg;
            int argumentCount = arguments.size();
            if (argumentCount == parameterCount) {
                return arguments.toArray();
            }
            if (argumentCount > parameterCount) {
                Stream unexpectedArguments = arguments.stream().skip(parameterCount);
                String unexpectedParams = unexpectedArguments.map(a -> "'" + a + "'").reduce((a, a2) -> a + ", " + a2).get();
                LOG.warning("Unexpected params " + unexpectedParams + " for '" + method + "' is ignored");
                return arguments.subList(0, parameterCount).toArray();
            }
            return arguments.toArray(new Object[parameterCount]);
        }
        Object[] arguments = new Object[parameterCount];
        arguments[0] = arg;
        return arguments;
    }

    @Override
    public CompletableFuture<?> request(String method, Object parameter) {
        Function<Object, CompletableFuture<Object>> handler = this.methodHandlers.get(method);
        if (handler != null) {
            return handler.apply(parameter);
        }
        ArrayList futures = new ArrayList(this.delegates.size());
        for (Object delegate : this.delegates) {
            if (!(delegate instanceof Endpoint)) continue;
            futures.add(((Endpoint)delegate).request(method, parameter));
        }
        if (!futures.isEmpty()) {
            return CompletableFuture.anyOf(futures.toArray(new CompletableFuture[futures.size()]));
        }
        String message = "Unsupported request method: " + method;
        if (this.isOptionalMethod(method)) {
            LOG.log(Level.INFO, message);
            return CompletableFuture.completedFuture(null);
        }
        LOG.log(Level.WARNING, message);
        CompletableFuture exceptionalResult = new CompletableFuture();
        ResponseError error = new ResponseError(ResponseErrorCode.MethodNotFound, message, null);
        exceptionalResult.completeExceptionally(new ResponseErrorException(error));
        return exceptionalResult;
    }

    @Override
    public void notify(String method, Object parameter) {
        Function<Object, CompletableFuture<Object>> handler = this.methodHandlers.get(method);
        if (handler != null) {
            handler.apply(parameter);
            return;
        }
        int notifiedDelegates = 0;
        for (Object delegate : this.delegates) {
            if (!(delegate instanceof Endpoint)) continue;
            ((Endpoint)delegate).notify(method, parameter);
            ++notifiedDelegates;
        }
        if (notifiedDelegates == 0) {
            String message = "Unsupported notification method: " + method;
            if (this.isOptionalMethod(method)) {
                LOG.log(Level.INFO, message);
            } else {
                LOG.log(Level.WARNING, message);
            }
        }
    }

    protected boolean isOptionalMethod(String method) {
        return method != null && method.startsWith("$/");
    }
}

