/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.catalyst.analysis.EliminateSubqueryAliases$;
import org.apache.spark.sql.catalyst.analysis.V2TableReference;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.optimizer.EliminateResolvedHint$;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.IgnoreCachedData;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.classic.Dataset;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.classic.SparkSession$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.execution.CacheManager$;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.QueryExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanHelper;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.columnar.InMemoryRelation$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelationWithTable$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.ExtractV2Table$;
import org.apache.spark.sql.execution.datasources.v2.FileTable;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\rUa\u0001\u0002\u0015*\u0001QBQa\u0012\u0001\u0005\u0002!Cqa\u0013\u0001A\u0002\u0013%A\nC\u0004Y\u0001\u0001\u0007I\u0011B-\t\r}\u0003\u0001\u0015)\u0003N\u0011\u0015A\u0007\u0001\"\u0001j\u0011\u0015Q\u0007\u0001\"\u0001l\u0011\u0019y\u0007\u0001\"\u0001,a\")A\u000f\u0001C\u0001k\"1A\u000f\u0001C\u0001\u0003+Aa\u0001\u001e\u0001\u0005\u0002\u0005M\u0003bBA=\u0001\u0011%\u00111\u0010\u0005\b\u0003\u0017\u0003A\u0011AAG\u0011\u001d\tY\t\u0001C\u0001\u0003GCq!a#\u0001\t\u0003\t\u0019\fC\u0004\u0002\f\u0002!\t!a0\t\u000f\u0005\u001d\u0007\u0001\"\u0003\u0002J\"9\u00111\u001b\u0001\u0005\u0002\u0005U\u0007\"CAz\u0001E\u0005I\u0011AA{\u0011\u001d\u0011Y\u0001\u0001C\u0005\u0005\u001bAqA!\n\u0001\t\u0013\u00119\u0003\u0003\u0005\u0003:\u0001!\ta\u000bB\u001e\u0011\u001d\u0011)\u0006\u0001C\u0001\u0005/BqA!\u0018\u0001\t\u0003\u0011y\u0006C\u0005\u0003h\u0001\t\n\u0011\"\u0001\u0002v\"9!\u0011\u000e\u0001\u0005\n\t-\u0004b\u0002B;\u0001\u0011\u0005!q\u000f\u0005\b\u0005k\u0002A\u0011\u0001BD\u0011\u001d\u0011y\t\u0001C\u0005\u0005#C\u0001B!&\u0001\t\u0003Y#q\u0013\u0005\b\u00057\u0003A\u0011\u0001BO\u0011\u001d\u0011Y\n\u0001C\u0001\u0005KCqAa1\u0001\t\u0013\u0011)\rC\u0004\u0003P\u0002!IA!5\t\u000f\t\u001d\b\u0001\"\u0001\u0003j\"9!1\u001f\u0001\u0005\n\tUxa\u0002B}S!\u0005!1 \u0004\u0007Q%B\tA!@\t\r\u001d+C\u0011\u0001B\u0000\u0011\u001d\u0019\t!\nC\u0001\u0007\u0007\u0011AbQ1dQ\u0016l\u0015M\\1hKJT!AK\u0016\u0002\u0013\u0015DXmY;uS>t'B\u0001\u0017.\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003]=\nQa\u001d9be.T!\u0001M\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0014aA8sO\u000e\u00011\u0003\u0002\u00016w\u0005\u0003\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012a!\u00118z%\u00164\u0007C\u0001\u001f@\u001b\u0005i$B\u0001 .\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001!>\u0005\u001daunZ4j]\u001e\u0004\"AQ#\u000e\u0003\rS!\u0001R\u0015\u0002\u0011\u0005$\u0017\r\u001d;jm\u0016L!AR\"\u0003/\u0005#\u0017\r\u001d;jm\u0016\u001c\u0006/\u0019:l!2\fg\u000eS3ma\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001J!\tQ\u0005!D\u0001*\u0003)\u0019\u0017m\u00195fI\u0012\u000bG/Y\u000b\u0002\u001bB\u0019ajU+\u000e\u0003=S!\u0001U)\u0002\u0013%lW.\u001e;bE2,'B\u0001*8\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003)>\u0013!\"\u00138eKb,GmU3r!\tQe+\u0003\u0002XS\tQ1)Y2iK\u0012$\u0015\r^1\u0002\u001d\r\f7\r[3e\t\u0006$\u0018m\u0018\u0013fcR\u0011!,\u0018\t\u0003mmK!\u0001X\u001c\u0003\tUs\u0017\u000e\u001e\u0005\b=\u000e\t\t\u00111\u0001N\u0003\rAH%M\u0001\fG\u0006\u001c\u0007.\u001a3ECR\f\u0007\u0005\u000b\u0002\u0005CB\u0011aGY\u0005\u0003G^\u0012\u0011\u0002\u001e:b]NLWM\u001c;)\u0005\u0011)\u0007C\u0001\u001cg\u0013\t9wG\u0001\u0005w_2\fG/\u001b7f\u0003)\u0019G.Z1s\u0007\u0006\u001c\u0007.\u001a\u000b\u00025\u00069\u0011n]#naRLX#\u00017\u0011\u0005Yj\u0017B\u000188\u0005\u001d\u0011un\u001c7fC:\f\u0001C\\;n\u0007\u0006\u001c\u0007.\u001a3F]R\u0014\u0018.Z:\u0016\u0003E\u0004\"A\u000e:\n\u0005M<$aA%oi\u0006Q1-Y2iKF+XM]=\u0015\u0005i3\b\"B<\t\u0001\u0004A\u0018!B9vKJL\bgA=\u0002\u0004A\u0019!0`@\u000e\u0003mT!\u0001`\u0016\u0002\u000f\rd\u0017m]:jG&\u0011ap\u001f\u0002\b\t\u0006$\u0018m]3u!\u0011\t\t!a\u0001\r\u0001\u0011Y\u0011Q\u0001<\u0002\u0002\u0003\u0005)\u0011AA\u0004\u0005\ryF%M\t\u0005\u0003\u0013\ty\u0001E\u00027\u0003\u0017I1!!\u00048\u0005\u001dqu\u000e\u001e5j]\u001e\u00042ANA\t\u0013\r\t\u0019b\u000e\u0002\u0004\u0003:LHc\u0002.\u0002\u0018\u0005\r\u00121\t\u0005\u0007o&\u0001\r!!\u00071\t\u0005m\u0011q\u0004\t\u0005uv\fi\u0002\u0005\u0003\u0002\u0002\u0005}A\u0001DA\u0011\u0003/\t\t\u0011!A\u0003\u0002\u0005\u001d!aA0%e!9\u0011QE\u0005A\u0002\u0005\u001d\u0012!\u0003;bE2,g*Y7f!\u00151\u0014\u0011FA\u0017\u0013\r\tYc\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005=\u0012Q\b\b\u0005\u0003c\tI\u0004E\u0002\u00024]j!!!\u000e\u000b\u0007\u0005]2'\u0001\u0004=e>|GOP\u0005\u0004\u0003w9\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002@\u0005\u0005#AB*ue&twMC\u0002\u0002<]Bq!!\u0012\n\u0001\u0004\t9%\u0001\u0007ti>\u0014\u0018mZ3MKZ,G\u000e\u0005\u0003\u0002J\u0005=SBAA&\u0015\r\ti%L\u0001\bgR|'/Y4f\u0013\u0011\t\t&a\u0013\u0003\u0019M#xN]1hK2+g/\u001a7\u0015\u0013i\u000b)&!\u0018\u0002v\u0005]\u0004B\u0002\u0018\u000b\u0001\u0004\t9\u0006E\u0002{\u00033J1!a\u0017|\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u001d\tyF\u0003a\u0001\u0003C\n1\u0002\u001d7b]R{7)Y2iKB!\u00111MA9\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014a\u00027pO&\u001c\u0017\r\u001c\u0006\u0005\u0003W\ni'A\u0003qY\u0006t7OC\u0002\u0002p-\n\u0001bY1uC2L8\u000f^\u0005\u0005\u0003g\n)GA\u0006M_\u001eL7-\u00197QY\u0006t\u0007bBA\u0013\u0015\u0001\u0007\u0011q\u0005\u0005\b\u0003\u000bR\u0001\u0019AA$\u0003I\u0019\u0017m\u00195f#V,'/_%oi\u0016\u0014h.\u00197\u0015\u0017i\u000bi(a \u0002\u0004\u0006\u001d\u0015\u0011\u0012\u0005\u0007]-\u0001\r!a\u0016\t\u000f\u0005\u00055\u00021\u0001\u0002b\u0005\u0001RO\u001c8pe6\fG.\u001b>fIBc\u0017M\u001c\u0005\b\u0003\u000b[\u0001\u0019AA1\u00039qwN]7bY&TX\r\u001a)mC:Dq!!\n\f\u0001\u0004\t9\u0003C\u0004\u0002F-\u0001\r!a\u0012\u0002\u0019Ut7-Y2iKF+XM]=\u0015\u000fi\u000by)a'\u0002 \"1q\u000f\u0004a\u0001\u0003#\u0003D!a%\u0002\u0018B!!0`AK!\u0011\t\t!a&\u0005\u0019\u0005e\u0015qRA\u0001\u0002\u0003\u0015\t!a\u0002\u0003\u0007}#3\u0007\u0003\u0004\u0002\u001e2\u0001\r\u0001\\\u0001\bG\u0006\u001c8-\u00193f\u0011\u0019\t\t\u000b\u0004a\u0001Y\u0006A!\r\\8dW&tw\rF\u0003[\u0003K\u000b\t\f\u0003\u0004x\u001b\u0001\u0007\u0011q\u0015\u0019\u0005\u0003S\u000bi\u000b\u0005\u0003{{\u0006-\u0006\u0003BA\u0001\u0003[#A\"a,\u0002&\u0006\u0005\t\u0011!B\u0001\u0003\u000f\u00111a\u0018\u00135\u0011\u0019\ti*\u0004a\u0001YRI!,!.\u00028\u0006m\u0016Q\u0018\u0005\u0007]9\u0001\r!a\u0016\t\u000f\u0005ef\u00021\u0001\u0002b\u0005!\u0001\u000f\\1o\u0011\u0019\tiJ\u0004a\u0001Y\"1\u0011\u0011\u0015\bA\u00021$rAWAa\u0003\u0007\f)\r\u0003\u0004/\u001f\u0001\u0007\u0011q\u000b\u0005\b\u0003s{\u0001\u0019AA1\u0011\u0019\tij\u0004a\u0001Y\u0006!RO\\2bG\",\u0017+^3ss&sG/\u001a:oC2$\u0012BWAf\u0003\u001b\fy-!5\t\r9\u0002\u0002\u0019AA,\u0011\u001d\tI\f\u0005a\u0001\u0003CBa!!(\u0011\u0001\u0004a\u0007BBAQ!\u0001\u0007A.\u0001\nv]\u000e\f7\r[3UC\ndWm\u0014:WS\u0016<H#\u0003.\u0002X\u0006e\u0017q^Ay\u0011\u0019q\u0013\u00031\u0001\u0002X!9\u00111\\\tA\u0002\u0005u\u0017\u0001\u00028b[\u0016\u0004b!a8\u0002j\u00065b\u0002BAq\u0003KtA!a\r\u0002d&\t\u0001(C\u0002\u0002h^\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002l\u00065(aA*fc*\u0019\u0011q]\u001c\t\r\u0005u\u0015\u00031\u0001m\u0011!\t\t+\u0005I\u0001\u0002\u0004a\u0017\u0001H;oG\u0006\u001c\u0007.\u001a+bE2,wJ\u001d,jK^$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003oT3\u0001\\A}W\t\tY\u0010\u0005\u0003\u0002~\n\u001dQBAA\u0000\u0015\u0011\u0011\tAa\u0001\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0003o\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t%\u0011q \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001F5t\u001b\u0006$8\r[3e)\u0006\u0014G.Z(s-&,w\u000fF\u0005m\u0005\u001f\u0011\tBa\u0005\u0003\"!9\u0011\u0011X\nA\u0002\u0005\u0005\u0004bBAn'\u0001\u0007\u0011Q\u001c\u0005\b\u0005+\u0019\u0002\u0019\u0001B\f\u0003\u0011\u0019wN\u001c4\u0011\t\te!QD\u0007\u0003\u00057Q!AP\u0016\n\t\t}!1\u0004\u0002\b'Fc5i\u001c8g\u0011\u0019\u0011\u0019c\u0005a\u0001Y\u0006\t\u0012N\\2mk\u0012,G+[7f)J\fg/\u001a7\u0002%Ut7-Y2iK\nK8i\u001c8eSRLwN\u001c\u000b\n5\n%\"1\u0006B\u001b\u0005oAaA\f\u000bA\u0002\u0005]\u0003b\u0002B\u0017)\u0001\u0007!qF\u0001\u000eSNl\u0015\r^2iK\u0012\u0004F.\u00198\u0011\rY\u0012\t$!\u0019m\u0013\r\u0011\u0019d\u000e\u0002\n\rVt7\r^5p]FBa!!(\u0015\u0001\u0004a\u0007BBAQ)\u0001\u0007A.A\fb]\u0006d\u0017P_3D_2,XN\\\"bG\",\u0017+^3ssR9!L!\u0010\u0003B\t\r\u0003b\u0002B +\u0001\u0007\u0011qK\u0001\rgB\f'o[*fgNLwN\u001c\u0005\u0006\u0017V\u0001\r!\u0016\u0005\b\u0005\u000b*\u0002\u0019\u0001B$\u0003\u0019\u0019w\u000e\\;n]B1\u0011q\\Au\u0005\u0013\u0002BAa\u0013\u0003R5\u0011!Q\n\u0006\u0005\u0005\u001f\ni'A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002\u0002B*\u0005\u001b\u0012\u0011\"\u0011;ue&\u0014W\u000f^3\u0002\u001bI,7-Y2iK\nK\b\u000b\\1o)\u0015Q&\u0011\fB.\u0011\u0019qc\u00031\u0001\u0002X!9\u0011\u0011\u0018\fA\u0002\u0005\u0005\u0014A\u0005:fG\u0006\u001c\u0007.\u001a+bE2,wJ\u001d,jK^$rA\u0017B1\u0005G\u0012)\u0007\u0003\u0004//\u0001\u0007\u0011q\u000b\u0005\b\u00037<\u0002\u0019AAo\u0011!\u0011\u0019c\u0006I\u0001\u0002\u0004a\u0017\u0001\b:fG\u0006\u001c\u0007.\u001a+bE2,wJ\u001d,jK^$C-\u001a4bk2$HeM\u0001\u0013e\u0016\u001c\u0017m\u00195f\u0005f\u001cuN\u001c3ji&|g\u000eF\u0003[\u0005[\u0012y\u0007\u0003\u0004/3\u0001\u0007\u0011q\u000b\u0005\b\u0005cJ\u0002\u0019\u0001B:\u0003%\u0019wN\u001c3ji&|g\u000eE\u00037\u0005c)F.\u0001\tm_>\\W\u000f]\"bG\",G\rR1uCR!!\u0011\u0010B>!\u00111\u0014\u0011F+\t\r]T\u0002\u0019\u0001B?a\u0011\u0011yHa!\u0011\til(\u0011\u0011\t\u0005\u0003\u0003\u0011\u0019\t\u0002\u0007\u0003\u0006\nm\u0014\u0011!A\u0001\u0006\u0003\t9AA\u0002`IU\"bA!\u001f\u0003\n\n5\u0005b\u0002BF7\u0001\u0007\u0011qK\u0001\bg\u0016\u001c8/[8o\u0011\u001d\tIl\u0007a\u0001\u0003C\n\u0001\u0004\\8pWV\u00048)Y2iK\u0012$\u0015\r^1J]R,'O\\1m)\u0011\u0011IHa%\t\u000f\u0005eF\u00041\u0001\u0002b\u0005iQo]3DC\u000eDW\r\u001a#bi\u0006$B!!\u0019\u0003\u001a\"9\u0011\u0011X\u000fA\u0002\u0005\u0005\u0014!\u0004:fG\u0006\u001c\u0007.\u001a\"z!\u0006$\b\u000eF\u0003[\u0005?\u0013\t\u000b\u0003\u0004/=\u0001\u0007\u0011q\u000b\u0005\b\u0005Gs\u0002\u0019AA\u0017\u00031\u0011Xm]8ve\u000e,\u0007+\u0019;i)\u001dQ&q\u0015BU\u0005wCaAL\u0010A\u0002\u0005]\u0003b\u0002BR?\u0001\u0007!1\u0016\t\u0005\u0005[\u00139,\u0004\u0002\u00030*!!\u0011\u0017BZ\u0003\t17OC\u0002\u00036>\na\u0001[1e_>\u0004\u0018\u0002\u0002B]\u0005_\u0013A\u0001U1uQ\"9!\u0011W\u0010A\u0002\tu\u0006\u0003\u0002BW\u0005\u007fKAA!1\u00030\nQa)\u001b7f'f\u001cH/Z7\u0002!1|wn[;q\u0003:$'+\u001a4sKNDGc\u00027\u0003H\n%'1\u001a\u0005\b\u0003s\u0003\u0003\u0019AA1\u0011\u001d\u0011\t\f\ta\u0001\u0005{CqA!4!\u0001\u0004\u0011Y+A\u0007rk\u0006d\u0017NZ5fIB\u000bG\u000f[\u0001\u001ce\u00164'/Z:i\r&dW-\u00138eKbLeMT3dKN\u001c\u0018M]=\u0015\u000f1\u0014\u0019Na9\u0003f\"9!Q[\u0011A\u0002\t]\u0017!\u00034jY\u0016Le\u000eZ3y!\u0011\u0011INa8\u000e\u0005\tm'b\u0001BoS\u0005YA-\u0019;bg>,(oY3t\u0013\u0011\u0011\tOa7\u0003\u0013\u0019KG.Z%oI\u0016D\bb\u0002BYC\u0001\u0007!Q\u0018\u0005\b\u0005\u001b\f\u0003\u0019\u0001BV\u0003!I7oU;c\t&\u0014H#\u00027\u0003l\n=\bb\u0002BwE\u0001\u0007!1V\u0001\u0014cV\fG.\u001b4jK\u0012\u0004\u0016\r\u001e5QCJ,g\u000e\u001e\u0005\b\u0005c\u0014\u0003\u0019\u0001BV\u0003I\tX/\u00197jM&,G\rU1uQ\u000eC\u0017\u000e\u001c3\u0002?\u001d,Go\u0014:DY>tWmU3tg&|gnV5uQ\u000e{gNZ5hg>3g\r\u0006\u0003\u0002X\t]\bb\u0002BFG\u0001\u0007\u0011qK\u0001\r\u0007\u0006\u001c\u0007.Z'b]\u0006<WM\u001d\t\u0003\u0015\u0016\u001a2!J\u001b<)\t\u0011Y0A\tm_\u001e\u001c\u0015m\u00195f\u001fB,'/\u0019;j_:$2AWB\u0003\u0011!\u00199a\nCA\u0002\r%\u0011!\u00014\u0011\u000bY\u001aYaa\u0004\n\u0007\r5qG\u0001\u0005=Eft\u0017-\\3?!\ra4\u0011C\u0005\u0004\u0007'i$AE'fgN\fw-Z,ji\"\u001cuN\u001c;fqR\u0004")
public class CacheManager
implements Logging,
AdaptiveSparkPlanHelper {
    private volatile transient IndexedSeq<CachedData> cachedData;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void logCacheOperation(Function0<MessageWithContext> f) {
        CacheManager$.MODULE$.logCacheOperation(f);
    }

    @Override
    public Option<SparkPlan> find(SparkPlan p, Function1<SparkPlan, Object> f) {
        return AdaptiveSparkPlanHelper.find$(this, p, f);
    }

    @Override
    public void foreach(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreach$(this, p, f);
    }

    @Override
    public void foreachUp(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreachUp$(this, p, f);
    }

    @Override
    public <A> Seq<A> mapPlans(SparkPlan p, Function1<SparkPlan, A> f) {
        return AdaptiveSparkPlanHelper.mapPlans$(this, p, f);
    }

    @Override
    public <A> Seq<A> flatMap(SparkPlan p, Function1<SparkPlan, IterableOnce<A>> f) {
        return AdaptiveSparkPlanHelper.flatMap$(this, p, f);
    }

    @Override
    public <B> Seq<B> collect(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collect$(this, p, pf);
    }

    @Override
    public Seq<SparkPlan> collectLeaves(SparkPlan p) {
        return AdaptiveSparkPlanHelper.collectLeaves$(this, p);
    }

    @Override
    public <B> Option<B> collectFirst(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collectFirst$(this, p, pf);
    }

    @Override
    public <B> Seq<B> collectWithSubqueries(SparkPlan p, PartialFunction<SparkPlan, B> f) {
        return AdaptiveSparkPlanHelper.collectWithSubqueries$(this, p, f);
    }

    @Override
    public Seq<SparkPlan> subqueriesAll(SparkPlan p) {
        return AdaptiveSparkPlanHelper.subqueriesAll$(this, p);
    }

    @Override
    public Seq<SparkPlan> allChildren(SparkPlan p) {
        return AdaptiveSparkPlanHelper.allChildren$(this, p);
    }

    @Override
    public SparkPlan stripAQEPlan(SparkPlan p) {
        return AdaptiveSparkPlanHelper.stripAQEPlan$(this, p);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private IndexedSeq<CachedData> cachedData() {
        return this.cachedData;
    }

    private void cachedData_$eq(IndexedSeq<CachedData> x$1) {
        this.cachedData = x$1;
    }

    public synchronized void clearCache() {
        this.cachedData().foreach((Function1 & Serializable)x$1 -> {
            CacheManager.$anonfun$clearCache$1(x$1);
            return BoxedUnit.UNIT;
        });
        this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Nil$.MODULE$)));
        CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Cleared all Dataframe cache entries"}))).log((Seq)Nil$.MODULE$));
    }

    public boolean isEmpty() {
        return this.cachedData().isEmpty();
    }

    public int numCachedEntries() {
        return this.cachedData().size();
    }

    public void cacheQuery(Dataset<?> query) {
        this.cacheQuery(query, (Option<String>)None$.MODULE$, StorageLevel$.MODULE$.MEMORY_AND_DISK());
    }

    public void cacheQuery(Dataset<?> query, Option<String> tableName, StorageLevel storageLevel) {
        this.cacheQueryInternal(query.sparkSession(), query.queryExecution().analyzed(), query.queryExecution().normalized(), tableName, storageLevel);
    }

    public void cacheQuery(SparkSession spark, LogicalPlan planToCache, Option<String> tableName, StorageLevel storageLevel) {
        LogicalPlan normalized = QueryExecution$.MODULE$.normalize(spark, planToCache, QueryExecution$.MODULE$.normalize$default$3());
        this.cacheQueryInternal(spark, planToCache, normalized, tableName, storageLevel);
    }

    private void cacheQueryInternal(SparkSession spark, LogicalPlan unnormalizedPlan, LogicalPlan normalizedPlan, Option<String> tableName, StorageLevel storageLevel) {
        StorageLevel storageLevel2 = storageLevel;
        StorageLevel storageLevel3 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel2 != null ? !storageLevel2.equals(storageLevel3) : storageLevel3 != null)) {
            return;
        }
        if (unnormalizedPlan instanceof IgnoreCachedData) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Asked to cache a plan that is inapplicable for caching: "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.LOGICAL_PLAN, unnormalizedPlan)})))));
            return;
        }
        if (this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(normalizedPlan).nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Asked to cache already cached data.");
            return;
        }
        SparkSession sessionWithConfigsOff = this.getOrCloneSessionWithConfigsOff(spark);
        InMemoryRelation inMemoryRelation = (InMemoryRelation)sessionWithConfigsOff.withActive((Function0 & Serializable)() -> {
            QueryExecution qe = sessionWithConfigsOff.sessionState().executePlan(unnormalizedPlan, sessionWithConfigsOff.sessionState().executePlan$default$2());
            return InMemoryRelation$.MODULE$.apply(storageLevel, qe, tableName);
        });
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            if (this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(normalizedPlan).nonEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Data has already been cached.");
            } else {
                CachedData cd;
                CachedData cachedData = cd = new CachedData(normalizedPlan, inMemoryRelation);
                this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().$plus$colon((Object)cachedData)));
                CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Added Dataframe cache entry:"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.DATAFRAME_CACHE_ENTRY, cd)}))));
            }
        }
    }

    public void uncacheQuery(Dataset<?> query, boolean cascade, boolean blocking) {
        this.uncacheQueryInternal(query.sparkSession(), query.queryExecution().normalized(), cascade, blocking);
    }

    public void uncacheQuery(Dataset<?> query, boolean cascade) {
        this.uncacheQuery(query, cascade, false);
    }

    public void uncacheQuery(SparkSession spark, LogicalPlan plan, boolean cascade, boolean blocking) {
        LogicalPlan normalized = QueryExecution$.MODULE$.normalize(spark, plan, QueryExecution$.MODULE$.normalize$default$3());
        this.uncacheQueryInternal(spark, normalized, cascade, blocking);
    }

    public void uncacheQuery(SparkSession spark, LogicalPlan plan, boolean cascade) {
        this.uncacheQuery(spark, plan, cascade, false);
    }

    private void uncacheQueryInternal(SparkSession spark, LogicalPlan plan, boolean cascade, boolean blocking) {
        this.uncacheByCondition(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.sameResult((QueryPlan)plan)), cascade, blocking);
    }

    public void uncacheTableOrView(SparkSession spark, Seq<String> name, boolean cascade, boolean blocking) {
        this.uncacheByCondition(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)this.isMatchedTableOrView(x$3, (Seq<String>)name, spark.sessionState().conf(), true)), cascade, blocking);
    }

    public boolean uncacheTableOrView$default$4() {
        return false;
    }

    private boolean isMatchedTableOrView(LogicalPlan plan, Seq<String> name, SQLConf conf, boolean includeTimeTravel) {
        Option option;
        LogicalRelation logicalRelation;
        Option<Tuple2<BaseRelation, Option<CatalogTable>>> option2;
        LogicalPlan logicalPlan2 = EliminateSubqueryAliases$.MODULE$.apply(plan);
        if (logicalPlan2 instanceof LogicalRelation && !(option2 = LogicalRelationWithTable$.MODULE$.unapply(logicalRelation = (LogicalRelation)logicalPlan2)).isEmpty() && (option = (Option)((Tuple2)option2.get())._2()) instanceof Some) {
            Some some = (Some)option;
            CatalogTable catalogTable = (CatalogTable)some.value();
            return CacheManager.isSameName$1(catalogTable.identifier().nameParts(), name, conf);
        }
        if (logicalPlan2 instanceof DataSourceV2Relation) {
            DataSourceV2Relation dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2;
            Option option3 = dataSourceV2Relation.catalog();
            Option option4 = dataSourceV2Relation.identifier();
            Option timeTravelSpec = dataSourceV2Relation.timeTravelSpec();
            if (option3 instanceof Some) {
                Some some = (Some)option3;
                CatalogPlugin catalog = (CatalogPlugin)some.value();
                if (option4 instanceof Some) {
                    Some some2 = (Some)option4;
                    Identifier v2Ident = (Identifier)some2.value();
                    Seq nameInCache = CatalogV2Implicits$.MODULE$.IdentifierHelper(v2Ident).toQualifiedNameParts(catalog);
                    return CacheManager.isSameName$1(nameInCache, name, conf) && (includeTimeTravel || timeTravelSpec.isEmpty());
                }
            }
        }
        if (logicalPlan2 instanceof V2TableReference) {
            V2TableReference v2TableReference = (V2TableReference)logicalPlan2;
            return CacheManager.isSameName$1(CatalogV2Implicits$.MODULE$.IdentifierHelper(v2TableReference.identifier()).toQualifiedNameParts((CatalogPlugin)v2TableReference.catalog()), name, conf);
        }
        if (logicalPlan2 instanceof View) {
            View view = (View)logicalPlan2;
            return CacheManager.isSameName$1(view.desc().identifier().nameParts(), name, conf);
        }
        if (logicalPlan2 instanceof HiveTableRelation) {
            HiveTableRelation hiveTableRelation = (HiveTableRelation)logicalPlan2;
            CatalogTable catalogTable = hiveTableRelation.tableMeta();
            return CacheManager.isSameName$1(catalogTable.identifier().nameParts(), name, conf);
        }
        return false;
    }

    private void uncacheByCondition(SparkSession spark, Function1<LogicalPlan, Object> isMatchedPlan, boolean cascade, boolean blocking) {
        Function1 & Serializable shouldRemove = cascade ? (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.exists(isMatchedPlan)) : isMatchedPlan;
        IndexedSeq plansToUncache = (IndexedSeq)this.cachedData().filter((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheByCondition$2(shouldRemove, cd)));
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plansToUncache.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheByCondition$4(cd, x$5)))))));
        }
        plansToUncache.foreach((Function1 & Serializable)x$6 -> {
            CacheManager.$anonfun$uncacheByCondition$5(blocking, x$6);
            return BoxedUnit.UNIT;
        });
        CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Removed ", " Dataframe "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.SIZE, BoxesRunTime.boxToInteger((int)plansToUncache.size()))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cache entries, with logical plans being "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\\n[", "]"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.QUERY_PLAN, ((IterableOnceOps)plansToUncache.map((Function1 & Serializable)x$7 -> x$7.plan())).mkString(",\n"))}))));
        if (!cascade) {
            this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheByCondition$8(isMatchedPlan, cd)));
            return;
        }
    }

    public void analyzeColumnCacheQuery(SparkSession sparkSession, CachedData cachedData, Seq<Attribute> column) {
        InMemoryRelation relation = cachedData.cachedRepresentation();
        Tuple2<Object, scala.collection.immutable.Map<Attribute, ColumnStat>> tuple2 = CommandUtils$.MODULE$.computeColumnStats(sparkSession, relation, column);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long rowCount = tuple2._1$mcJ$sp();
        scala.collection.immutable.Map newColStats = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)newColStats);
        long rowCount2 = tuple22._1$mcJ$sp();
        scala.collection.immutable.Map newColStats2 = (scala.collection.immutable.Map)tuple22._2();
        relation.updateStats(rowCount2, (scala.collection.immutable.Map<Attribute, ColumnStat>)newColStats2);
    }

    public void recacheByPlan(SparkSession spark, LogicalPlan plan) {
        LogicalPlan normalized = QueryExecution$.MODULE$.normalize(spark, plan, QueryExecution$.MODULE$.normalize$default$3());
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPlan$1(normalized, x$9)));
    }

    public void recacheTableOrView(SparkSession spark, Seq<String> name, boolean includeTimeTravel) {
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)this.shouldInvalidate$1(entry, name, spark, includeTimeTravel)));
    }

    public boolean recacheTableOrView$default$3() {
        return true;
    }

    private void recacheByCondition(SparkSession spark, Function1<CachedData, Object> condition) {
        IndexedSeq needToRecache = (IndexedSeq)this.cachedData().filter(condition);
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)needToRecache.exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByCondition$2(cd, x$12)))))));
        }
        needToRecache.foreach((Function1 & Serializable)cd -> {
            CacheManager.$anonfun$recacheByCondition$3(this, spark, cd);
            return BoxedUnit.UNIT;
        });
    }

    public Option<CachedData> lookupCachedData(Dataset<?> query) {
        return this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(query.queryExecution().normalized());
    }

    public Option<CachedData> lookupCachedData(SparkSession session, LogicalPlan plan) {
        LogicalPlan normalized = QueryExecution$.MODULE$.normalize(session, plan, QueryExecution$.MODULE$.normalize$default$3());
        return this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(normalized);
    }

    public Option<CachedData> org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(LogicalPlan plan) {
        Option result;
        block0: {
            result = this.cachedData().find((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plan.sameResult((QueryPlan)cd.plan())));
            if (!result.isDefined()) break block0;
            CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dataframe cache hit for input plan:"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\\n", " matched with cache entry:"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.QUERY_PLAN, plan)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.DATAFRAME_CACHE_ENTRY, result.get())}))));
        }
        return result;
    }

    public LogicalPlan useCachedData(LogicalPlan plan) {
        LogicalPlan newPlan = (LogicalPlan)plan.transformDown((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof IgnoreCachedData) {
                    IgnoreCachedData ignoreCachedData = (IgnoreCachedData)A1;
                    return (B1)ignoreCachedData;
                }
                return (B1)this.$outer.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(A1).map((Function1 & Serializable)cached -> {
                    Seq hints = (Seq)EliminateResolvedHint$.MODULE$.extractHintsFromPlan(A1)._2();
                    InMemoryRelation cachedPlan = cached.cachedRepresentation().withOutput((Seq<Attribute>)A1.output());
                    return (LogicalPlan)hints.foldRight((Object)cachedPlan, (Function2 & Serializable)(x0$1, x1$1) -> {
                        Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                        if (tuple2 != null) {
                            HintInfo hint = (HintInfo)tuple2._1();
                            LogicalPlan p = (LogicalPlan)tuple2._2();
                            return new ResolvedHint(p, hint);
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }).getOrElse((Function0 & Serializable)() -> A1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                if (logicalPlan2 instanceof IgnoreCachedData) {
                    return true;
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.execution.CachedData ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.plans.logical.HintInfo org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan )}, serializedLambda);
            }
        });
        LogicalPlan result = newPlan.transformAllExpressionsWithPruning((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.containsPattern(TreePattern$.MODULE$.PLAN_EXPRESSION())), newPlan.transformAllExpressionsWithPruning$default$2(), (PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)A1;
                    return (B1)subqueryExpression.withNewPlan(this.$outer.useCachedData((LogicalPlan)subqueryExpression.plan()));
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                return expression instanceof SubqueryExpression;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (result.fastEquals((TreeNode)plan)) {
            CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dataframe cache miss for input plan:\\n", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.QUERY_PLAN, plan)})));
            CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Last 20 Dataframe cache entry logical plans:\\n"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[", "]"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.DATAFRAME_CACHE_ENTRY, ((IterableOnceOps)((IndexedSeqOps)this.cachedData().take(20)).map((Function1 & Serializable)x$14 -> x$14.plan())).mkString(",\n"))}))));
        } else {
            CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dataframe cache hit plan change summary:\\n"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.QUERY_PLAN_COMPARISON, org.apache.spark.sql.catalyst.util.package$.MODULE$.sideBySide(plan.treeString(), result.treeString()).mkString("\n"))}))));
        }
        return result;
    }

    public void recacheByPath(SparkSession spark, String resourcePath) {
        Path path = new Path(resourcePath);
        FileSystem fs = path.getFileSystem(spark.sessionState().newHadoopConf());
        this.recacheByPath(spark, path, fs);
    }

    public void recacheByPath(SparkSession spark, Path resourcePath, FileSystem fs) {
        Path qualifiedPath = fs.makeQualified(resourcePath);
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPath$1(this, fs, qualifiedPath, x$15)));
    }

    private boolean lookupAndRefresh(LogicalPlan plan, FileSystem fs, Path qualifiedPath) {
        Table fileTable;
        DataSourceV2Relation dataSourceV2Relation;
        Option option;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof LogicalRelation) {
            LogicalRelation logicalRelation = (LogicalRelation)logicalPlan2;
            BaseRelation baseRelation = logicalRelation.relation();
            if (baseRelation instanceof HadoopFsRelation) {
                HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
                return this.refreshFileIndexIfNecessary(hadoopFsRelation.location(), fs, qualifiedPath);
            }
            return false;
        }
        if (logicalPlan2 instanceof DataSourceV2Relation && !(option = ExtractV2Table$.MODULE$.unapply(dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2)).isEmpty() && (fileTable = (Table)option.get()) instanceof FileTable) {
            FileTable fileTable2 = (FileTable)fileTable;
            return this.refreshFileIndexIfNecessary(fileTable2.fileIndex(), fs, qualifiedPath);
        }
        return false;
    }

    private boolean refreshFileIndexIfNecessary(FileIndex fileIndex, FileSystem fs, Path qualifiedPath) {
        boolean needToRefresh;
        block0: {
            needToRefresh = ((IterableOnceOps)fileIndex.rootPaths().map((Function1 & Serializable)x$17 -> x$17.makeQualified(fs.getUri(), fs.getWorkingDirectory()))).exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)this.isSubDir(qualifiedPath, x$18)));
            if (!needToRefresh) break block0;
            fileIndex.refresh();
        }
        return needToRefresh;
    }

    public boolean isSubDir(Path qualifiedPathParent, Path qualifiedPathChild) {
        return package$.MODULE$.Iterator().iterate((Object)qualifiedPathChild, (Function1 & Serializable)x$19 -> x$19.getParent()).takeWhile((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$isSubDir$2(x$20))).exists((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)x$21.equals((Object)qualifiedPathParent)));
    }

    private SparkSession getOrCloneSessionWithConfigsOff(SparkSession session) {
        .colon.colon disableConfigs;
        block0: {
            disableConfigs = new .colon.colon((Object)SQLConf$.MODULE$.AUTO_BUCKETED_SCAN_ENABLED(), (List)Nil$.MODULE$);
            if (BoxesRunTime.unboxToBoolean((Object)session.sessionState().conf().getConf(SQLConf$.MODULE$.CAN_CHANGE_CACHED_PLAN_OUTPUT_PARTITIONING()))) break block0;
            disableConfigs = (Seq)disableConfigs.$colon$plus((Object)SQLConf$.MODULE$.ADAPTIVE_EXECUTION_APPLY_FINAL_STAGE_SHUFFLE_OPTIMIZATIONS());
        }
        return SparkSession$.MODULE$.getOrCloneSessionWithConfigsOff(session, (Seq<ConfigEntry<Object>>)disableConfigs);
    }

    public static final /* synthetic */ void $anonfun$clearCache$1(CachedData x$1) {
        x$1.cachedRepresentation().cacheBuilder().clearCache(x$1.cachedRepresentation().cacheBuilder().clearCache$default$1());
    }

    private static final boolean isSameName$1(Seq nameInCache, Seq name$2, SQLConf conf$1) {
        return nameInCache.length() == name$2.length() && ((IterableOnceOps)nameInCache.zip((IterableOnce)name$2)).forall(conf$1.resolver().tupled());
    }

    public static final /* synthetic */ boolean $anonfun$uncacheByCondition$2(Function1 shouldRemove$1, CachedData cd) {
        return BoxesRunTime.unboxToBoolean((Object)shouldRemove$1.apply((Object)cd.plan()));
    }

    public static final /* synthetic */ boolean $anonfun$uncacheByCondition$4(CachedData cd$2, CachedData x$5) {
        return x$5 == cd$2;
    }

    public static final /* synthetic */ void $anonfun$uncacheByCondition$5(boolean blocking$1, CachedData x$6) {
        x$6.cachedRepresentation().cacheBuilder().clearCache(blocking$1);
    }

    public static final /* synthetic */ boolean $anonfun$uncacheByCondition$8(Function1 isMatchedPlan$1, CachedData cd) {
        boolean cacheAlreadyLoaded = cd.cachedRepresentation().cacheBuilder().isCachedColumnBuffersLoaded();
        return cd.plan().exists(isMatchedPlan$1) && !cacheAlreadyLoaded;
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPlan$1(LogicalPlan normalized$1, CachedData x$9) {
        return x$9.plan().exists((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.sameResult((QueryPlan)normalized$1)));
    }

    private final boolean shouldInvalidate$1(CachedData entry, Seq name$3, SparkSession spark$2, boolean includeTimeTravel$1) {
        return entry.plan().exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)this.isMatchedTableOrView(x$11, (Seq<String>)name$3, spark$2.sessionState().conf(), includeTimeTravel$1)));
    }

    public static final /* synthetic */ boolean $anonfun$recacheByCondition$2(CachedData cd$3, CachedData x$12) {
        return x$12 == cd$3;
    }

    public static final /* synthetic */ void $anonfun$recacheByCondition$3(CacheManager $this, SparkSession spark$3, CachedData cd) {
        InMemoryRelation newCache;
        cd.cachedRepresentation().cacheBuilder().clearCache(cd.cachedRepresentation().cacheBuilder().clearCache$default$1());
        SparkSession sessionWithConfigsOff = $this.getOrCloneSessionWithConfigsOff(spark$3);
        InMemoryRelation x$1 = newCache = (InMemoryRelation)sessionWithConfigsOff.withActive((Function0 & Serializable)() -> {
            QueryExecution qe = sessionWithConfigsOff.sessionState().executePlan(cd.plan(), sessionWithConfigsOff.sessionState().executePlan$default$2());
            return InMemoryRelation$.MODULE$.apply(cd.cachedRepresentation().cacheBuilder(), qe);
        });
        LogicalPlan x$2 = cd.copy$default$1();
        CachedData recomputedPlan = cd.copy(x$2, x$1);
        CacheManager cacheManager = $this;
        synchronized (cacheManager) {
            if ($this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(recomputedPlan.plan()).nonEmpty()) {
                $this.logWarning((Function0<String>)(Function0 & Serializable)() -> "While recaching, data was already added to cache.");
            } else {
                CachedData cachedData = recomputedPlan;
                $this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)$this.cachedData().$plus$colon((Object)cachedData)));
                CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Re-cached Dataframe cache entry:"}))).log((Seq)Nil$.MODULE$).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.DATAFRAME_CACHE_ENTRY, recomputedPlan)}))));
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPath$1(CacheManager $this, FileSystem fs$1, Path qualifiedPath$1, CachedData x$15) {
        return x$15.plan().exists((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)$this.lookupAndRefresh(x$16, fs$1, qualifiedPath$1)));
    }

    public static final /* synthetic */ boolean $anonfun$isSubDir$2(Path x$20) {
        return x$20 != null;
    }

    public CacheManager() {
        Logging.$init$((Logging)this);
        AdaptiveSparkPlanHelper.$init$(this);
        this.cachedData = (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Nil$.MODULE$);
    }
}

