/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.Serializable;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.internal.types.GeographicSpatialReferenceSystemMapper;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.EdgeInterpolationAlgorithm;
import org.apache.spark.sql.types.EdgeInterpolationAlgorithm$;
import org.apache.spark.sql.types.EdgeInterpolationAlgorithm$SPHERICAL$;
import org.apache.spark.sql.types.GeographyType;
import org.apache.spark.sql.types.SpatialType;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

@Experimental
public final class GeographyType$
extends AbstractDataType
implements SpatialType,
Serializable {
    public static final GeographyType$ MODULE$ = new GeographyType$();
    private static final EdgeInterpolationAlgorithm$SPHERICAL$ GEOGRAPHY_DEFAULT_ALGORITHM;
    private static final String GEOGRAPHY_DEFAULT_EPSG_CRS;
    private static final GeographyType GEOGRAPHY_MIXED_TYPE;
    private static int MIXED_SRID;
    private static String MIXED_CRS;

    static {
        SpatialType.$init$(MODULE$);
        GEOGRAPHY_DEFAULT_ALGORITHM = EdgeInterpolationAlgorithm$SPHERICAL$.MODULE$;
        GEOGRAPHY_DEFAULT_EPSG_CRS = "EPSG:" + 4326;
        GEOGRAPHY_MIXED_TYPE = MODULE$.apply(MODULE$.MIXED_CRS(), MODULE$.GEOGRAPHY_DEFAULT_ALGORITHM());
    }

    @Override
    public final int MIXED_SRID() {
        return MIXED_SRID;
    }

    @Override
    public final String MIXED_CRS() {
        return MIXED_CRS;
    }

    @Override
    public final void org$apache$spark$sql$types$SpatialType$_setter_$MIXED_SRID_$eq(int x$1) {
        MIXED_SRID = x$1;
    }

    @Override
    public final void org$apache$spark$sql$types$SpatialType$_setter_$MIXED_CRS_$eq(String x$1) {
        MIXED_CRS = x$1;
    }

    public final int GEOGRAPHY_DEFAULT_SRID() {
        return 4326;
    }

    public final String GEOGRAPHY_DEFAULT_CRS() {
        return "OGC:CRS84";
    }

    public final EdgeInterpolationAlgorithm$SPHERICAL$ GEOGRAPHY_DEFAULT_ALGORITHM() {
        return GEOGRAPHY_DEFAULT_ALGORITHM;
    }

    public final String GEOGRAPHY_DEFAULT_EPSG_CRS() {
        return GEOGRAPHY_DEFAULT_EPSG_CRS;
    }

    private final GeographyType GEOGRAPHY_MIXED_TYPE() {
        return GEOGRAPHY_MIXED_TYPE;
    }

    public boolean isSridSupported(int srid) {
        return GeographicSpatialReferenceSystemMapper.getStringId(srid) != null;
    }

    public GeographyType apply(int srid) {
        String crs = GeographicSpatialReferenceSystemMapper.getStringId(srid);
        if (crs == null) {
            throw new SparkIllegalArgumentException("ST_INVALID_SRID_VALUE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srid"), (Object)Integer.toString(srid))})));
        }
        return new GeographyType("OGC:CRS84", this.GEOGRAPHY_DEFAULT_ALGORITHM());
    }

    public GeographyType apply(String crs) {
        String string = crs;
        switch (string == null ? 0 : string.hashCode()) {
            case 64972: {
                if (!"ANY".equals(string)) break;
                return new GeographyType(this.MIXED_CRS(), this.GEOGRAPHY_DEFAULT_ALGORITHM());
            }
        }
        return this.apply(crs, this.GEOGRAPHY_DEFAULT_ALGORITHM().toString());
    }

    public GeographyType apply(String crs, String algorithm) {
        Option<EdgeInterpolationAlgorithm> option = EdgeInterpolationAlgorithm$.MODULE$.fromString(algorithm);
        if (option instanceof Some) {
            Some some = (Some)option;
            EdgeInterpolationAlgorithm alg = (EdgeInterpolationAlgorithm)some.value();
            return this.apply(crs, alg);
        }
        if (None$.MODULE$.equals(option)) {
            throw new SparkIllegalArgumentException("ST_INVALID_ALGORITHM_VALUE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"alg"), (Object)algorithm)})));
        }
        throw new MatchError(option);
    }

    public GeographyType apply(String crs, EdgeInterpolationAlgorithm algorithm) {
        return new GeographyType(crs, algorithm);
    }

    @Override
    public DataType defaultConcreteType() {
        return this.GEOGRAPHY_MIXED_TYPE();
    }

    @Override
    public boolean acceptsType(DataType other) {
        return other instanceof GeographyType;
    }

    @Override
    public String simpleString() {
        return "geography";
    }

    public int toSrid(String crs) {
        if (crs.equalsIgnoreCase(this.MIXED_CRS())) {
            return this.MIXED_SRID();
        }
        Integer srid = GeographicSpatialReferenceSystemMapper.getSrid(crs);
        if (srid == null) {
            throw new SparkIllegalArgumentException("ST_INVALID_CRS_VALUE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"crs"), (Object)crs)})));
        }
        return Predef$.MODULE$.Integer2int(srid);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GeographyType$.class);
    }

    private GeographyType$() {
    }
}

