/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import java.util.ArrayList;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.security.aot.hint.AuthorizeReturnObjectCoreHintsRegistrar;
import org.springframework.security.aot.hint.SecurityHintsRegistrar;
import org.springframework.security.authorization.AuthorizationProxyFactory;
import org.springframework.security.authorization.method.AuthorizationAdvisor;
import org.springframework.security.authorization.method.AuthorizationAdvisorProxyFactory;
import org.springframework.security.authorization.method.AuthorizeReturnObjectMethodInterceptor;
import org.springframework.security.config.Customizer;

@Configuration(proxyBeanMethods=false)
final class AuthorizationProxyConfiguration
implements AopInfrastructureBean {
    AuthorizationProxyConfiguration() {
    }

    @Bean
    @Role(value=2)
    static AuthorizationAdvisorProxyFactory authorizationProxyFactory(ObjectProvider<Customizer<AuthorizationAdvisorProxyFactory>> customizers) {
        AuthorizationAdvisorProxyFactory factory = new AuthorizationAdvisorProxyFactory(new ArrayList());
        customizers.forEach(c -> c.customize(factory));
        return factory;
    }

    @Bean
    @Role(value=2)
    static MethodInterceptor authorizeReturnObjectMethodInterceptor(ObjectProvider<AuthorizationAdvisor> provider, AuthorizationAdvisorProxyFactory authorizationProxyFactory) {
        provider.forEach(arg_0 -> ((AuthorizationAdvisorProxyFactory)authorizationProxyFactory).addAdvisor(arg_0));
        AuthorizeReturnObjectMethodInterceptor interceptor = new AuthorizeReturnObjectMethodInterceptor((AuthorizationProxyFactory)authorizationProxyFactory);
        authorizationProxyFactory.addAdvisor((AuthorizationAdvisor)interceptor);
        return interceptor;
    }

    @Bean
    @Role(value=2)
    static SecurityHintsRegistrar authorizeReturnObjectHintsRegistrar(AuthorizationProxyFactory proxyFactory) {
        return new AuthorizeReturnObjectCoreHintsRegistrar(proxyFactory);
    }
}

