/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.task.service.impl.persistence.entity;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskBuilder;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.history.HistoricTaskLogEntryBuilder;
import org.flowable.task.api.history.HistoricTaskLogEntryType;
import org.flowable.task.service.TaskServiceConfiguration;
import org.flowable.task.service.event.impl.FlowableTaskEventBuilder;
import org.flowable.task.service.impl.BaseHistoricTaskLogEntryBuilderImpl;
import org.flowable.task.service.impl.TaskQueryImpl;
import org.flowable.task.service.impl.persistence.CountingTaskEntity;
import org.flowable.task.service.impl.persistence.entity.AbstractTaskServiceEntityManager;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntityManager;
import org.flowable.task.service.impl.persistence.entity.data.TaskDataManager;

public class TaskEntityManagerImpl
extends AbstractTaskServiceEntityManager<TaskEntity, TaskDataManager>
implements TaskEntityManager {
    public TaskEntityManagerImpl(TaskServiceConfiguration taskServiceConfiguration, TaskDataManager taskDataManager) {
        super(taskServiceConfiguration, taskDataManager);
    }

    public TaskEntity create() {
        TaskEntity taskEntity = (TaskEntity)super.create();
        taskEntity.setCreateTime(this.getClock().getCurrentTime());
        taskEntity.setState("created");
        if (((TaskServiceConfiguration)this.serviceConfiguration).isEnableTaskRelationshipCounts()) {
            ((CountingTaskEntity)((Object)taskEntity)).setCountEnabled(true);
        }
        return taskEntity;
    }

    @Override
    public TaskEntity createTask(TaskBuilder taskBuilder) {
        TaskEntity taskEntity = this.create();
        taskEntity.setId(taskBuilder.getId());
        taskEntity.setName(taskBuilder.getName());
        taskEntity.setDescription(taskBuilder.getDescription());
        taskEntity.setPriority(taskBuilder.getPriority());
        taskEntity.setOwner(taskBuilder.getOwner());
        taskEntity.setAssignee(taskBuilder.getAssignee());
        taskEntity.setDueDate(taskBuilder.getDueDate());
        taskEntity.setCategory(taskBuilder.getCategory());
        taskEntity.setParentTaskId(taskBuilder.getParentTaskId());
        taskEntity.setTenantId(taskBuilder.getTenantId());
        taskEntity.setFormKey(taskBuilder.getFormKey());
        taskEntity.setTaskDefinitionId(taskBuilder.getTaskDefinitionId());
        taskEntity.setTaskDefinitionKey(taskBuilder.getTaskDefinitionKey());
        taskEntity.setScopeId(taskBuilder.getScopeId());
        taskEntity.setScopeType(taskBuilder.getScopeType());
        this.insert(taskEntity);
        TaskEntity enrichedTaskEntity = ((TaskServiceConfiguration)this.serviceConfiguration).getTaskPostProcessor().enrich(taskEntity);
        this.update(enrichedTaskEntity, false);
        taskBuilder.getIdentityLinks().forEach(identityLink -> {
            if (identityLink.getGroupId() != null) {
                enrichedTaskEntity.addGroupIdentityLink(identityLink.getGroupId(), identityLink.getType());
            } else if (identityLink.getUserId() != null) {
                enrichedTaskEntity.addUserIdentityLink(identityLink.getUserId(), identityLink.getType());
            }
        });
        if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled() && taskEntity.getAssignee() != null) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableTaskEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_ASSIGNED, taskEntity), ((TaskServiceConfiguration)this.serviceConfiguration).getEngineName());
        }
        ((TaskServiceConfiguration)this.serviceConfiguration).getInternalHistoryTaskManager().recordTaskCreated(taskEntity);
        return enrichedTaskEntity;
    }

    public void insert(TaskEntity taskEntity, boolean fireCreatedEvent) {
        super.insert((Entity)taskEntity, fireCreatedEvent);
        if (fireCreatedEvent) {
            this.logTaskCreatedEvent((TaskInfo)taskEntity);
        }
    }

    public TaskEntity update(TaskEntity taskEntity, boolean fireUpdateEvents) {
        if (fireUpdateEvents) {
            this.logTaskUpdateEvents(taskEntity);
        }
        return (TaskEntity)super.update((Entity)taskEntity, fireUpdateEvents);
    }

    @Override
    public void changeTaskAssignee(TaskEntity taskEntity, String assignee) {
        if (taskEntity.getAssignee() != null && !taskEntity.getAssignee().equals(assignee) || taskEntity.getAssignee() == null && assignee != null) {
            taskEntity.setAssignee(assignee);
            if (taskEntity.getId() != null) {
                ((TaskServiceConfiguration)this.serviceConfiguration).getInternalHistoryTaskManager().recordTaskInfoChange(taskEntity, this.getClock().getCurrentTime());
                this.update(taskEntity);
            }
        }
    }

    @Override
    public void changeTaskOwner(TaskEntity taskEntity, String owner) {
        if (taskEntity.getOwner() != null && !taskEntity.getOwner().equals(owner) || taskEntity.getOwner() == null && owner != null) {
            taskEntity.setOwner(owner);
            if (taskEntity.getId() != null) {
                ((TaskServiceConfiguration)this.serviceConfiguration).getInternalHistoryTaskManager().recordTaskInfoChange(taskEntity, this.getClock().getCurrentTime());
                this.update(taskEntity);
            }
        }
    }

    @Override
    public List<TaskEntity> findTasksByExecutionId(String executionId) {
        return ((TaskDataManager)this.dataManager).findTasksByExecutionId(executionId);
    }

    @Override
    public List<TaskEntity> findTasksByProcessInstanceId(String processInstanceId) {
        return ((TaskDataManager)this.dataManager).findTasksByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<TaskEntity> findTasksByScopeIdAndScopeType(String scopeId, String scopeType) {
        return ((TaskDataManager)this.dataManager).findTasksByScopeIdAndScopeType(scopeId, scopeType);
    }

    @Override
    public List<TaskEntity> findTasksBySubScopeIdAndScopeType(String subScopeId, String scopeType) {
        return ((TaskDataManager)this.dataManager).findTasksBySubScopeIdAndScopeType(subScopeId, scopeType);
    }

    @Override
    public List<Task> findTasksByQueryCriteria(TaskQueryImpl taskQuery) {
        return ((TaskDataManager)this.dataManager).findTasksByQueryCriteria(taskQuery);
    }

    @Override
    public List<Task> findTasksWithRelatedEntitiesByQueryCriteria(TaskQueryImpl taskQuery) {
        return ((TaskDataManager)this.dataManager).findTasksWithRelatedEntitiesByQueryCriteria(taskQuery);
    }

    @Override
    public long findTaskCountByQueryCriteria(TaskQueryImpl taskQuery) {
        return ((TaskDataManager)this.dataManager).findTaskCountByQueryCriteria(taskQuery);
    }

    @Override
    public List<Task> findTasksByNativeQuery(Map<String, Object> parameterMap) {
        return ((TaskDataManager)this.dataManager).findTasksByNativeQuery(parameterMap);
    }

    @Override
    public long findTaskCountByNativeQuery(Map<String, Object> parameterMap) {
        return ((TaskDataManager)this.dataManager).findTaskCountByNativeQuery(parameterMap);
    }

    @Override
    public List<Task> findTasksByParentTaskId(String parentTaskId) {
        return ((TaskDataManager)this.dataManager).findTasksByParentTaskId(parentTaskId);
    }

    @Override
    public void updateTaskTenantIdForDeployment(String deploymentId, String newTenantId) {
        ((TaskDataManager)this.dataManager).updateTaskTenantIdForDeployment(deploymentId, newTenantId);
    }

    @Override
    public void updateAllTaskRelatedEntityCountFlags(boolean configProperty) {
        ((TaskDataManager)this.dataManager).updateAllTaskRelatedEntityCountFlags(configProperty);
    }

    @Override
    public void deleteTasksByExecutionId(String executionId) {
        ((TaskDataManager)this.dataManager).deleteTasksByExecutionId(executionId);
    }

    protected void logAssigneeChanged(TaskEntity taskEntity, String previousAssignee, String newAssignee) {
        if (((TaskServiceConfiguration)this.serviceConfiguration).isEnableHistoricTaskLogging()) {
            ObjectNode dataNode = ((TaskServiceConfiguration)this.serviceConfiguration).getObjectMapper().createObjectNode();
            dataNode.put("newAssigneeId", newAssignee);
            dataNode.put("previousAssigneeId", previousAssignee);
            this.recordHistoryUserTaskLog(HistoricTaskLogEntryType.USER_TASK_ASSIGNEE_CHANGED, (TaskInfo)taskEntity, dataNode);
        }
    }

    protected void logOwnerChanged(TaskEntity taskEntity, String previousOwner, String newOwner) {
        if (((TaskServiceConfiguration)this.serviceConfiguration).isEnableHistoricTaskLogging()) {
            ObjectNode dataNode = ((TaskServiceConfiguration)this.serviceConfiguration).getObjectMapper().createObjectNode();
            dataNode.put("newOwnerId", newOwner);
            dataNode.put("previousOwnerId", previousOwner);
            this.recordHistoryUserTaskLog(HistoricTaskLogEntryType.USER_TASK_OWNER_CHANGED, (TaskInfo)taskEntity, dataNode);
        }
    }

    protected void logPriorityChanged(TaskEntity taskEntity, Integer previousPriority, int newPriority) {
        if (((TaskServiceConfiguration)this.serviceConfiguration).isEnableHistoricTaskLogging()) {
            ObjectNode dataNode = ((TaskServiceConfiguration)this.serviceConfiguration).getObjectMapper().createObjectNode();
            dataNode.put("newPriority", newPriority);
            dataNode.put("previousPriority", previousPriority);
            this.recordHistoryUserTaskLog(HistoricTaskLogEntryType.USER_TASK_PRIORITY_CHANGED, (TaskInfo)taskEntity, dataNode);
        }
    }

    protected void logDueDateChanged(TaskEntity taskEntity, Date previousDueDate, Date newDueDate) {
        if (((TaskServiceConfiguration)this.serviceConfiguration).isEnableHistoricTaskLogging()) {
            ObjectNode dataNode = ((TaskServiceConfiguration)this.serviceConfiguration).getObjectMapper().createObjectNode();
            dataNode.put("newDueDate", newDueDate != null ? Long.valueOf(newDueDate.getTime()) : null);
            dataNode.put("previousDueDate", previousDueDate != null ? Long.valueOf(previousDueDate.getTime()) : null);
            this.recordHistoryUserTaskLog(HistoricTaskLogEntryType.USER_TASK_DUEDATE_CHANGED, (TaskInfo)taskEntity, dataNode);
        }
    }

    protected void logNameChanged(TaskEntity taskEntity, String previousName, String newName) {
        if (((TaskServiceConfiguration)this.serviceConfiguration).isEnableHistoricTaskLogging()) {
            ObjectNode dataNode = ((TaskServiceConfiguration)this.serviceConfiguration).getObjectMapper().createObjectNode();
            dataNode.put("newName", newName);
            dataNode.put("previousName", previousName);
            this.recordHistoryUserTaskLog(HistoricTaskLogEntryType.USER_TASK_NAME_CHANGED, (TaskInfo)taskEntity, dataNode);
        }
    }

    protected void logTaskCreatedEvent(TaskInfo task) {
        if (((TaskServiceConfiguration)this.serviceConfiguration).isEnableHistoricTaskLogging()) {
            HistoricTaskLogEntryBuilder taskLogEntryBuilder = this.createHistoricTaskLogEntryBuilder(task, HistoricTaskLogEntryType.USER_TASK_CREATED);
            taskLogEntryBuilder.timeStamp(task.getCreateTime());
            ((TaskServiceConfiguration)this.serviceConfiguration).getInternalHistoryTaskManager().recordHistoryUserTaskLog(taskLogEntryBuilder);
        }
    }

    protected HistoricTaskLogEntryBuilder createHistoricTaskLogEntryBuilder(TaskInfo task, HistoricTaskLogEntryType userTaskCreated) {
        BaseHistoricTaskLogEntryBuilderImpl taskLogEntryBuilder = new BaseHistoricTaskLogEntryBuilderImpl(task);
        taskLogEntryBuilder.timeStamp(((TaskServiceConfiguration)this.serviceConfiguration).getClock().getCurrentTime());
        taskLogEntryBuilder.userId(Authentication.getAuthenticatedUserId());
        taskLogEntryBuilder.type(userTaskCreated.name());
        return taskLogEntryBuilder;
    }

    protected void logTaskUpdateEvents(TaskEntity task) {
        if (this.wasPersisted(task)) {
            if (!Objects.equals(task.getAssignee(), this.getOriginalState(task, "assignee"))) {
                this.logAssigneeChanged(task, (String)this.getOriginalState(task, "assignee"), task.getAssignee());
            }
            if (!Objects.equals(task.getOwner(), this.getOriginalState(task, "owner"))) {
                if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
                    this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableTaskEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_OWNER_CHANGED, task), ((TaskServiceConfiguration)this.serviceConfiguration).getEngineName());
                }
                this.logOwnerChanged(task, (String)this.getOriginalState(task, "owner"), task.getOwner());
            }
            if (!Objects.equals(task.getPriority(), this.getOriginalState(task, "priority"))) {
                if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
                    this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableTaskEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_PRIORITY_CHANGED, task), ((TaskServiceConfiguration)this.serviceConfiguration).getEngineName());
                }
                this.logPriorityChanged(task, (Integer)this.getOriginalState(task, "priority"), task.getPriority());
            }
            if (!Objects.equals(task.getDueDate(), this.getOriginalState(task, "dueDate"))) {
                if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
                    this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableTaskEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_DUEDATE_CHANGED, task), ((TaskServiceConfiguration)this.serviceConfiguration).getEngineName());
                }
                this.logDueDateChanged(task, (Date)this.getOriginalState(task, "dueDate"), task.getDueDate());
            }
            if (!Objects.equals(task.getName(), this.getOriginalState(task, "name"))) {
                if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
                    this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableTaskEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_NAME_CHANGED, task), ((TaskServiceConfiguration)this.serviceConfiguration).getEngineName());
                }
                this.logNameChanged(task, (String)this.getOriginalState(task, "name"), task.getName());
            }
        }
    }

    protected boolean wasPersisted(TaskEntity task) {
        return task.getOriginalPersistentState() != null && ((Map)task.getOriginalPersistentState()).size() > 0;
    }

    protected Object getOriginalState(TaskEntity task, String stateKey) {
        if (task.getOriginalPersistentState() != null) {
            return ((Map)task.getOriginalPersistentState()).get(stateKey);
        }
        return null;
    }

    protected void recordHistoryUserTaskLog(HistoricTaskLogEntryType logEntryType, TaskInfo task, ObjectNode dataNode) {
        HistoricTaskLogEntryBuilder taskLogEntryBuilder = this.createHistoricTaskLogEntryBuilder(task, logEntryType);
        taskLogEntryBuilder.data(dataNode.toString());
        ((TaskServiceConfiguration)this.serviceConfiguration).getInternalHistoryTaskManager().recordHistoryUserTaskLog(taskLogEntryBuilder);
    }
}

