/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.persistence.entity;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.javax.el.ELContext;
import org.flowable.common.engine.impl.logging.LoggingSessionUtil;
import org.flowable.common.engine.impl.persistence.entity.AbstractEntity;
import org.flowable.variable.api.delegate.VariableScope;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.event.impl.FlowableVariableEventBuilder;
import org.flowable.variable.service.impl.VariableInstanceValueModifier;
import org.flowable.variable.service.impl.persistence.entity.TransientVariableInstance;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntityManager;
import org.flowable.variable.service.impl.util.VariableLoggingSessionUtil;

public abstract class VariableScopeImpl
extends AbstractEntity
implements Serializable,
VariableScope {
    private static final long serialVersionUID = 1L;
    protected Map<String, VariableInstanceEntity> variableInstances;
    protected Map<String, VariableInstanceEntity> usedVariablesCache = new HashMap<String, VariableInstanceEntity>();
    protected Map<String, VariableInstance> transientVariables;
    protected ELContext cachedElContext;

    protected abstract Collection<VariableInstanceEntity> loadVariableInstances();

    protected abstract VariableScopeImpl getParentVariableScope();

    protected abstract void initializeVariableInstanceBackPointer(VariableInstance var1);

    protected abstract void addLoggingSessionInfo(ObjectNode var1);

    protected void ensureVariableInstancesInitialized() {
        if (this.variableInstances == null) {
            this.variableInstances = new HashMap<String, VariableInstanceEntity>();
            CommandContext commandContext = Context.getCommandContext();
            if (commandContext == null) {
                throw new FlowableException("lazy loading outside command context for " + String.valueOf(this));
            }
            Collection<VariableInstanceEntity> variableInstancesList = this.loadVariableInstances();
            for (VariableInstanceEntity variableInstance : variableInstancesList) {
                this.variableInstances.put(variableInstance.getName(), variableInstance);
            }
        }
    }

    public void internalSetVariableInstances(Map<String, VariableInstanceEntity> variableInstances) {
        this.variableInstances = variableInstances;
    }

    public Map<String, Object> getVariables() {
        return this.collectVariables(new HashMap<String, Object>());
    }

    public Map<String, VariableInstance> getVariableInstances() {
        return this.collectVariableInstances(new HashMap<String, VariableInstance>());
    }

    public Map<String, Object> getVariables(Collection<String> variableNames) {
        return this.getVariables(variableNames, true);
    }

    public Map<String, VariableInstance> getVariableInstances(Collection<String> variableNames) {
        return this.getVariableInstances(variableNames, true);
    }

    public Map<String, Object> getVariables(Collection<String> variableNames, boolean fetchAllVariables) {
        HashMap<String, Object> requestedVariables = new HashMap<String, Object>();
        HashSet<String> variableNamesToFetch = new HashSet<String>(variableNames);
        for (String string : variableNames) {
            if (this.transientVariables != null && this.transientVariables.containsKey(string)) {
                requestedVariables.put(string, this.transientVariables.get(string).getValue());
                variableNamesToFetch.remove(string);
                continue;
            }
            if (!this.usedVariablesCache.containsKey(string)) continue;
            requestedVariables.put(string, this.usedVariablesCache.get(string).getValue());
            variableNamesToFetch.remove(string);
        }
        if (fetchAllVariables) {
            Map<String, Object> allVariables = this.getVariables();
            for (String variableName : variableNamesToFetch) {
                requestedVariables.put(variableName, allVariables.get(variableName));
            }
        } else {
            VariableScopeImpl parent = this.getParentVariableScope();
            if (parent != null) {
                requestedVariables.putAll(parent.getVariables(variableNamesToFetch, fetchAllVariables));
            }
            List<VariableInstanceEntity> list = this.getSpecificVariables(variableNamesToFetch);
            for (VariableInstanceEntity variable : list) {
                requestedVariables.put(variable.getName(), variable.getValue());
            }
        }
        return requestedVariables;
    }

    public Map<String, VariableInstance> getVariableInstances(Collection<String> variableNames, boolean fetchAllVariables) {
        HashMap<String, VariableInstance> requestedVariables = new HashMap<String, VariableInstance>();
        HashSet<String> variableNamesToFetch = new HashSet<String>(variableNames);
        for (String string : variableNames) {
            if (this.transientVariables != null && this.transientVariables.containsKey(string)) {
                requestedVariables.put(string, this.transientVariables.get(string));
                variableNamesToFetch.remove(string);
                continue;
            }
            if (!this.usedVariablesCache.containsKey(string)) continue;
            requestedVariables.put(string, this.usedVariablesCache.get(string));
            variableNamesToFetch.remove(string);
        }
        if (fetchAllVariables) {
            Map<String, VariableInstance> allVariables = this.getVariableInstances();
            for (String variableName : variableNamesToFetch) {
                requestedVariables.put(variableName, allVariables.get(variableName));
            }
        } else {
            VariableScopeImpl parent = this.getParentVariableScope();
            if (parent != null) {
                requestedVariables.putAll(parent.getVariableInstances(variableNamesToFetch, fetchAllVariables));
            }
            List<VariableInstanceEntity> list = this.getSpecificVariables(variableNamesToFetch);
            for (VariableInstanceEntity variable : list) {
                requestedVariables.put(variable.getName(), variable);
            }
        }
        return requestedVariables;
    }

    protected Map<String, Object> collectVariables(HashMap<String, Object> variables) {
        this.ensureVariableInstancesInitialized();
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variables.putAll(parentScope.collectVariables(variables));
        }
        for (VariableInstanceEntity variableInstance : this.variableInstances.values()) {
            variables.put(variableInstance.getName(), variableInstance.getValue());
        }
        for (String variableName : this.usedVariablesCache.keySet()) {
            variables.put(variableName, this.usedVariablesCache.get(variableName).getValue());
        }
        if (this.transientVariables != null) {
            for (String variableName : this.transientVariables.keySet()) {
                variables.put(variableName, this.transientVariables.get(variableName).getValue());
            }
        }
        return variables;
    }

    protected Map<String, VariableInstance> collectVariableInstances(HashMap<String, VariableInstance> variables) {
        this.ensureVariableInstancesInitialized();
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variables.putAll(parentScope.collectVariableInstances(variables));
        }
        for (VariableInstance variableInstance : this.variableInstances.values()) {
            variables.put(variableInstance.getName(), variableInstance);
        }
        for (String string : this.usedVariablesCache.keySet()) {
            variables.put(string, this.usedVariablesCache.get(string));
        }
        if (this.transientVariables != null) {
            variables.putAll(this.transientVariables);
        }
        return variables;
    }

    public Object getVariable(String variableName) {
        return this.getVariable(variableName, true);
    }

    public VariableInstance getVariableInstance(String variableName) {
        return this.getVariableInstance(variableName, true);
    }

    public Object getVariable(String variableName, boolean fetchAllVariables) {
        Object value = null;
        VariableInstance variable = this.getVariableInstance(variableName, fetchAllVariables);
        if (variable != null) {
            value = variable.getValue();
        }
        return value;
    }

    public VariableInstance getVariableInstance(String variableName, boolean fetchAllVariables) {
        if (this.transientVariables != null && this.transientVariables.containsKey(variableName)) {
            return this.transientVariables.get(variableName);
        }
        if (this.usedVariablesCache.containsKey(variableName)) {
            return this.usedVariablesCache.get(variableName);
        }
        if (fetchAllVariables) {
            this.ensureVariableInstancesInitialized();
            VariableInstanceEntity variableInstance = this.variableInstances.get(variableName);
            if (variableInstance != null) {
                return variableInstance;
            }
            VariableScopeImpl parentScope = this.getParentVariableScope();
            if (parentScope != null) {
                return parentScope.getVariableInstance(variableName, true);
            }
        } else {
            if (this.variableInstances != null && this.variableInstances.containsKey(variableName)) {
                return this.variableInstances.get(variableName);
            }
            VariableInstanceEntity variable = this.getSpecificVariable(variableName);
            if (variable != null) {
                this.usedVariablesCache.put(variableName, variable);
                return variable;
            }
            VariableScopeImpl parentScope = this.getParentVariableScope();
            if (parentScope != null) {
                return parentScope.getVariableInstance(variableName, false);
            }
        }
        return null;
    }

    protected abstract VariableInstanceEntity getSpecificVariable(String var1);

    public Object getVariableLocal(String variableName) {
        return this.getVariableLocal(variableName, true);
    }

    public VariableInstance getVariableInstanceLocal(String variableName) {
        return this.getVariableInstanceLocal(variableName, true);
    }

    public Object getVariableLocal(String variableName, boolean fetchAllVariables) {
        Object value = null;
        VariableInstance variable = this.getVariableInstanceLocal(variableName, fetchAllVariables);
        if (variable != null) {
            value = variable.getValue();
        }
        return value;
    }

    public VariableInstance getVariableInstanceLocal(String variableName, boolean fetchAllVariables) {
        if (this.transientVariables != null && this.transientVariables.containsKey(variableName)) {
            return this.transientVariables.get(variableName);
        }
        if (this.usedVariablesCache.containsKey(variableName)) {
            return this.usedVariablesCache.get(variableName);
        }
        if (fetchAllVariables) {
            this.ensureVariableInstancesInitialized();
            VariableInstanceEntity variableInstance = this.variableInstances.get(variableName);
            if (variableInstance != null) {
                return variableInstance;
            }
        } else {
            VariableInstanceEntity variable;
            if (this.variableInstances != null && this.variableInstances.containsKey(variableName) && (variable = this.variableInstances.get(variableName)) != null) {
                return this.variableInstances.get(variableName);
            }
            variable = this.getSpecificVariable(variableName);
            if (variable != null) {
                this.usedVariablesCache.put(variableName, variable);
                return variable;
            }
        }
        return null;
    }

    public boolean hasVariables() {
        if (this.transientVariables != null && !this.transientVariables.isEmpty()) {
            return true;
        }
        this.ensureVariableInstancesInitialized();
        if (!this.variableInstances.isEmpty()) {
            return true;
        }
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.hasVariables();
        }
        return false;
    }

    public boolean hasVariablesLocal() {
        if (this.transientVariables != null && !this.transientVariables.isEmpty()) {
            return true;
        }
        this.ensureVariableInstancesInitialized();
        return !this.variableInstances.isEmpty();
    }

    public boolean hasVariable(String variableName) {
        if (this.hasVariableLocal(variableName)) {
            return true;
        }
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.hasVariable(variableName);
        }
        return false;
    }

    public boolean hasVariableLocal(String variableName) {
        if (this.transientVariables != null && this.transientVariables.containsKey(variableName)) {
            return true;
        }
        this.ensureVariableInstancesInitialized();
        return this.variableInstances.containsKey(variableName);
    }

    protected Set<String> collectVariableNames(Set<String> variableNames) {
        if (this.transientVariables != null) {
            variableNames.addAll(this.transientVariables.keySet());
        }
        this.ensureVariableInstancesInitialized();
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variableNames.addAll(parentScope.collectVariableNames(variableNames));
        }
        for (VariableInstanceEntity variableInstance : this.variableInstances.values()) {
            variableNames.add(variableInstance.getName());
        }
        return variableNames;
    }

    public Set<String> getVariableNames() {
        return this.collectVariableNames(new HashSet<String>());
    }

    public Map<String, Object> getVariablesLocal() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        this.ensureVariableInstancesInitialized();
        for (VariableInstanceEntity variableInstance : this.variableInstances.values()) {
            variables.put(variableInstance.getName(), variableInstance.getValue());
        }
        for (String variableName : this.usedVariablesCache.keySet()) {
            variables.put(variableName, this.usedVariablesCache.get(variableName).getValue());
        }
        if (this.transientVariables != null) {
            for (String variableName : this.transientVariables.keySet()) {
                variables.put(variableName, this.transientVariables.get(variableName).getValue());
            }
        }
        return variables;
    }

    public Map<String, VariableInstance> getVariableInstancesLocal() {
        HashMap<String, VariableInstance> variables = new HashMap<String, VariableInstance>();
        this.ensureVariableInstancesInitialized();
        for (VariableInstanceEntity variableInstance : this.variableInstances.values()) {
            variables.put(variableInstance.getName(), variableInstance);
        }
        for (String variableName : this.usedVariablesCache.keySet()) {
            variables.put(variableName, this.usedVariablesCache.get(variableName));
        }
        if (this.transientVariables != null) {
            variables.putAll(this.transientVariables);
        }
        return variables;
    }

    public Map<String, Object> getVariablesLocal(Collection<String> variableNames) {
        return this.getVariablesLocal(variableNames, true);
    }

    public Map<String, VariableInstance> getVariableInstancesLocal(Collection<String> variableNames) {
        return this.getVariableInstancesLocal(variableNames, true);
    }

    public Map<String, Object> getVariablesLocal(Collection<String> variableNames, boolean fetchAllVariables) {
        HashMap<String, Object> requestedVariables = new HashMap<String, Object>();
        HashSet<String> variableNamesToFetch = new HashSet<String>(variableNames);
        for (String variableName : variableNames) {
            if (this.transientVariables != null && this.transientVariables.containsKey(variableName)) {
                requestedVariables.put(variableName, this.transientVariables.get(variableName).getValue());
                variableNamesToFetch.remove(variableName);
                continue;
            }
            if (!this.usedVariablesCache.containsKey(variableName)) continue;
            requestedVariables.put(variableName, this.usedVariablesCache.get(variableName).getValue());
            variableNamesToFetch.remove(variableName);
        }
        if (fetchAllVariables) {
            Map<String, Object> allVariables = this.getVariablesLocal();
            for (String variableName : variableNamesToFetch) {
                requestedVariables.put(variableName, allVariables.get(variableName));
            }
        } else {
            List<VariableInstanceEntity> variables = this.getSpecificVariables(variableNamesToFetch);
            for (VariableInstanceEntity variable : variables) {
                requestedVariables.put(variable.getName(), variable.getValue());
            }
        }
        return requestedVariables;
    }

    public Map<String, VariableInstance> getVariableInstancesLocal(Collection<String> variableNames, boolean fetchAllVariables) {
        HashMap<String, VariableInstance> requestedVariables = new HashMap<String, VariableInstance>();
        HashSet<String> variableNamesToFetch = new HashSet<String>(variableNames);
        for (String variableName : variableNames) {
            if (this.transientVariables != null && this.transientVariables.containsKey(variableName)) {
                requestedVariables.put(variableName, this.transientVariables.get(variableName));
                variableNamesToFetch.remove(variableName);
                continue;
            }
            if (!this.usedVariablesCache.containsKey(variableName)) continue;
            requestedVariables.put(variableName, this.usedVariablesCache.get(variableName));
            variableNamesToFetch.remove(variableName);
        }
        if (fetchAllVariables) {
            Map<String, VariableInstance> allVariables = this.getVariableInstancesLocal();
            for (String variableName : variableNamesToFetch) {
                requestedVariables.put(variableName, allVariables.get(variableName));
            }
        } else {
            List<VariableInstanceEntity> variables = this.getSpecificVariables(variableNamesToFetch);
            for (VariableInstanceEntity variable : variables) {
                requestedVariables.put(variable.getName(), variable);
            }
        }
        return requestedVariables;
    }

    protected abstract List<VariableInstanceEntity> getSpecificVariables(Collection<String> var1);

    public Set<String> getVariableNamesLocal() {
        HashSet<String> variableNames = new HashSet<String>();
        if (this.transientVariables != null) {
            variableNames.addAll(this.transientVariables.keySet());
        }
        this.ensureVariableInstancesInitialized();
        variableNames.addAll(this.variableInstances.keySet());
        return variableNames;
    }

    public Map<String, VariableInstanceEntity> getVariableInstanceEntities() {
        this.ensureVariableInstancesInitialized();
        return Collections.unmodifiableMap(this.variableInstances);
    }

    public Map<String, VariableInstanceEntity> getUsedVariablesCache() {
        return this.usedVariablesCache;
    }

    public void createVariablesLocal(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (Map.Entry<String, ? extends Object> entry : variables.entrySet()) {
                this.createVariableLocal(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setVariables(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                this.setVariable(variableName, variables.get(variableName));
            }
        }
    }

    public void setVariablesLocal(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                this.setVariableLocal(variableName, variables.get(variableName));
            }
        }
    }

    public void removeVariables() {
        this.ensureVariableInstancesInitialized();
        HashSet<String> variableNames = new HashSet<String>(this.variableInstances.keySet());
        for (String variableName : variableNames) {
            this.removeVariable(variableName);
        }
    }

    public void removeVariablesLocal() {
        ArrayList<String> variableNames = new ArrayList<String>(this.getVariableNamesLocal());
        for (String variableName : variableNames) {
            this.removeVariableLocal(variableName);
        }
    }

    public void removeVariables(Collection<String> variableNames) {
        if (variableNames != null) {
            for (String variableName : variableNames) {
                this.removeVariable(variableName);
            }
        }
    }

    public void removeVariablesLocal(Collection<String> variableNames) {
        if (variableNames != null) {
            for (String variableName : variableNames) {
                this.removeVariableLocal(variableName);
            }
        }
    }

    public void setVariable(String variableName, Object value) {
        if (this.isExpression(variableName)) {
            this.getVariableServiceConfiguration().getExpressionManager().createExpression(variableName).setValue(value, (VariableContainer)this);
        } else {
            this.setVariable(variableName, value, true);
        }
    }

    public void setVariable(String variableName, Object value, boolean fetchAllVariables) {
        if (fetchAllVariables) {
            if (this.usedVariablesCache.containsKey(variableName)) {
                this.updateVariableInstance(this.usedVariablesCache.get(variableName), value);
            }
            if (this.storeVariableLocal(variableName)) {
                this.setVariableLocal(variableName, value, true);
                return;
            }
            VariableScopeImpl parentVariableScope = this.getParentVariableScope();
            if (parentVariableScope != null) {
                parentVariableScope.setVariable(variableName, value);
                return;
            }
            this.createVariableLocal(variableName, value);
        } else if (this.usedVariablesCache.containsKey(variableName)) {
            this.updateVariableInstance(this.usedVariablesCache.get(variableName), value);
        } else if (this.variableInstances != null && this.variableInstances.containsKey(variableName)) {
            this.updateVariableInstance(this.variableInstances.get(variableName), value);
        } else {
            VariableInstanceEntity variable = this.getSpecificVariable(variableName);
            if (variable != null) {
                this.updateVariableInstance(variable, value);
            } else {
                VariableScopeImpl parent = this.getParentVariableScope();
                if (parent != null) {
                    parent.setVariable(variableName, value, fetchAllVariables);
                    return;
                }
                variable = this.createVariableInstance(variableName, value);
            }
            this.usedVariablesCache.put(variableName, variable);
        }
    }

    public Object setVariableLocal(String variableName, Object value) {
        return this.setVariableLocal(variableName, value, true);
    }

    public Object setVariableLocal(String variableName, Object value, boolean fetchAllVariables) {
        if (fetchAllVariables) {
            if (this.usedVariablesCache.containsKey(variableName)) {
                this.updateVariableInstance(this.usedVariablesCache.get(variableName), value);
            }
            this.ensureVariableInstancesInitialized();
            VariableInstanceEntity variableInstance = this.variableInstances.get(variableName);
            if (variableInstance == null) {
                variableInstance = this.usedVariablesCache.get(variableName);
            }
            if (variableInstance == null) {
                this.createVariableLocal(variableName, value);
            } else {
                this.updateVariableInstance(variableInstance, value);
            }
        } else if (this.usedVariablesCache.containsKey(variableName)) {
            this.updateVariableInstance(this.usedVariablesCache.get(variableName), value);
        } else if (this.variableInstances != null && this.variableInstances.containsKey(variableName)) {
            this.updateVariableInstance(this.variableInstances.get(variableName), value);
        } else {
            VariableInstanceEntity variable = this.getSpecificVariable(variableName);
            if (variable != null) {
                this.updateVariableInstance(variable, value);
            } else {
                variable = this.createVariableInstance(variableName, value);
            }
            this.usedVariablesCache.put(variableName, variable);
        }
        return null;
    }

    protected void createVariableLocal(String variableName, Object value) {
        this.ensureVariableInstancesInitialized();
        if (this.variableInstances.containsKey(variableName)) {
            throw new FlowableException("variable '" + variableName + "' already exists. Use setVariableLocal if you want to overwrite the value for " + String.valueOf(this));
        }
        this.createVariableInstance(variableName, value);
    }

    public void removeVariable(String variableName) {
        this.ensureVariableInstancesInitialized();
        if (this.variableInstances.containsKey(variableName)) {
            this.removeVariableLocal(variableName);
            return;
        }
        VariableScopeImpl parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            parentVariableScope.removeVariable(variableName);
        }
    }

    public void removeVariableLocal(String variableName) {
        this.ensureVariableInstancesInitialized();
        VariableInstanceEntity variableInstance = this.variableInstances.remove(variableName);
        if (variableInstance != null) {
            this.deleteVariableInstanceForExplicitUserCall(variableInstance);
        }
    }

    protected void deleteVariableInstanceForExplicitUserCall(VariableInstanceEntity variableInstance) {
        VariableServiceConfiguration variableServiceConfiguration = this.getVariableServiceConfiguration();
        variableServiceConfiguration.getVariableInstanceEntityManager().delete(variableInstance);
        if (variableServiceConfiguration.isLoggingSessionEnabled()) {
            ObjectNode loggingNode = VariableLoggingSessionUtil.addLoggingData("Variable '" + variableInstance.getName() + "' deleted", variableInstance, variableServiceConfiguration.getObjectMapper());
            this.addLoggingSessionInfo(loggingNode);
            LoggingSessionUtil.addLoggingData((String)"variableDelete", (ObjectNode)loggingNode, (String)variableServiceConfiguration.getEngineName());
        }
        variableInstance.setValue(null);
        this.initializeVariableInstanceBackPointer(variableInstance);
        if (this.isPropagateToHistoricVariable() && variableServiceConfiguration.getInternalHistoryVariableManager() != null) {
            variableServiceConfiguration.getInternalHistoryVariableManager().recordVariableRemoved(variableInstance, variableServiceConfiguration.getClock().getCurrentTime());
        }
    }

    protected void updateVariableInstance(VariableInstanceEntity variableInstance, Object newVariableValue) {
        Object oldVariableValue = variableInstance.getValue();
        String oldVariableType = variableInstance.getTypeName();
        this.initializeVariableInstanceBackPointer(variableInstance);
        VariableServiceConfiguration variableServiceConfiguration = this.getVariableServiceConfiguration();
        variableServiceConfiguration.getVariableInstanceValueModifier().updateVariableValue(variableInstance, newVariableValue, this.getTenantId());
        if (this.isPropagateToHistoricVariable() && variableServiceConfiguration.getInternalHistoryVariableManager() != null) {
            variableServiceConfiguration.getInternalHistoryVariableManager().recordVariableUpdate(variableInstance, variableServiceConfiguration.getClock().getCurrentTime());
        }
        if (variableServiceConfiguration.isEventDispatcherEnabled()) {
            variableServiceConfiguration.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableVariableEventBuilder.createVariableEvent(FlowableEngineEventType.VARIABLE_UPDATED, variableInstance, variableInstance.getValue(), variableInstance.getType()), variableServiceConfiguration.getEngineName());
        }
        if (variableServiceConfiguration.isLoggingSessionEnabled()) {
            ObjectNode loggingNode = VariableLoggingSessionUtil.addLoggingData("Variable '" + variableInstance.getName() + "' updated", variableInstance, variableServiceConfiguration.getObjectMapper());
            this.addLoggingSessionInfo(loggingNode);
            loggingNode.put("oldVariableType", oldVariableType);
            VariableLoggingSessionUtil.addVariableValue(oldVariableValue, oldVariableType, "oldVariableRawValue", "oldVariableValue", loggingNode);
            LoggingSessionUtil.addLoggingData((String)"variableUpdate", (ObjectNode)loggingNode, (String)variableServiceConfiguration.getEngineName());
        }
    }

    protected VariableInstanceEntity createVariableInstance(String variableName, Object value) {
        VariableServiceConfiguration variableServiceConfiguration = this.getVariableServiceConfiguration();
        VariableInstanceEntityManager variableInstanceEntityManager = variableServiceConfiguration.getVariableInstanceEntityManager();
        VariableInstanceEntity variableInstance = (VariableInstanceEntity)variableInstanceEntityManager.create();
        variableInstance.setName(variableName);
        this.initializeVariableInstanceBackPointer(variableInstance);
        variableInstanceEntityManager.insertWithValue(variableInstance, value, this.getTenantId());
        if (this.variableInstances != null) {
            this.variableInstances.put(variableName, variableInstance);
        }
        if (this.isPropagateToHistoricVariable() && variableServiceConfiguration.getInternalHistoryVariableManager() != null) {
            variableServiceConfiguration.getInternalHistoryVariableManager().recordVariableCreate(variableInstance, variableServiceConfiguration.getClock().getCurrentTime());
        }
        if (variableServiceConfiguration.isEventDispatcherEnabled()) {
            variableServiceConfiguration.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableVariableEventBuilder.createVariableEvent(FlowableEngineEventType.VARIABLE_CREATED, variableInstance, variableInstance.getValue(), variableInstance.getType()), variableServiceConfiguration.getEngineName());
        }
        if (variableServiceConfiguration.isLoggingSessionEnabled()) {
            ObjectNode loggingNode = VariableLoggingSessionUtil.addLoggingData("Variable '" + variableInstance.getName() + "' created", variableInstance, variableServiceConfiguration.getObjectMapper());
            this.addLoggingSessionInfo(loggingNode);
            LoggingSessionUtil.addLoggingData((String)"variableCreate", (ObjectNode)loggingNode, (String)variableServiceConfiguration.getEngineName());
        }
        return variableInstance;
    }

    protected boolean storeVariableLocal(String variableName) {
        return this.hasVariableLocal(variableName);
    }

    public void setTransientVariablesLocal(Map<String, Object> transientVariables) {
        for (String variableName : transientVariables.keySet()) {
            this.setTransientVariableLocal(variableName, transientVariables.get(variableName));
        }
    }

    public void setTransientVariableLocal(String variableName, Object variableValue) {
        if (this.transientVariables == null) {
            this.transientVariables = new HashMap<String, VariableInstance>();
        }
        VariableInstanceValueModifier variableValueModifier = this.getVariableServiceConfiguration().getVariableInstanceValueModifier();
        TransientVariableInstance transientVariableInstance = new TransientVariableInstance(variableName, null);
        this.initializeVariableInstanceBackPointer(transientVariableInstance);
        variableValueModifier.setVariableValue(transientVariableInstance, variableValue, this.getTenantId());
        this.transientVariables.put(variableName, transientVariableInstance);
    }

    public void setTransientVariables(Map<String, Object> transientVariables) {
        for (String variableName : transientVariables.keySet()) {
            this.setTransientVariable(variableName, transientVariables.get(variableName));
        }
    }

    public void setTransientVariable(String variableName, Object variableValue) {
        VariableScopeImpl parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            parentVariableScope.setTransientVariable(variableName, variableValue);
            return;
        }
        this.setTransientVariableLocal(variableName, variableValue);
    }

    public Object getTransientVariableLocal(String variableName) {
        if (this.transientVariables != null && this.transientVariables.containsKey(variableName)) {
            return this.transientVariables.get(variableName).getValue();
        }
        return null;
    }

    public Map<String, Object> getTransientVariablesLocal() {
        if (this.transientVariables != null) {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            for (String variableName : this.transientVariables.keySet()) {
                variables.put(variableName, this.transientVariables.get(variableName).getValue());
            }
            return variables;
        }
        return Collections.emptyMap();
    }

    public Object getTransientVariable(String variableName) {
        if (this.transientVariables != null && this.transientVariables.containsKey(variableName)) {
            return this.transientVariables.get(variableName).getValue();
        }
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.getTransientVariable(variableName);
        }
        return null;
    }

    public Map<String, Object> getTransientVariables() {
        return this.collectTransientVariables(new HashMap<String, Object>());
    }

    protected Map<String, Object> collectTransientVariables(HashMap<String, Object> variables) {
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variables.putAll(parentScope.collectTransientVariables(variables));
        }
        if (this.transientVariables != null) {
            for (String variableName : this.transientVariables.keySet()) {
                variables.put(variableName, this.transientVariables.get(variableName).getValue());
            }
        }
        return variables;
    }

    public void removeTransientVariableLocal(String variableName) {
        if (this.transientVariables != null) {
            this.transientVariables.remove(variableName);
        }
    }

    public void removeTransientVariablesLocal() {
        if (this.transientVariables != null) {
            this.transientVariables.clear();
        }
    }

    public void removeTransientVariable(String variableName) {
        if (this.transientVariables != null && this.transientVariables.containsKey(variableName)) {
            this.removeTransientVariableLocal(variableName);
            return;
        }
        VariableScopeImpl parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            parentVariableScope.removeTransientVariable(variableName);
        }
    }

    public void removeTransientVariables() {
        this.removeTransientVariablesLocal();
        VariableScopeImpl parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            parentVariableScope.removeTransientVariablesLocal();
        }
    }

    protected abstract boolean isPropagateToHistoricVariable();

    protected abstract VariableServiceConfiguration getVariableServiceConfiguration();

    public ELContext getCachedElContext() {
        return this.cachedElContext;
    }

    public void setCachedElContext(ELContext cachedElContext) {
        this.cachedElContext = cachedElContext;
    }

    public <T> T getVariable(String variableName, Class<T> variableClass) {
        return variableClass.cast(this.getVariable(variableName));
    }

    public <T> T getVariableLocal(String variableName, Class<T> variableClass) {
        return variableClass.cast(this.getVariableLocal(variableName));
    }

    protected boolean isExpression(String variableName) {
        return variableName.startsWith("${") || variableName.startsWith("#{");
    }
}

