/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.converters;

import org.springframework.binding.convert.converters.TwoWayConverter;

public abstract class StringToObject
implements TwoWayConverter {
    private Class<?> objectClass;

    public StringToObject(Class<?> objectClass) {
        this.objectClass = objectClass;
    }

    @Override
    public final Class<?> getSourceClass() {
        return String.class;
    }

    @Override
    public final Class<?> getTargetClass() {
        return this.objectClass;
    }

    @Override
    public final Object convertSourceToTargetClass(Object source, Class<?> targetClass) throws Exception {
        String string = (String)source;
        if (string != null && string.length() > 0) {
            return this.toObject(string, targetClass);
        }
        return null;
    }

    @Override
    public final Object convertTargetToSourceClass(Object target, Class<?> sourceClass) throws Exception {
        if (target != null) {
            return this.toString(target);
        }
        return "";
    }

    protected abstract Object toObject(String var1, Class<?> var2) throws Exception;

    protected abstract String toString(Object var1) throws Exception;
}

