/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.dao;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.jexl3.parser.Parser;
import org.apache.commons.jexl3.parser.Token;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class AnyFinder {
    protected static final Logger LOG = LoggerFactory.getLogger(AnyFinder.class);
    protected static final Comparator<String> LITERAL_COMPARATOR = (l1, l2) -> {
        if (l1 == null && l2 == null) {
            return 0;
        }
        if (l1 != null && l2 == null) {
            return -1;
        }
        if (l1 == null) {
            return 1;
        }
        if (l1.length() == l2.length()) {
            return 0;
        }
        if (l1.length() > l2.length()) {
            return -1;
        }
        return 1;
    };
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final AnySearchDAO anySearchDAO;

    protected static List<String> split(String attrValue, List<String> literals) {
        ArrayList<String> attrValues = new ArrayList<String>();
        if (literals.isEmpty()) {
            attrValues.add(attrValue);
        } else {
            for (String token : attrValue.split(Pattern.quote(literals.getFirst()))) {
                if (token.isEmpty()) continue;
                attrValues.addAll(AnyFinder.split(token, literals.subList(1, literals.size())));
            }
        }
        return attrValues;
    }

    public AnyFinder(PlainSchemaDAO plainSchemaDAO, AnySearchDAO anySearchDAO) {
        this.plainSchemaDAO = plainSchemaDAO;
        this.anySearchDAO = anySearchDAO;
    }

    @Transactional(readOnly=true)
    public <A extends Any> List<A> findByDerAttrValue(AnyTypeKind anyTypeKind, String expression, String value, boolean ignoreCaseMatch) {
        Parser parser = new Parser(expression);
        ArrayList<String> identifiers = new ArrayList<String>();
        ArrayList<String> literals = new ArrayList<String>();
        Token token = parser.getNextToken();
        while (token != null && StringUtils.isNotBlank((CharSequence)token.toString())) {
            if (token.kind == 124) {
                literals.add(token.toString().substring(1, token.toString().length() - 1));
            }
            if (token.kind == 110) {
                identifiers.add(token.toString());
            }
            token = parser.getNextToken();
        }
        literals.sort(LITERAL_COMPARATOR);
        List<String> attrValues = AnyFinder.split(value, literals);
        if (attrValues.size() != identifiers.size()) {
            LOG.error("Ambiguous JEXL expression resolution: literals and values have different size");
            return List.of();
        }
        ArrayList<SearchCond> andConditions = new ArrayList<SearchCond>();
        HashSet<String> used = new HashSet<String>();
        for (int i = 0; i < identifiers.size() && !used.contains(identifiers.get(i)); ++i) {
            used.add((String)identifiers.get(i));
            AttrCond cond = this.plainSchemaDAO.findById((String)identifiers.get(i)).map(schema -> new AttrCond()).orElseGet(() -> new AnyCond());
            cond.setType(ignoreCaseMatch ? AttrCond.Type.IEQ : AttrCond.Type.EQ);
            cond.setSchema((String)identifiers.get(i));
            cond.setExpression(attrValues.get(i));
            andConditions.add(SearchCond.of((AbstractSearchCond)cond));
        }
        LOG.debug("Generated search {} conditions: {}", (Object)anyTypeKind, andConditions);
        return this.anySearchDAO.search(SearchCond.and(andConditions), anyTypeKind);
    }
}

