/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.persondir;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.handler.LdapEntryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveDirectoryLdapEntryHandler
implements LdapEntryHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveDirectoryLdapEntryHandler.class);
    public static final int ACCOUNT_DISABLED = 2;
    public static final int LOCKOUT = 16;
    public static final int PASSWORD_EXPIRED = 0x800000;
    private static final int AD_STARTING_YEAR = 1601;
    private static final int DATE_TO_MILLISECONDS = 10000;

    private static String decodeLogonBits(byte b) {
        StringBuilder sb = new StringBuilder();
        sb.append((b & 1) > 0 ? "1" : "0");
        sb.append((b & 2) > 0 ? "1" : "0");
        sb.append((b & 4) > 0 ? "1" : "0");
        sb.append((b & 8) > 0 ? "1" : "0");
        sb.append((b & 0x10) > 0 ? "1" : "0");
        sb.append((b & 0x20) > 0 ? "1" : "0");
        sb.append((b & 0x40) > 0 ? "1" : "0");
        sb.append((b & 0x80) > 0 ? "1" : "0");
        return sb.toString();
    }

    public LdapEntry apply(LdapEntry ldapEntry) {
        LdapAttribute accountExpires;
        LdapAttribute attr = ldapEntry.getAttribute("userAccountControl");
        if (attr != null) {
            int uac = Integer.parseInt(attr.getStringValue());
            if ((uac & 0x10) == 16) {
                LOGGER.warn("Account is disabled with UAC [{}] for entry [{}]", (Object)uac, (Object)ldapEntry);
                return null;
            }
            if ((uac & 2) == 2) {
                LOGGER.warn("Account is disabled with UAC [{}] for entry [{}]", (Object)uac, (Object)ldapEntry);
                return null;
            }
            if ((uac & 0x800000) == 0x800000) {
                LOGGER.warn("Account has expired");
                return null;
            }
        }
        if ((accountExpires = ldapEntry.getAttribute("accountExpires")) != null) {
            long adDate = Long.parseLong(accountExpires.getStringValue());
            LOGGER.debug("Current active directory account expiration date [{}]", (Object)adDate);
            if (adDate > 0L) {
                GregorianCalendar cal = new GregorianCalendar(TimeZone.getDefault());
                cal.set(1601, 0, 1, 0, 0);
                long converted = adDate / 10000L;
                Long timeStamp = converted + cal.getTime().getTime();
                Date date = new Date(timeStamp);
                LocalDateTime accountExpiresDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                LocalDateTime now = LocalDateTime.now(ZoneId.systemDefault());
                LOGGER.debug("Now: [{}], account expires at [{}]", (Object)now, (Object)accountExpiresDate);
                if (accountExpiresDate.isBefore(now)) {
                    LOGGER.warn("Account has expired with date [{}]", (Object)accountExpiresDate);
                    return null;
                }
            }
        }
        if (!this.isValidLogonHour(ldapEntry)) {
            LOGGER.warn("Logon Hours are invalid and no attributes will be used");
            return null;
        }
        return ldapEntry;
    }

    protected boolean isValidLogonHour(LdapEntry attr) {
        if (attr.getAttribute("logonHours") != null) {
            byte[] raw = attr.getAttribute("logonHours").getBinaryValue();
            DayOfWeek[] days = DayOfWeek.values();
            List<String> ret = IntStream.range(0, days.length).mapToObj(day -> {
                byte[] byArray;
                if (day == 6) {
                    byte[] byArray2 = new byte[3];
                    byArray2[0] = raw[19];
                    byArray2[1] = raw[20];
                    byArray = byArray2;
                    byArray2[2] = raw[0];
                } else {
                    byte[] byArray3 = new byte[3];
                    byArray3[0] = raw[day * 3];
                    byArray3[1] = raw[day * 3 + 1];
                    byArray = byArray3;
                    byArray3[2] = raw[day * 3 + 2];
                }
                return byArray;
            }).map(vBits -> IntStream.range(0, 3).mapToObj(b -> ActiveDirectoryLdapEntryHandler.decodeLogonBits(vBits[b])).collect(Collectors.joining())).toList();
            String[] result = new String[ret.size()];
            ret.toArray(result);
            DayOfWeek currentDay = LocalDate.now(ZoneId.systemDefault()).getDayOfWeek();
            int currentHour = LocalDateTime.now(ZoneId.systemDefault()).getHour() - 1;
            if (currentHour < 0) {
                currentHour = 0;
            }
            LOGGER.debug("Current day [{}], current hour [{}]", (Object)currentDay, (Object)currentHour);
            for (int day2 = 0; day2 < days.length; ++day2) {
                if (days[day2] != currentDay) continue;
                String validHours = result[day2];
                LOGGER.debug("Valid hours are [{}]", (Object)validHours);
                String hourEnabled = String.valueOf(validHours.charAt(currentHour));
                LOGGER.debug("Hour enabled at [{}] is [{}]", (Object)currentHour, (Object)hourEnabled);
                if ("1".equalsIgnoreCase(hourEnabled)) continue;
                LOGGER.warn("Invalid login hour");
                return false;
            }
        }
        return true;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActiveDirectoryLdapEntryHandler)) {
            return false;
        }
        ActiveDirectoryLdapEntryHandler other = (ActiveDirectoryLdapEntryHandler)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ActiveDirectoryLdapEntryHandler;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "ActiveDirectoryLdapEntryHandler()";
    }
}

