/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.github.scribejava.apis.FacebookApi;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.facebook.FacebookConfiguration;
import org.pac4j.oauth.profile.facebook.FacebookProfileCreator;
import org.pac4j.oauth.profile.facebook.FacebookProfileDefinition;

public class FacebookClient
extends OAuth20Client {
    public FacebookClient() {
        this.configuration = new FacebookConfiguration();
    }

    public FacebookClient(String key, String secret) {
        this.configuration = new FacebookConfiguration();
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotBlank((String)"fields", (String)this.getConfiguration().getFields());
        this.configuration.setApi(FacebookApi.instance());
        this.configuration.setProfileDefinition(new FacebookProfileDefinition());
        this.configuration.setHasBeenCancelledFactory(ctx -> {
            boolean hasError;
            String error = ctx.getRequestParameter("error").orElse(null);
            String errorReason = ctx.getRequestParameter("error_reason").orElse(null);
            boolean userDenied = "access_denied".equals(error) && "user_denied".equals(errorReason);
            String errorCode = ctx.getRequestParameter("error_code").orElse(null);
            String errorMessage = ctx.getRequestParameter("error_message").orElse(null);
            boolean bl = hasError = StringUtils.isNotBlank((CharSequence)errorCode) || StringUtils.isNotBlank((CharSequence)errorMessage);
            if (userDenied || hasError) {
                return true;
            }
            return false;
        });
        this.configuration.setWithState(true);
        this.setProfileCreatorIfUndefined(new FacebookProfileCreator(this.configuration, (IndirectClient)this));
        super.internalInit(forceReinit);
    }

    @Override
    public FacebookConfiguration getConfiguration() {
        return (FacebookConfiguration)this.configuration;
    }

    public String getScope() {
        return this.getConfiguration().getScope();
    }

    public void setScope(String scope) {
        this.getConfiguration().setScope(scope);
    }

    public String getFields() {
        return this.getConfiguration().getFields();
    }

    public void setFields(String fields) {
        this.getConfiguration().setFields(fields);
    }

    public int getLimit() {
        return this.getConfiguration().getLimit();
    }

    public void setLimit(int limit) {
        this.getConfiguration().setLimit(limit);
    }
}

