/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.hiorgserver;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.Token;
import java.util.HashSet;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;
import org.pac4j.oauth.profile.hiorgserver.HiOrgServerProfile;

public class HiOrgServerProfileDefinition
extends OAuthProfileDefinition {
    public static final String USER_ID = "user_id";
    public static final String USERNAME = "username";
    public static final String NAME = "name";
    public static final String FIRST_NAME = "vorname";
    public static final String FULL_NAME = "fullname";
    public static final String ROLES = "gruppe";
    public static final String LEADER = "leitung";
    public static final String POSITION = "funktion";
    public static final String ORGANISATION_ID = "orga";
    public static final String ORGANISATION_NAME = "organisation";
    public static final String ALTERNATIVE_ID = "alt_user_id";
    public static final String TYPED_ALTERNATIVE_ID = "typed_alt_user_id";
    protected static final String BASE_URL = "https://www.hiorg-server.de/api/oauth2/v1/user.php";

    public HiOrgServerProfileDefinition() {
        super(x -> new HiOrgServerProfile());
        this.primary(USERNAME, Converters.STRING);
        this.primary(NAME, Converters.STRING);
        this.primary(FIRST_NAME, Converters.STRING);
        this.primary(FULL_NAME, Converters.STRING);
        this.primary(ROLES, Converters.INTEGER);
        this.primary(LEADER, Converters.BOOLEAN);
        this.primary(POSITION, Converters.STRING);
        this.primary(ORGANISATION_ID, Converters.STRING);
        this.primary(ORGANISATION_NAME, Converters.STRING);
        this.secondary(ALTERNATIVE_ID, Converters.STRING);
        this.secondary(TYPED_ALTERNATIVE_ID, Converters.STRING);
    }

    @Override
    public String getProfileUrl(Token accessToken, OAuthConfiguration configuration) {
        return BASE_URL;
    }

    @Override
    public HiOrgServerProfile extractUserProfile(String body) {
        HiOrgServerProfile profile = (HiOrgServerProfile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            this.logger.debug("Extracting user profile from JSON node " + json);
            profile.setId(ProfileHelper.sanitizeIdentifier((Object)JsonHelper.getElement(json, USER_ID)));
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(json, attribute));
            }
            this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, ALTERNATIVE_ID, profile.getAlternativeId());
            this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, TYPED_ALTERNATIVE_ID, profile.getTypedAlternativeId());
        } else {
            this.raiseProfileExtractionJsonError(body);
        }
        this.extractRoles(profile);
        return profile;
    }

    protected void extractRoles(HiOrgServerProfile profile) {
        Integer rolesAsInt = profile.getRolesAsInteger();
        HashSet<String> roles = new HashSet<String>();
        for (int i = 0; i <= 10; ++i) {
            boolean isGroupSet;
            int groupId = (int)Math.pow(2.0, i);
            boolean bl = isGroupSet = (rolesAsInt & groupId) == groupId;
            if (!isGroupSet) continue;
            this.logger.debug("Extracted role " + groupId);
            roles.add(String.valueOf(groupId));
        }
        profile.setRoles(roles);
    }
}

