/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.postgres.embedded;

import io.zonky.test.db.postgres.embedded.DatabasePreparer;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import javax.sql.DataSource;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;

public final class LiquibasePreparer
implements DatabasePreparer {
    private final String location;
    private final ResourceAccessor accessor;
    private final Contexts contexts;

    public static LiquibasePreparer forClasspathLocation(String location) {
        return LiquibasePreparer.forClasspathLocation(location, null);
    }

    public static LiquibasePreparer forClasspathLocation(String location, Contexts contexts) {
        return new LiquibasePreparer(location, (ResourceAccessor)new ClassLoaderResourceAccessor(), contexts);
    }

    public static LiquibasePreparer forFile(File file) {
        return LiquibasePreparer.forFile(file, null);
    }

    public static LiquibasePreparer forFile(File file, Contexts contexts) {
        if (file == null) {
            throw new IllegalArgumentException("Missing file");
        }
        File dir = file.getParentFile();
        if (dir == null) {
            throw new IllegalArgumentException("Cannot get parent dir from file");
        }
        return new LiquibasePreparer(file.getName(), (ResourceAccessor)new FileSystemResourceAccessor(new File[]{dir}), contexts);
    }

    private LiquibasePreparer(String location, ResourceAccessor accessor, Contexts contexts) {
        this.location = location;
        this.accessor = accessor;
        this.contexts = contexts != null ? contexts : new Contexts();
    }

    @Override
    public void prepare(DataSource ds) throws SQLException {
        try (Connection connection = ds.getConnection();){
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
            Liquibase liquibase = new Liquibase(this.location, this.accessor, database);
            liquibase.update(this.contexts);
        }
        catch (LiquibaseException e) {
            throw new SQLException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiquibasePreparer that = (LiquibasePreparer)o;
        return Objects.equals(this.location, that.location) && Objects.equals(this.accessor, that.accessor) && Objects.equals(this.contexts.getContexts(), that.contexts.getContexts());
    }

    public int hashCode() {
        return Objects.hash(this.location, this.accessor, this.contexts.getContexts());
    }
}

