/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.SurrogateAuthenticationException;
import org.apereo.cas.authentication.metadata.BaseAuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.authentication.surrogate.SurrogateCredentialTrait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurrogateAuthenticationMetaDataPopulator
extends BaseAuthenticationMetaDataPopulator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateAuthenticationMetaDataPopulator.class);
    private final SurrogateAuthenticationService surrogateAuthenticationService;

    public void populateAttributes(AuthenticationBuilder builder, AuthenticationTransaction transaction) {
        Optional primaryCredential = transaction.getPrimaryCredential();
        primaryCredential.ifPresentOrElse(credential -> {
            String surrogateUsername = credential.getCredentialMetadata().getTrait(SurrogateCredentialTrait.class).map(SurrogateCredentialTrait::getSurrogateUsername).orElseThrow();
            this.surrogateAuthenticationService.collectSurrogateAttributes(builder, surrogateUsername, credential.getId());
        }, () -> {
            throw new SurrogateAuthenticationException("The authentication transaction does not have a primary principal");
        });
    }

    public boolean supports(Credential credential) {
        return credential.getCredentialMetadata().getTrait(SurrogateCredentialTrait.class).stream().anyMatch(trait -> StringUtils.isNotBlank((CharSequence)trait.getSurrogateUsername()));
    }

    @Generated
    public SurrogateAuthenticationMetaDataPopulator(SurrogateAuthenticationService surrogateAuthenticationService) {
        this.surrogateAuthenticationService = surrogateAuthenticationService;
    }
}

