/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aup;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.aup.AcceptableUsagePolicyRepository;
import org.apereo.cas.aup.AcceptableUsagePolicyStatus;
import org.apereo.cas.aup.AcceptableUsagePolicyTerms;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.aup.AcceptableUsagePolicyCoreProperties;
import org.apereo.cas.configuration.model.support.aup.AcceptableUsagePolicyProperties;
import org.apereo.cas.services.WebBasedRegisteredService;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.execution.RequestContext;

public abstract class BaseAcceptableUsagePolicyRepository
implements AcceptableUsagePolicyRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseAcceptableUsagePolicyRepository.class);
    private static final long serialVersionUID = 1883808902502739L;
    protected final transient TicketRegistrySupport ticketRegistrySupport;
    protected final AcceptableUsagePolicyProperties aupProperties;

    private static String getPolicyText(RequestContext requestContext) {
        WebBasedRegisteredService registeredService = (WebBasedRegisteredService)WebUtils.getRegisteredService((RequestContext)requestContext);
        if (registeredService != null && registeredService.getAcceptableUsagePolicy() != null && StringUtils.isNotBlank((CharSequence)registeredService.getAcceptableUsagePolicy().getText())) {
            return registeredService.getAcceptableUsagePolicy().getText();
        }
        return null;
    }

    @Override
    public AcceptableUsagePolicyStatus verify(RequestContext requestContext) throws Throwable {
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        if (authentication == null) {
            throw new AuthenticationException("Unable to determine authentication from the request context");
        }
        Principal principal = authentication.getPrincipal();
        if (this.isUsagePolicyAcceptedBy(principal)) {
            LOGGER.debug("Acceptable usage policy has been accepted by [{}]", (Object)principal.getId());
            return AcceptableUsagePolicyStatus.accepted(principal);
        }
        LOGGER.info("Acceptable usage policy has not been accepted by [{}]", (Object)principal.getId());
        return AcceptableUsagePolicyStatus.denied(principal);
    }

    @Override
    public Optional<AcceptableUsagePolicyTerms> fetchPolicy(RequestContext requestContext) {
        Principal principal = WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal();
        Map attributes = principal.getAttributes();
        LOGGER.debug("Principal attributes found for [{}] are [{}]", (Object)principal.getId(), (Object)attributes);
        String code = StringUtils.defaultString((String)this.getPolicyMessageBundleCode(requestContext));
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        ApplicationContext appCtx = requestContext.getActiveFlow().getApplicationContext();
        String message = appCtx.getMessage(code, null, "", request.getLocale());
        Object terms = ((AcceptableUsagePolicyTerms.AcceptableUsagePolicyTermsBuilder)((AcceptableUsagePolicyTerms.AcceptableUsagePolicyTermsBuilder)AcceptableUsagePolicyTerms.builder().code(StringUtils.isNotBlank((CharSequence)message) ? code : null)).defaultText(BaseAcceptableUsagePolicyRepository.getPolicyText(requestContext))).build();
        if (((AcceptableUsagePolicyTerms)terms).isDefined()) {
            return Optional.of(terms);
        }
        return Optional.empty();
    }

    protected String getPolicyMessageBundleCode(RequestContext requestContext) {
        WebBasedRegisteredService registeredService = (WebBasedRegisteredService)WebUtils.getRegisteredService((RequestContext)requestContext);
        if (registeredService != null && registeredService.getAcceptableUsagePolicy() != null && StringUtils.isNotBlank((CharSequence)registeredService.getAcceptableUsagePolicy().getMessageCode())) {
            return registeredService.getAcceptableUsagePolicy().getMessageCode();
        }
        if (StringUtils.isBlank((CharSequence)this.aupProperties.getCore().getAupPolicyTermsAttributeName())) {
            return null;
        }
        Principal principal = WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal();
        Map attributes = principal.getAttributes();
        if (!attributes.containsKey(this.aupProperties.getCore().getAupPolicyTermsAttributeName())) {
            LOGGER.trace("No attribute for policy terms is defined");
            return null;
        }
        Optional value = CollectionUtils.firstElement(attributes.get(this.aupProperties.getCore().getAupPolicyTermsAttributeName()));
        return value.map(v -> String.format("%s.%s", "screen.aup.policyterms", value.get())).orElse(null);
    }

    protected boolean isUsagePolicyAcceptedBy(Principal principal) {
        Map attributes = principal.getAttributes();
        LOGGER.debug("Principal attributes found for [{}] are [{}]", (Object)principal.getId(), (Object)attributes);
        return this.isUsagePolicyAcceptedBy(attributes);
    }

    protected boolean isUsagePolicyAcceptedBy(Map<String, List<Object>> attributes) {
        AcceptableUsagePolicyCoreProperties core = this.aupProperties.getCore();
        if (attributes != null && attributes.containsKey(core.getAupAttributeName())) {
            Set value = CollectionUtils.toCollection(attributes.get(core.getAupAttributeName()));
            LOGGER.debug("Evaluating attribute value [{}] found for [{}]", (Object)value, (Object)core.getAupAttributeName());
            return value.stream().anyMatch(v -> v.toString().equalsIgnoreCase(this.getAcceptedAttributeValue()));
        }
        if (core.isAupOmitIfAttributeMissing()) {
            LOGGER.trace("Value for [{}] is missing.", (Object)core.getAupAttributeName());
            return true;
        }
        return false;
    }

    protected String getAcceptedAttributeValue() {
        return Boolean.TRUE.toString();
    }

    @Generated
    protected BaseAcceptableUsagePolicyRepository(TicketRegistrySupport ticketRegistrySupport, AcceptableUsagePolicyProperties aupProperties) {
        this.ticketRegistrySupport = ticketRegistrySupport;
        this.aupProperties = aupProperties;
    }
}

