/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.time.OffsetDateTime;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyObjectCR;
import org.apache.syncope.common.lib.request.AnyObjectUR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.GroupCR;
import org.apache.syncope.common.lib.request.GroupUR;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.RemediationTO;
import org.apache.syncope.core.logic.AbstractLogic;
import org.apache.syncope.core.logic.AnyObjectLogic;
import org.apache.syncope.core.logic.GroupLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.logic.UserLogic;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RemediationDAO;
import org.apache.syncope.core.persistence.api.entity.Remediation;
import org.apache.syncope.core.persistence.api.search.SyncopePage;
import org.apache.syncope.core.provisioning.api.data.RemediationDataBinder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class RemediationLogic
extends AbstractLogic<RemediationTO> {
    protected final UserLogic userLogic;
    protected final GroupLogic groupLogic;
    protected final AnyObjectLogic anyObjectLogic;
    protected final RemediationDataBinder binder;
    protected final RemediationDAO remediationDAO;

    public RemediationLogic(UserLogic userLogic, GroupLogic groupLogic, AnyObjectLogic anyObjectLogic, RemediationDataBinder binder, RemediationDAO remediationDAO) {
        this.userLogic = userLogic;
        this.groupLogic = groupLogic;
        this.anyObjectLogic = anyObjectLogic;
        this.binder = binder;
        this.remediationDAO = remediationDAO;
    }

    @PreAuthorize(value="hasRole('REMEDIATION_LIST')")
    @Transactional(readOnly=true)
    public Page<RemediationTO> list(OffsetDateTime before, OffsetDateTime after, Pageable pageable) {
        long count = this.remediationDAO.count(before, after);
        List<RemediationTO> result = this.remediationDAO.findAll(before, after, pageable).stream().map(arg_0 -> ((RemediationDataBinder)this.binder).getRemediationTO(arg_0)).toList();
        return new SyncopePage(result, pageable, count);
    }

    @PreAuthorize(value="hasRole('REMEDIATION_READ')")
    @Transactional(readOnly=true)
    public RemediationTO read(String key) {
        Remediation remediation = (Remediation)this.remediationDAO.findById(key).orElseThrow(() -> new NotFoundException("Remediation " + key));
        return this.binder.getRemediationTO(remediation);
    }

    @PreAuthorize(value="hasRole('REMEDIATION_DELETE')")
    @Transactional
    public void delete(String key) {
        this.remediationDAO.findById(key).orElseThrow(() -> new NotFoundException("Remediation " + key));
        this.remediationDAO.deleteById(key);
    }

    @PreAuthorize(value="hasRole('REMEDIATION_REMEDY')")
    public ProvisioningResult<?> remedy(String key, AnyCR anyCR, boolean nullPriorityAsync) {
        ProvisioningResult result = switch (this.read(key).getAnyType()) {
            case "USER" -> this.userLogic.create((UserCR)anyCR, nullPriorityAsync);
            case "GROUP" -> this.groupLogic.create((GroupCR)anyCR, nullPriorityAsync);
            default -> this.anyObjectLogic.create((AnyObjectCR)anyCR, nullPriorityAsync);
        };
        this.remediationDAO.deleteById(key);
        return result;
    }

    @PreAuthorize(value="hasRole('REMEDIATION_REMEDY')")
    public ProvisioningResult<?> remedy(String key, AnyUR anyUR, boolean nullPriorityAsync) {
        ProvisioningResult result = switch (this.read(key).getAnyType()) {
            case "USER" -> this.userLogic.update((UserUR)anyUR, nullPriorityAsync);
            case "GROUP" -> this.groupLogic.update((GroupUR)anyUR, nullPriorityAsync);
            default -> this.anyObjectLogic.update((AnyObjectUR)anyUR, nullPriorityAsync);
        };
        this.remediationDAO.deleteById(key);
        return result;
    }

    @PreAuthorize(value="hasRole('REMEDIATION_REMEDY')")
    public ProvisioningResult<?> remedy(String key, String anyKey, boolean nullPriorityAsync) {
        ProvisioningResult result = switch (this.read(key).getAnyType()) {
            case "USER" -> this.userLogic.delete(anyKey, nullPriorityAsync);
            case "GROUP" -> this.groupLogic.delete(anyKey, nullPriorityAsync);
            default -> this.anyObjectLogic.delete(anyKey, nullPriorityAsync);
        };
        this.remediationDAO.deleteById(key);
        return result;
    }

    protected RemediationTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    key = string = (String)object;
                    continue;
                }
                object = args[i];
                if (!(object instanceof RemediationTO)) continue;
                RemediationTO remediationTO = (RemediationTO)object;
                key = remediationTO.getKey();
            }
        }
        if (StringUtils.isNotBlank(key)) {
            try {
                return this.binder.getRemediationTO((Remediation)this.remediationDAO.findById(key).orElseThrow());
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

