/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.config;

import com.okta.commons.lang.Assert;
import com.okta.commons.lang.Classes;
import com.okta.commons.lang.Strings;
import com.okta.sdk.impl.config.PropertiesSource;
import com.okta.sdk.impl.io.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class YAMLPropertiesSource
implements PropertiesSource {
    private static final Logger log = LoggerFactory.getLogger(YAMLPropertiesSource.class);
    private final Resource resource;

    public YAMLPropertiesSource(Resource resource) {
        Assert.notNull((Object)resource, (String)"resource argument cannot be null.");
        this.resource = resource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, String> getProperties() {
        try (InputStream in = this.resource.getInputStream();){
            if (in == null) return new LinkedHashMap<String, String>();
            if (Classes.isAvailable((String)"org.yaml.snakeyaml.Yaml")) {
                Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
                Map config = (Map)yaml.load(in);
                Map<String, String> map = this.getFlattenedMap(config);
                return map;
            }
            log.warn("YAML not found in classpath, add 'org.yaml.snakeyaml' to support YAML configuration");
            return new LinkedHashMap<String, String>();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read resource [" + this.resource + "]: " + e.getMessage(), e);
        }
    }

    private Map<String, String> getFlattenedMap(Map<String, Object> source) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        this.buildFlattenedMap(result, source, null);
        return result;
    }

    private void buildFlattenedMap(Map<String, String> result, Map<String, Object> source, String path) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (Strings.hasText((String)path)) {
                key = key.startsWith("[") ? path + key : path + "." + key;
            }
            if ((value = entry.getValue()) instanceof String) {
                result.put(key, String.valueOf(value));
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                this.buildFlattenedMap(result, map, key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                result.put(key, Strings.collectionToCommaDelimitedString((Collection)collection));
                continue;
            }
            result.put(key, value != null ? String.valueOf(value) : "");
        }
    }
}

