/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.atlas;

import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Timer;
import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;

public class SpectatorTimer
extends AbstractTimer {
    private final Timer timer;

    public SpectatorTimer(Meter.Id id, Timer timer, Clock clock, DistributionStatisticConfig statsConf, PauseDetector pauseDetector, TimeUnit baseTimeUnit) {
        super(id, clock, statsConf, pauseDetector, baseTimeUnit, false);
        this.timer = timer;
    }

    protected void recordNonNegative(long amount, TimeUnit unit) {
        this.timer.record(unit.toNanos(amount), TimeUnit.NANOSECONDS);
    }

    public long count() {
        return this.timer.count();
    }

    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit((double)this.timer.totalTime(), (TimeUnit)unit);
    }

    public double max(TimeUnit unit) {
        for (Measurement measurement : this.timer.measure()) {
            if (!StreamSupport.stream(measurement.id().tags().spliterator(), false).anyMatch(tag -> tag.key().equals("statistic") && tag.value().equals(Statistic.max.toString()))) continue;
            return TimeUtils.secondsToUnit((double)measurement.value(), (TimeUnit)unit);
        }
        return Double.NaN;
    }
}

