/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.proxy;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apereo.cas.client.proxy.ProxyGrantingTicketStorage;
import org.apereo.cas.client.util.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProxyGrantingTicketStorageImpl
implements ProxyGrantingTicketStorage {
    private static final long DEFAULT_TIMEOUT = 60000L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<String, ProxyGrantingTicketHolder> cache = new ConcurrentHashMap<String, ProxyGrantingTicketHolder>();
    private final long timeout;

    public ProxyGrantingTicketStorageImpl() {
        this(60000L);
    }

    public ProxyGrantingTicketStorageImpl(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void save(String proxyGrantingTicketIou, String proxyGrantingTicket) {
        ProxyGrantingTicketHolder holder = new ProxyGrantingTicketHolder(proxyGrantingTicket);
        this.logger.debug("Saving ProxyGrantingTicketIOU and ProxyGrantingTicket combo: [{}, {}]", (Object)proxyGrantingTicketIou, (Object)proxyGrantingTicket);
        this.cache.put(proxyGrantingTicketIou, holder);
    }

    @Override
    public String retrieve(String proxyGrantingTicketIou) {
        if (CommonUtils.isBlank(proxyGrantingTicketIou)) {
            return null;
        }
        ProxyGrantingTicketHolder holder = (ProxyGrantingTicketHolder)this.cache.get(proxyGrantingTicketIou);
        if (holder == null) {
            this.logger.info("No Proxy Ticket found for [{}].", (Object)proxyGrantingTicketIou);
            return null;
        }
        this.cache.remove(proxyGrantingTicketIou);
        this.logger.debug("Returned ProxyGrantingTicket of [{}]", (Object)holder.getProxyGrantingTicket());
        return holder.getProxyGrantingTicket();
    }

    @Override
    public void cleanUp() {
        for (Map.Entry holder : this.cache.entrySet()) {
            if (!((ProxyGrantingTicketHolder)holder.getValue()).isExpired(this.timeout)) continue;
            this.cache.remove(holder.getKey());
        }
    }

    private static final class ProxyGrantingTicketHolder {
        private final String proxyGrantingTicket;
        private final long timeInserted;

        private ProxyGrantingTicketHolder(String proxyGrantingTicket) {
            this.proxyGrantingTicket = proxyGrantingTicket;
            this.timeInserted = System.currentTimeMillis();
        }

        public String getProxyGrantingTicket() {
            return this.proxyGrantingTicket;
        }

        final boolean isExpired(long timeout) {
            return System.currentTimeMillis() - this.timeInserted > timeout;
        }
    }
}

