/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.configuration;

import java.util.Locale;
import java.util.Map;
import org.springframework.core.io.Resource;

public class TlsProperties {
    private static final String DEFAULT_STORE_TYPE = "PKCS12";
    private static final Map<String, String> EXTENSION_STORE_TYPES = TlsProperties.extTypes();
    private boolean enabled;
    private Resource keyStore;
    private String keyStoreType;
    private String keyStorePassword = "";
    private String keyPassword = "";
    private Resource trustStore;
    private String trustStoreType;
    private String trustStorePassword = "";

    private static Map<String, String> extTypes() {
        return Map.of("p12", DEFAULT_STORE_TYPE, "pfx", DEFAULT_STORE_TYPE, "jks", "JKS");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Resource getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(Resource keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStoreType() {
        if (this.keyStore != null && this.keyStoreType == null) {
            this.keyStoreType = this.storeTypeOf(this.keyStore);
        }
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public char[] keyStorePassword() {
        return this.keyStorePassword.toCharArray();
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public char[] keyPassword() {
        return this.keyPassword.toCharArray();
    }

    public Resource getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(Resource trustStore) {
        this.trustStore = trustStore;
    }

    public String getTrustStoreType() {
        if (this.trustStore != null && this.trustStoreType == null) {
            this.trustStoreType = this.storeTypeOf(this.trustStore);
        }
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public char[] trustStorePassword() {
        return this.trustStorePassword.toCharArray();
    }

    private String storeTypeOf(Resource resource) {
        String extension = this.fileExtensionOf(resource);
        String type = EXTENSION_STORE_TYPES.get(extension);
        return type == null ? DEFAULT_STORE_TYPE : type;
    }

    private String fileExtensionOf(Resource resource) {
        String name = resource.getFilename();
        int index = name.lastIndexOf(46);
        return index < 0 ? "" : name.substring(index + 1).toLowerCase(Locale.ROOT);
    }
}

