/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication.ott;

import java.time.Instant;
import org.springframework.security.authentication.ott.OneTimeToken;
import org.springframework.util.Assert;

public class DefaultOneTimeToken
implements OneTimeToken {
    private final String token;
    private final String username;
    private final Instant expireAt;

    public DefaultOneTimeToken(String token, String username, Instant expireAt) {
        Assert.hasText((String)token, (String)"token cannot be empty");
        Assert.hasText((String)username, (String)"username cannot be empty");
        Assert.notNull((Object)expireAt, (String)"expireAt cannot be null");
        this.token = token;
        this.username = username;
        this.expireAt = expireAt;
    }

    @Override
    public String getTokenValue() {
        return this.token;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public Instant getExpiresAt() {
        return this.expireAt;
    }
}

