/*
 * Decompiled with CFR 0.152.
 */
package kafka.log.remote;

import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import kafka.log.remote.RemoteLogManager;
import kafka.log.remote.RemoteLogReader;
import kafka.log.remote.quota.RLMQuotaManager;
import kafka.server.BrokerTopicStats;
import kafka.utils.TestUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.server.log.remote.storage.RemoteStorageException;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.RemoteLogReadResult;
import org.apache.kafka.storage.internals.log.RemoteStorageFetchInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RemoteLogReaderTest {
    public static final String TOPIC = "test";
    RemoteLogManager mockRLM = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
    BrokerTopicStats brokerTopicStats = null;
    RLMQuotaManager mockQuotaManager = (RLMQuotaManager)Mockito.mock(RLMQuotaManager.class);
    LogOffsetMetadata logOffsetMetadata = new LogOffsetMetadata(100L);
    Records records = (Records)Mockito.mock(Records.class);
    Timer timer = (Timer)Mockito.mock(Timer.class);

    @BeforeEach
    public void setUp() throws Exception {
        TestUtils.clearYammerMetrics();
        this.brokerTopicStats = new BrokerTopicStats(true);
        Mockito.when((Object)this.timer.time((Callable)ArgumentMatchers.any(Callable.class))).thenAnswer(ans -> ((Callable)ans.getArgument(0, Callable.class)).call());
    }

    @Test
    public void testRemoteLogReaderWithoutError() throws RemoteStorageException, IOException {
        FetchDataInfo fetchDataInfo = new FetchDataInfo(this.logOffsetMetadata, this.records);
        Mockito.when((Object)this.records.sizeInBytes()).thenReturn((Object)100);
        Mockito.when((Object)this.mockRLM.read((RemoteStorageFetchInfo)ArgumentMatchers.any(RemoteStorageFetchInfo.class))).thenReturn((Object)fetchDataInfo);
        Consumer callback = (Consumer)Mockito.mock(Consumer.class);
        RemoteStorageFetchInfo remoteStorageFetchInfo = new RemoteStorageFetchInfo(0, false, new TopicPartition(TOPIC, 0), null, null, false);
        RemoteLogReader remoteLogReader = new RemoteLogReader(remoteStorageFetchInfo, this.mockRLM, callback, this.brokerTopicStats, this.mockQuotaManager, this.timer);
        remoteLogReader.call();
        ArgumentCaptor remoteLogReadResultArg = ArgumentCaptor.forClass(RemoteLogReadResult.class);
        ((Consumer)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).accept(remoteLogReadResultArg.capture());
        RemoteLogReadResult actualRemoteLogReadResult = (RemoteLogReadResult)remoteLogReadResultArg.getValue();
        Assertions.assertFalse((boolean)actualRemoteLogReadResult.error.isPresent());
        Assertions.assertTrue((boolean)actualRemoteLogReadResult.fetchDataInfo.isPresent());
        Assertions.assertEquals((Object)fetchDataInfo, actualRemoteLogReadResult.fetchDataInfo.get());
        ArgumentCaptor recordedArg = ArgumentCaptor.forClass(Double.class);
        ((RLMQuotaManager)Mockito.verify((Object)this.mockQuotaManager, (VerificationMode)Mockito.times((int)1))).record(((Double)recordedArg.capture()).doubleValue());
        Assertions.assertEquals((double)100.0, (Double)((Double)recordedArg.getValue()));
        Assertions.assertEquals((long)1L, (long)this.brokerTopicStats.topicStats(TOPIC).remoteFetchRequestRate().count());
        Assertions.assertEquals((long)100L, (long)this.brokerTopicStats.topicStats(TOPIC).remoteFetchBytesRate().count());
        Assertions.assertEquals((long)0L, (long)this.brokerTopicStats.topicStats(TOPIC).failedRemoteFetchRequestRate().count());
        Assertions.assertEquals((long)1L, (long)this.brokerTopicStats.allTopicsStats().remoteFetchRequestRate().count());
        Assertions.assertEquals((long)100L, (long)this.brokerTopicStats.allTopicsStats().remoteFetchBytesRate().count());
        Assertions.assertEquals((long)0L, (long)this.brokerTopicStats.allTopicsStats().failedRemoteFetchRequestRate().count());
    }

    @Test
    public void testRemoteLogReaderWithError() throws RemoteStorageException, IOException {
        Mockito.when((Object)this.mockRLM.read((RemoteStorageFetchInfo)ArgumentMatchers.any(RemoteStorageFetchInfo.class))).thenThrow(new Throwable[]{new RuntimeException("error")});
        Consumer callback = (Consumer)Mockito.mock(Consumer.class);
        RemoteStorageFetchInfo remoteStorageFetchInfo = new RemoteStorageFetchInfo(0, false, new TopicPartition(TOPIC, 0), null, null, false);
        RemoteLogReader remoteLogReader = new RemoteLogReader(remoteStorageFetchInfo, this.mockRLM, callback, this.brokerTopicStats, this.mockQuotaManager, this.timer);
        remoteLogReader.call();
        ArgumentCaptor remoteLogReadResultArg = ArgumentCaptor.forClass(RemoteLogReadResult.class);
        ((Consumer)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).accept(remoteLogReadResultArg.capture());
        RemoteLogReadResult actualRemoteLogReadResult = (RemoteLogReadResult)remoteLogReadResultArg.getValue();
        Assertions.assertTrue((boolean)actualRemoteLogReadResult.error.isPresent());
        Assertions.assertFalse((boolean)actualRemoteLogReadResult.fetchDataInfo.isPresent());
        ArgumentCaptor recordedArg = ArgumentCaptor.forClass(Double.class);
        ((RLMQuotaManager)Mockito.verify((Object)this.mockQuotaManager, (VerificationMode)Mockito.times((int)1))).record(((Double)recordedArg.capture()).doubleValue());
        Assertions.assertEquals((double)0.0, (Double)((Double)recordedArg.getValue()));
        Assertions.assertEquals((long)1L, (long)this.brokerTopicStats.topicStats(TOPIC).remoteFetchRequestRate().count());
        Assertions.assertEquals((long)0L, (long)this.brokerTopicStats.topicStats(TOPIC).remoteFetchBytesRate().count());
        Assertions.assertEquals((long)1L, (long)this.brokerTopicStats.topicStats(TOPIC).failedRemoteFetchRequestRate().count());
        Assertions.assertEquals((long)1L, (long)this.brokerTopicStats.allTopicsStats().remoteFetchRequestRate().count());
        Assertions.assertEquals((long)0L, (long)this.brokerTopicStats.allTopicsStats().remoteFetchBytesRate().count());
        Assertions.assertEquals((long)1L, (long)this.brokerTopicStats.allTopicsStats().failedRemoteFetchRequestRate().count());
    }
}

