/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.quantizer;

import com.googlecode.cqengine.quantizer.Quantizer;

public class FloatQuantizer {
    FloatQuantizer() {
    }

    public static Quantizer<Float> withCompressionFactor(int compressionFactor) {
        return compressionFactor < 2 ? new TruncatingQuantizer() : new TruncatingAndCompressingQuantizer(compressionFactor);
    }

    static class TruncatingQuantizer
    implements Quantizer<Float> {
        TruncatingQuantizer() {
        }

        @Override
        public Float getQuantizedValue(Float attributeValue) {
            return Float.valueOf((long)attributeValue.doubleValue());
        }
    }

    static class TruncatingAndCompressingQuantizer
    implements Quantizer<Float> {
        private final int compressionFactor;

        public TruncatingAndCompressingQuantizer(int compressionFactor) {
            if (compressionFactor < 2) {
                throw new IllegalArgumentException("Invalid compression factor, must be >= 2: " + compressionFactor);
            }
            this.compressionFactor = compressionFactor;
        }

        @Override
        public Float getQuantizedValue(Float attributeValue) {
            return Float.valueOf(attributeValue.longValue() / (long)this.compressionFactor * (long)this.compressionFactor);
        }
    }
}

