/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.query.simple;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.SimpleQuery;
import com.googlecode.cqengine.query.support.QueryValidation;

public class Between<O, A extends Comparable<A>>
extends SimpleQuery<O, A> {
    private final A lowerValue;
    private final boolean lowerInclusive;
    private final A upperValue;
    private final boolean upperInclusive;

    public Between(Attribute<O, A> attribute, A lowerValue, boolean lowerInclusive, A upperValue, boolean upperInclusive) {
        super(attribute);
        this.lowerValue = (Comparable)QueryValidation.checkQueryValueNotNull(lowerValue);
        this.lowerInclusive = lowerInclusive;
        this.upperValue = (Comparable)QueryValidation.checkQueryValueNotNull(upperValue);
        this.upperInclusive = upperInclusive;
    }

    public A getLowerValue() {
        return this.lowerValue;
    }

    public boolean isLowerInclusive() {
        return this.lowerInclusive;
    }

    public A getUpperValue() {
        return this.upperValue;
    }

    public boolean isUpperInclusive() {
        return this.upperInclusive;
    }

    public String toString() {
        if (this.lowerInclusive && this.upperInclusive) {
            return "between(" + Between.asLiteral(super.getAttributeName()) + ", " + Between.asLiteral(this.lowerValue) + ", " + Between.asLiteral(this.upperValue) + ")";
        }
        return "between(" + Between.asLiteral(super.getAttributeName()) + ", " + Between.asLiteral(this.lowerValue) + ", " + this.lowerInclusive + ", " + Between.asLiteral(this.upperValue) + ", " + this.upperInclusive + ")";
    }

    @Override
    protected boolean matchesSimpleAttribute(SimpleAttribute<O, A> attribute, O object, QueryOptions queryOptions) {
        Comparable attributeValue = (Comparable)attribute.getValue(object, queryOptions);
        return this.lowerInclusive && this.upperInclusive ? this.lowerValue.compareTo((Comparable)attributeValue) <= 0 && this.upperValue.compareTo((Comparable)attributeValue) >= 0 : (this.lowerInclusive ? this.lowerValue.compareTo((Comparable)attributeValue) <= 0 && this.upperValue.compareTo((Comparable)attributeValue) > 0 : (this.upperInclusive ? this.lowerValue.compareTo((Comparable)attributeValue) < 0 && this.upperValue.compareTo((Comparable)attributeValue) >= 0 : this.lowerValue.compareTo((Comparable)attributeValue) < 0 && this.upperValue.compareTo((Comparable)attributeValue) > 0));
    }

    @Override
    protected boolean matchesNonSimpleAttribute(Attribute<O, A> attribute, O object, QueryOptions queryOptions) {
        Iterable<A> attributeValues = attribute.getValues(object, queryOptions);
        if (this.lowerInclusive && this.upperInclusive) {
            for (Comparable attributeValue : attributeValues) {
                if (this.lowerValue.compareTo((Comparable)attributeValue) > 0 || this.upperValue.compareTo((Comparable)attributeValue) < 0) continue;
                return true;
            }
        } else if (this.lowerInclusive) {
            for (Comparable attributeValue : attributeValues) {
                if (this.lowerValue.compareTo((Comparable)attributeValue) > 0 || this.upperValue.compareTo((Comparable)attributeValue) <= 0) continue;
                return true;
            }
        } else if (this.upperInclusive) {
            for (Comparable attributeValue : attributeValues) {
                if (this.lowerValue.compareTo((Comparable)attributeValue) >= 0 || this.upperValue.compareTo((Comparable)attributeValue) < 0) continue;
                return true;
            }
        } else {
            for (Comparable attributeValue : attributeValues) {
                if (this.lowerValue.compareTo((Comparable)attributeValue) >= 0 || this.upperValue.compareTo((Comparable)attributeValue) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Between)) {
            return false;
        }
        Between between = (Between)o;
        if (!this.attribute.equals(between.attribute)) {
            return false;
        }
        if (this.lowerInclusive != between.lowerInclusive) {
            return false;
        }
        if (this.upperInclusive != between.upperInclusive) {
            return false;
        }
        if (!this.lowerValue.equals(between.lowerValue)) {
            return false;
        }
        return this.upperValue.equals(between.upperValue);
    }

    @Override
    protected int calcHashCode() {
        int result = this.attribute.hashCode();
        result = 31 * result + this.lowerValue.hashCode();
        result = 31 * result + (this.lowerInclusive ? 1 : 0);
        result = 31 * result + this.upperValue.hashCode();
        result = 31 * result + (this.upperInclusive ? 1 : 0);
        return result;
    }
}

