/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.condition.ComposedRutaCondition;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class MOfNCondition
extends ComposedRutaCondition {
    private final INumberExpression min;
    private final INumberExpression max;

    public MOfNCondition(List<AbstractRutaCondition> conditions, INumberExpression min, INumberExpression max) {
        super(conditions);
        this.min = min;
        this.max = max;
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        int result = 0;
        ArrayList<EvaluatedCondition> evals = new ArrayList<EvaluatedCondition>();
        for (AbstractRutaCondition each : this.conditions) {
            crowd.beginVisit(each, null);
            EvaluatedCondition eval = each.eval(context, stream, crowd);
            crowd.endVisit(each, null);
            evals.add(eval);
            if (!eval.isValue()) continue;
            ++result;
        }
        boolean value = result >= this.min.getIntegerValue(context, stream) && result <= this.max.getIntegerValue(context, stream);
        return new EvaluatedCondition(this, value, evals);
    }

    public INumberExpression getMin() {
        return this.min;
    }

    public INumberExpression getMax() {
        return this.max;
    }
}

