/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.elasticsearch.querybuilders.advanced;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import java.util.Collection;
import java.util.Map;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.persistence.elasticsearch.ConditionESQueryBuilder;
import org.apache.unomi.persistence.elasticsearch.ConditionESQueryBuilderDispatcher;

public class IdsConditionESQueryBuilder
implements ConditionESQueryBuilder {
    private int maximumIdsQueryCount = 5000;

    public void setMaximumIdsQueryCount(int maximumIdsQueryCount) {
        this.maximumIdsQueryCount = maximumIdsQueryCount;
    }

    public Query buildQuery(Condition condition, Map<String, Object> context, ConditionESQueryBuilderDispatcher dispatcher) {
        Collection ids = (Collection)condition.getParameter("ids");
        Boolean match = (Boolean)condition.getParameter("match");
        if (ids.size() > this.maximumIdsQueryCount) {
            throw new UnsupportedOperationException("Too many profiles");
        }
        Query idsQuery = Query.of(q -> q.ids(i -> i.values(ids.stream().toList())));
        if (match.booleanValue()) {
            return idsQuery;
        }
        return Query.of(q -> q.bool(b -> b.mustNot(idsQuery, new Query[0])));
    }
}

