/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScore;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScoreVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RandomScoreFunction
implements FunctionScoreVariant,
JsonpSerializable {
    @Nullable
    private final String field;
    @Nullable
    private final String seed;
    public static final JsonpDeserializer<RandomScoreFunction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RandomScoreFunction::setupRandomScoreFunctionDeserializer);

    private RandomScoreFunction(Builder builder) {
        this.field = builder.field;
        this.seed = builder.seed;
    }

    public static RandomScoreFunction of(Function<Builder, ObjectBuilder<RandomScoreFunction>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public FunctionScore.Kind _functionScoreKind() {
        return FunctionScore.Kind.RandomScore;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final String seed() {
        return this.seed;
    }

    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.seed != null) {
            generator.writeKey("seed");
            generator.write(this.seed);
        }
    }

    public String toString() {
        return JsonpUtils.toString((JsonpSerializable)this);
    }

    protected static void setupRandomScoreFunctionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::seed, JsonpDeserializer.stringDeserializer(), "seed");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RandomScoreFunction> {
        @Nullable
        private String field;
        @Nullable
        private String seed;

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder seed(@Nullable String value) {
            this.seed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RandomScoreFunction build() {
            this._checkSingleUse();
            return new RandomScoreFunction(this);
        }
    }
}

