/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class XForwardedRequestWrapper
extends HttpServletRequestWrapper {
    private SimpleDateFormat[] dateFormats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    private Map<String, List<String>> headers;
    private String remoteAddr;
    private String remoteHost;
    private String scheme;
    private boolean secure;
    private int serverPort;

    public XForwardedRequestWrapper(HttpServletRequest request) {
        super(request);
        this.remoteAddr = request.getRemoteAddr();
        this.remoteHost = request.getRemoteHost();
        this.scheme = request.getScheme();
        this.secure = request.isSecure();
        this.serverPort = request.getServerPort();
        this.headers = new HashMap<String, List<String>>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String header = (String)headerNames.nextElement();
            this.headers.put(header, Collections.list(request.getHeaders(header)));
        }
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        Date date = null;
        for (int i = 0; i < this.dateFormats.length && date == null; ++i) {
            SimpleDateFormat dateFormat = this.dateFormats[i];
            try {
                date = dateFormat.parse(value);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (date == null) {
            throw new IllegalArgumentException(value);
        }
        return date.getTime();
    }

    public String getHeader(String name) {
        Map.Entry<String, List<String>> header = this.getHeaderEntry(name);
        if (header == null || header.getValue() == null || header.getValue().isEmpty()) {
            return null;
        }
        return header.getValue().get(0);
    }

    private Map.Entry<String, List<String>> getHeaderEntry(String name) {
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(name)) continue;
            return entry;
        }
        return null;
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public Enumeration<String> getHeaders(String name) {
        Map.Entry<String, List<String>> header = this.getHeaderEntry(name);
        if (header == null || header.getValue() == null) {
            return Collections.enumeration(Collections.emptyList());
        }
        return Collections.enumeration((Collection)header.getValue());
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void removeHeader(String name) {
        Map.Entry<String, List<String>> header = this.getHeaderEntry(name);
        if (header != null) {
            this.headers.remove(header.getKey());
        }
    }

    public void setHeader(String name, String value) {
        List<String> values = Arrays.asList(value);
        Map.Entry<String, List<String>> header = this.getHeaderEntry(name);
        if (header == null) {
            this.headers.put(name, values);
        } else {
            header.setValue(values);
        }
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }
}

