/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.polySymbols.html.attributes;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.XmlAttributeInsertHandler;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.polySymbols.PolySymbol;
import com.intellij.polySymbols.PolySymbolModifier;
import com.intellij.polySymbols.PolySymbolQualifiedKind;
import com.intellij.polySymbols.completion.AsteriskAwarePrefixMatcher;
import com.intellij.polySymbols.completion.PolySymbolCodeCompletionItem;
import com.intellij.polySymbols.completion.PolySymbolsCompletionProviderBase;
import com.intellij.polySymbols.html.HtmlDescriptorUtils;
import com.intellij.polySymbols.html.HtmlFrameworkSymbolsSupport;
import com.intellij.polySymbols.html.HtmlSymbolKinds;
import com.intellij.polySymbols.html.StandardHtmlSymbol;
import com.intellij.polySymbols.html.attributes.HtmlAttributeSymbolInfo;
import com.intellij.polySymbols.query.PolySymbolQueryExecutor;
import com.intellij.polySymbols.query.PolySymbolQueryExecutorFactory;
import com.intellij.polySymbols.utils.PolySymbolUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J8\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0014\u00a8\u0006\u0014"}, d2={"Lcom/intellij/polySymbols/html/attributes/HtmlAttributeSymbolsCompletionProvider;", "Lcom/intellij/polySymbols/completion/PolySymbolsCompletionProviderBase;", "Lcom/intellij/psi/xml/XmlAttribute;", "<init>", "()V", "getContext", "position", "Lcom/intellij/psi/PsiElement;", "addCompletions", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "", "name", "", "queryExecutor", "Lcom/intellij/polySymbols/query/PolySymbolQueryExecutor;", "context", "intellij.xml.impl"})
public final class HtmlAttributeSymbolsCompletionProvider
extends PolySymbolsCompletionProviderBase<XmlAttribute> {
    @Nullable
    protected XmlAttribute getContext(@NotNull PsiElement position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)position, XmlAttribute.class);
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, int position, @NotNull String name, @NotNull PolySymbolQueryExecutor queryExecutor, @NotNull XmlAttribute context) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        XmlTag xmlTag = context.getParent();
        if (xmlTag == null) {
            return;
        }
        XmlTag tag = xmlTag;
        PrefixMatcher prefixMatcher = result.getPrefixMatcher().cloneWithPrefix(name);
        Intrinsics.checkNotNullExpressionValue((Object)prefixMatcher, (String)"cloneWithPrefix(...)");
        CompletionResultSet completionResultSet = result.withPrefixMatcher((PrefixMatcher)new AsteriskAwarePrefixMatcher(prefixMatcher));
        Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"withPrefixMatcher(...)");
        CompletionResultSet patchedResultSet = completionResultSet;
        XmlAttribute[] xmlAttributeArray = tag.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)xmlAttributeArray, (String)"getAttributes(...)");
        Set providedAttributes = SequencesKt.toMutableSet((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])xmlAttributeArray), HtmlAttributeSymbolsCompletionProvider::addCompletions$lambda$0));
        Predicate attributesFilter = HtmlFrameworkSymbolsSupport.Companion.get(queryExecutor.getFramework()).getAttributeNameCodeCompletionFilter(tag);
        Set filteredOutStandardSymbols = SequencesKt.toMutableSet((Sequence)SequencesKt.map((Sequence)HtmlDescriptorUtils.getStandardHtmlAttributeDescriptors((XmlTag)tag), HtmlAttributeSymbolsCompletionProvider::addCompletions$lambda$1));
        PolySymbolsCompletionProviderBase.Companion.processCompletionQueryResults$default((PolySymbolsCompletionProviderBase.Companion)PolySymbolsCompletionProviderBase.Companion, (PolySymbolQueryExecutor)queryExecutor, (CompletionResultSet)patchedResultSet, (PolySymbolQualifiedKind)HtmlSymbolKinds.HTML_ATTRIBUTES, (String)name, (int)position, (PsiElement)((PsiElement)context), null, (Set)providedAttributes, arg_0 -> HtmlAttributeSymbolsCompletionProvider.addCompletions$lambda$2(filteredOutStandardSymbols, name, attributesFilter, arg_0), arg_0 -> HtmlAttributeSymbolsCompletionProvider.addCompletions$lambda$3(parameters, patchedResultSet, context, queryExecutor, name, arg_0), (int)64, null);
        providedAttributes.addAll(filteredOutStandardSymbols);
        result.runRemainingContributors(parameters, arg_0 -> HtmlAttributeSymbolsCompletionProvider.addCompletions$lambda$5(arg_0 -> HtmlAttributeSymbolsCompletionProvider.addCompletions$lambda$4(name, providedAttributes, attributesFilter, result, arg_0), arg_0));
    }

    private static final String addCompletions$lambda$0(XmlAttribute it) {
        return it.getName();
    }

    private static final String addCompletions$lambda$1(XmlAttributeDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean addCompletions$lambda$2(Set $filteredOutStandardSymbols, String $name, Predicate $attributesFilter, PolySymbolCodeCompletionItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (item.getSymbol() instanceof StandardHtmlSymbol && item.getOffset() == 0) {
            PolySymbol polySymbol = item.getSymbol();
            if (Intrinsics.areEqual((Object)(polySymbol != null ? polySymbol.getName() : null), (Object)item.getName())) {
                $filteredOutStandardSymbols.remove(item.getName());
                return false;
            }
        }
        if (item.getOffset() > $name.length()) return false;
        String string = $name.substring(0, item.getOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        if (!$attributesFilter.test(string + item.getName())) return false;
        return true;
    }

    private static final Unit addCompletions$lambda$3(CompletionParameters $parameters, CompletionResultSet $patchedResultSet, XmlAttribute $context, PolySymbolQueryExecutor $queryExecutor, String $name, PolySymbolCodeCompletionItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        PolySymbolCodeCompletionItem.addToResult$default((PolySymbolCodeCompletionItem)PolySymbolCodeCompletionItem.withInsertHandlerAdded$default((PolySymbolCodeCompletionItem)item, (arg_0, arg_1) -> HtmlAttributeSymbolsCompletionProvider.addCompletions$lambda$3$0($context, $queryExecutor, $name, item, arg_0, arg_1), null, (int)2, null), (CompletionParameters)$parameters, (CompletionResultSet)$patchedResultSet, (double)0.0, (int)4, null);
        return Unit.INSTANCE;
    }

    private static final void addCompletions$lambda$3$0(XmlAttribute $context, PolySymbolQueryExecutor $queryExecutor, String $name, PolySymbolCodeCompletionItem $item, InsertionContext insertionContext, LookupElement lookupItem) {
        Intrinsics.checkNotNullParameter((Object)insertionContext, (String)"insertionContext");
        Intrinsics.checkNotNullParameter((Object)lookupItem, (String)"lookupItem");
        PolySymbolQueryExecutor freshRegistry = PolySymbolQueryExecutorFactory.Companion.create((PsiElement)$context, $queryExecutor.allowResolve());
        String string = $name.substring(0, $item.getOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String fullName = string + $item.getName();
        HtmlAttributeSymbolInfo info = (HtmlAttributeSymbolInfo)XmlTagInsertHandler.runWithTimeoutOrNull(() -> HtmlAttributeSymbolsCompletionProvider.addCompletions$lambda$3$0$0(freshRegistry, fullName, insertionContext));
        if (info != null && info.acceptsValue() && !info.acceptsNoValue()) {
            XmlAttributeInsertHandler.INSTANCE.handleInsert(insertionContext, lookupItem);
        }
    }

    private static final HtmlAttributeSymbolInfo addCompletions$lambda$3$0$0(PolySymbolQueryExecutor $freshRegistry, String $fullName, InsertionContext $insertionContext) {
        PolySymbol polySymbol = PolySymbolUtils.asSingleSymbol$default((List)((PolySymbolQueryExecutor.NameMatchQueryBuilder)$freshRegistry.nameMatchQuery(HtmlSymbolKinds.HTML_ATTRIBUTES, $fullName).exclude(PolySymbolModifier.ABSTRACT)).run(), (boolean)false, (int)1, null);
        if (polySymbol == null) {
            return null;
        }
        PolySymbol match = polySymbol;
        PsiFile psiFile = $insertionContext.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        return HtmlAttributeSymbolInfo.Companion.create($fullName, $freshRegistry, match, (PsiElement)psiFile);
    }

    private static final Unit addCompletions$lambda$4(String $name, Set $providedAttributes, Predicate $attributesFilter, CompletionResultSet $result, CompletionResult toPass) {
        String string = toPass.getPrefixMatcher().getPrefix();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPrefix(...)");
        String attrName = StringsKt.removeSuffix((String)$name, (CharSequence)string) + toPass.getLookupElement().getLookupString();
        if (!$providedAttributes.contains(attrName) && $attributesFilter.test(attrName)) {
            LookupElement lookupElement = toPass.getLookupElement();
            Intrinsics.checkNotNullExpressionValue((Object)lookupElement, (String)"getLookupElement(...)");
            LookupElement element = lookupElement;
            PrefixMatcher prefixMatcher = toPass.getPrefixMatcher();
            Intrinsics.checkNotNullExpressionValue((Object)prefixMatcher, (String)"getPrefixMatcher(...)");
            $result.withPrefixMatcher((PrefixMatcher)new AsteriskAwarePrefixMatcher(prefixMatcher)).withRelevanceSorter(toPass.getSorter()).addElement(element);
        }
        return Unit.INSTANCE;
    }

    private static final void addCompletions$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

