---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token GitLab Kubernetes agent token'
---

## Description

The response body contains content that matches the pattern of a GitLab Agent for Kubernetes token was identified. The Kubernetes access token is used to authenticate the GitLab agent for Kubernetes with a Kubernetes cluster. A malicious actor with access to this token can access source code in the agent's configuration project, access source code in any public project on the GitLab instance, or even, under very specific conditions, obtain a Kubernetes manifest.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet). For more information please see [GitLabs documentation on rotating the Kubernetes agent token](../../../../../user/clusters/agent/work_with_agent.md#reset-the-agent-token).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.148 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
