#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.51
visibility:           public
id:                   hledger-web-1.51-7K9geft182g8sHvstWxvUA
key:                  hledger-web-1.51-7K9geft182g8sHvstWxvUA
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  b500287e588d5356082f9acc755d4964
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.App Hledger.Web.Application
    Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Import Hledger.Web.Main Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Test
    Hledger.Web.WebOptions Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common

hidden-modules:       Paths_hledger_web
import-dirs:          /usr/lib/ghc-9.6.6/site-local/hledger-web-1.51
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hledger-web-1.51
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hledger-web-1.51
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.51-7K9geft182g8sHvstWxvUA
depends:
    Decimal-0.5.2-EfeRJOh9ESJFpVyAivOumF
    aeson-2.1.2.1-6DouAcLayfd1cKsM4PdlxR base-4.18.2.1
    base64-1.0-CbLcJVANRWrDPPKy43i2qu
    blaze-html-0.9.2.0-ewkcMpB7hX5zM6Snyh7uM
    blaze-markup-0.8.3.0-J7VUp7h8NNh5WgPS0pzxN4 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-8vz9c08oERN6HaPlnW3IdE
    clientsession-0.9.3.0-BmMWcqdCr88Am36MfbJJlr
    cmdargs-0.10.22-E2EkQI5shziHkHOdPiVHiM
    conduit-1.3.6.1-IACzArib6WtLejx9Lk1hSM
    conduit-extra-1.3.8-9QiDtjtytfa6eCoLtsLqkJ containers-0.6.7
    data-default-0.7.1.3-GjFcYIDEzFPmj8haZ8waF directory-1.3.8.5
    extra-1.7.16-8dGAsSrJDrL2Qv7CcA7Z6y
    file-embed-0.0.16.0-6A32wX7iXBC7ZTuLWlLLWz filepath-1.4.300.1
    githash-0.1.6.3-70lrRFpX9RDHBIxTbbWuc0
    hjsmin-0.2.1-4P9QBKEP5KODrkNGRbQUV4
    hledger-1.51-4NEN0qWp3ZCInzCNF4R0CS
    hledger-lib-1.51-8zx6sxk97jiAwvGZ6HFbXf
    hspec-2.11.4-D53pinUpqWUCFRnPSHIhmr
    http-client-0.7.19-5kCWQrqBeyJH4fxMxrytAc
    http-conduit-2.3.9.1-GnvZitcVXEVEGsr4Dte5Vr
    http-types-0.12.4-5e6CiUpSQgfFBuPHItSqh0
    megaparsec-9.7.0-EJ90AsoHAMdCjQYvJMoIz4 mtl-2.3.1
    network-3.1.4.0-6jdgASXXSsi4c1a8fEUR94
    safe-0.3.21-Jx1j9PonLpAIXmir4WvZhd
    shakespeare-2.1.7-LBtmZ0fm3rP1DZX3OU8PFQ template-haskell-2.20.0.0
    text-2.0.2 time-1.12.2 transformers-0.6.1.0
    unix-compat-0.7.4.1-7Zyia4XRlOQIIQMyLxI1QD
    unordered-containers-0.2.20.1-650icVWmHjf3WKXK0GKpae
    utf8-string-1.0.2-2At7L47Qsbs4rlGLlJEQb1
    wai-3.2.4-9STWQp0whD3L0eUd8mHjKL
    wai-cors-0.2.7-ANfbORbyWdpFTyKdW4Kku
    wai-extra-3.1.18-2CQZK1Cbg764L1ClF3lZAF
    wai-handler-launch-3.0.3.1-5RzlZRqFxtUGpqjKIPOQps
    warp-3.4.0-GHcSslYCols6Pqy3RAioju
    yaml-0.11.11.2-9quCwX1yndE4hP4rvoY2SV
    yesod-1.6.2.1-Ly9IvMCTlg8GiHPJZ5pAE5
    yesod-core-1.6.27.1-3aCaWJBdnkGNIPjPQ1VyT
    yesod-form-1.7.9-gQnyfKsPnx2rvU3noISj
    yesod-static-1.6.1.0-94RYtgdZkSmB0vLcW3heUS
    yesod-test-1.6.23-JD9hEcIaOwN2LC09MGeS4z

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

