/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.images.editor.paste;

import com.intellij.lang.Language;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FileDropEvent;
import com.intellij.openapi.editor.FileDropHandler;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ReadOnlyModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.fileTypes.impl.SvgFileType;
import org.intellij.plugins.markdown.editor.EditorUtilKt;
import org.intellij.plugins.markdown.images.MarkdownImagesBundle;
import org.intellij.plugins.markdown.images.editor.ImageUtils;
import org.intellij.plugins.markdown.images.editor.paste.MarkdownFileDropHandler;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.intellij.plugins.markdown.settings.MarkdownCodeInsightSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\rH\u0082@\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/images/editor/paste/MarkdownFileDropHandler;", "Lcom/intellij/openapi/editor/FileDropHandler;", "<init>", "()V", "handleDrop", "", "e", "Lcom/intellij/openapi/editor/FileDropEvent;", "(Lcom/intellij/openapi/editor/FileDropEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "canHandle", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "files", "", "Ljava/io/File;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Lcom/intellij/openapi/editor/Editor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Manager", "intellij.markdown.images"})
@SourceDebugExtension(value={"SMAP\nMarkdownFileDropHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownFileDropHandler.kt\norg/intellij/plugins/markdown/images/editor/paste/MarkdownFileDropHandler\n+ 2 actions.kt\ncom/intellij/openapi/command/ActionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n7#2,6:138\n1563#3:144\n1634#3,3:145\n*S KotlinDebug\n*F\n+ 1 MarkdownFileDropHandler.kt\norg/intellij/plugins/markdown/images/editor/paste/MarkdownFileDropHandler\n*L\n68#1:138,6\n64#1:144\n64#1:145,3\n*E\n"})
public final class MarkdownFileDropHandler
implements FileDropHandler {
    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object handleDrop(@NotNull FileDropEvent e, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof handleDrop.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ MarkdownFileDropHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.handleDrop(null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (e.getEditor() == null) {
                    return Boxing.boxBoolean((boolean)false);
                }
                $continuation.L$0 = e;
                $continuation.label = 1;
                v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, handleDrop$lambda$0(org.intellij.plugins.markdown.images.editor.paste.MarkdownFileDropHandler com.intellij.openapi.editor.FileDropEvent ), ()Ljava/lang/Boolean;)((MarkdownFileDropHandler)this, (FileDropEvent)e), (Continuation)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                e = (FileDropEvent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    return Boxing.boxBoolean((boolean)false);
                }
                v1 = e.getProject();
                v2 = e.getFiles();
                v3 = e.getEditor();
                Intrinsics.checkNotNull((Object)v3);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)e);
                $continuation.label = 2;
                v4 = this.handleDrop(v1, v2, v3, (Continuation<? super Boolean>)$continuation);
                if (v4 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl40
            }
            case 2: {
                e = (FileDropEvent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl40:
                // 2 sources

                return v4;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canHandle(Project project, Editor editor2) {
        if (editor2.isDisposed()) {
            return false;
        }
        if (!editor2.getDocument().isWritable()) {
            return false;
        }
        if (!((MarkdownCodeInsightSettings.State)MarkdownCodeInsightSettings.Companion.getInstance().getState()).getEnableFileDrop()) {
            return false;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
        if (file == null) return false;
        Language language = file.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        if (!MarkdownLanguageUtilsKt.isMarkdownLanguage(language)) return false;
        return true;
    }

    private final Object handleDrop(Project project, Collection<? extends File> files, Editor editor2, Continuation<? super Boolean> $completion) {
        return CoroutinesKt.edtWriteAction(() -> MarkdownFileDropHandler.handleDrop$lambda$4(editor2, project, files), $completion);
    }

    private static final boolean handleDrop$lambda$0(MarkdownFileDropHandler this$0, FileDropEvent $e) {
        Project project = $e.getProject();
        Editor editor2 = $e.getEditor();
        Intrinsics.checkNotNull((Object)editor2);
        return this$0.canHandle(project, editor2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit handleDrop$lambda$4$lambda$3(Project $project, Editor $editor, Document $document, String $content) {
        void project$iv;
        Project project = $project;
        String name$iv = Manager.INSTANCE.getCommandName();
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand((Project)project$iv, new Runnable($editor, $document, $content){
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ Document $document$inlined;
            final /* synthetic */ String $content$inlined;
            {
                this.$editor$inlined = editor2;
                this.$document$inlined = document;
                this.$content$inlined = string;
            }

            public final void run() {
                boolean bl = false;
                CaretModel caretModel = this.$editor$inlined.getCaretModel();
                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
                EditorUtilKt.runForEachCaret(caretModel, true, (Function1<? super Caret, Unit>)((Function1)new Function1<Caret, Unit>(this.$document$inlined, this.$content$inlined){
                    final /* synthetic */ Document $document;
                    final /* synthetic */ String $content;
                    {
                        this.$document = $document;
                        this.$content = $content;
                    }

                    public final void invoke(Caret caret) {
                        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
                        this.$document.insertString(caret.getOffset(), (CharSequence)this.$content);
                        caret.moveToOffset(this.$content.length());
                    }
                }));
            }
        }, name$iv, groupId$iv);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean handleDrop$lambda$4(Editor $editor, Project $project, Collection $files) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        PsiFile file;
        block6: {
            block5: {
                if ($editor.isDisposed()) {
                    return false;
                }
                file = PsiDocumentManager.getInstance((Project)$project).getPsiFile($editor.getDocument());
                if (file == null) break block5;
                Language language = file.getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
                if (MarkdownLanguageUtilsKt.isMarkdownLanguage(language)) break block6;
            }
            return false;
        }
        Iterable iterable = $files;
        Manager manager = Manager.INSTANCE;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toPath());
        }
        String content = manager.buildTextContent((Sequence<? extends Path>)CollectionsKt.asSequence((Iterable)((List)destination$iv$iv)), file);
        Document document = $editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Manager.INSTANCE.handleReadOnlyModificationException($project, document2, (Function0<Unit>)((Function0)() -> MarkdownFileDropHandler.handleDrop$lambda$4$lambda$3($project, $editor, document2, content)));
        return true;
    }

    public static final /* synthetic */ Object access$handleDrop(MarkdownFileDropHandler $this, Project project, Collection files, Editor editor2, Continuation $completion) {
        return $this.handleDrop(project, files, editor2, (Continuation<? super Boolean>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\fH\u0002J$\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001eR\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lorg/intellij/plugins/markdown/images/editor/paste/MarkdownFileDropHandler$Manager;", "", "<init>", "()V", "commandName", "", "Lorg/jetbrains/annotations/Nls;", "getCommandName", "()Ljava/lang/String;", "buildTextContent", "files", "Lkotlin/sequences/Sequence;", "Ljava/nio/file/Path;", "file", "Lcom/intellij/psi/PsiFile;", "obtainDirectoryPath", "obtainRelativePath", "path", "currentDirectory", "createUri", "url", "createImageLink", "createFileLink", "handleReadOnlyModificationException", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "block", "Lkotlin/Function0;", "intellij.markdown.images"})
    public static final class Manager {
        @NotNull
        public static final Manager INSTANCE = new Manager();

        private Manager() {
        }

        @NotNull
        public final String getCommandName() {
            return MarkdownImagesBundle.INSTANCE.message("markdown.image.file.drop.handler.drop.command.name", new Object[0]);
        }

        @NotNull
        public final String buildTextContent(@NotNull Sequence<? extends Path> files, @NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            FileType fileType2 = ImageFileTypeManager.getInstance().getImageFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getImageFileType(...)");
            FileType imageFileType = fileType2;
            FileTypeRegistry registry = FileTypeRegistry.getInstance();
            Path currentDirectory = this.obtainDirectoryPath(file);
            Sequence relativePaths = SequencesKt.map(files, arg_0 -> Manager.buildTextContent$lambda$0(currentDirectory, arg_0));
            return SequencesKt.joinToString$default((Sequence)relativePaths, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> Manager.buildTextContent$lambda$1(registry, imageFileType, arg_0), (int)30, null);
        }

        private final Path obtainDirectoryPath(PsiFile file) {
            PsiDirectory psiDirectory = file.getContainingDirectory();
            if (psiDirectory == null || (psiDirectory = psiDirectory.getVirtualFile()) == null) {
                return null;
            }
            PsiDirectory directory = psiDirectory;
            return directory.getFileSystem().getNioPath((VirtualFile)directory);
        }

        private final Path obtainRelativePath(Path path, Path currentDirectory) {
            if (currentDirectory == null) {
                return path;
            }
            return PathsKt.relativeTo((Path)path, (Path)currentDirectory);
        }

        private final String createUri(String url) {
            List list2 = FileUtil.splitPath((String)FileUtil.toSystemDependentName((String)url));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"splitPath(...)");
            return CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"/", null, null, (int)0, null, Manager::createUri$lambda$2, (int)30, null);
        }

        private final String createImageLink(Path file) {
            String string = PathsKt.getName((Path)file);
            String string2 = FileUtil.toSystemIndependentName((String)((Object)file).toString());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
            return ImageUtils.createMarkdownImageText$default(string, this.createUri(string2), null, 4, null);
        }

        private final String createFileLink(Path file) {
            String string = FileUtil.toSystemIndependentName((String)((Object)file).toString());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
            String independentPath = this.createUri(string);
            return "[" + PathsKt.getName((Path)file) + "](" + independentPath + ")";
        }

        public final void handleReadOnlyModificationException(@NotNull Project project, @NotNull Document document, @NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            try {
                block.invoke();
            }
            catch (ReadOnlyModificationException exception) {
                Messages.showErrorDialog((Project)project, (String)exception.getLocalizedMessage(), (String)RefactoringBundle.message((String)"error.title"));
            }
            catch (ReadOnlyFragmentModificationException exception) {
                EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(document).handle(exception);
            }
        }

        private static final Path buildTextContent$lambda$0(Path $currentDirectory, Path it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return INSTANCE.obtainRelativePath(it, $currentDirectory);
        }

        private static final CharSequence buildTextContent$lambda$1(FileTypeRegistry $registry, FileType $imageFileType, Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            FileType fileType2 = $registry.getFileTypeByExtension(PathsKt.getExtension((Path)path));
            return Intrinsics.areEqual((Object)fileType2, (Object)$imageFileType) || Intrinsics.areEqual((Object)fileType2, (Object)SvgFileType.INSTANCE) ? (CharSequence)INSTANCE.createImageLink(path) : (CharSequence)INSTANCE.createFileLink(path);
        }

        private static final CharSequence createUri$lambda$2(String it) {
            String string = URLEncoder.encode(it, Charset.defaultCharset());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
            return StringsKt.replace$default((String)string, (String)"+", (String)"%20", (boolean)false, (int)4, null);
        }
    }
}

