/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import docking.options.OptionsService;
import generic.theme.GThemeDefaults;
import ghidra.app.util.ColorAndStyle;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.options.ScreenElement;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;

public class SymbolInspector
implements OptionsChangeListener {
    private Component repaintComp;
    private ToolOptions optionsObject;
    private Map<String, Object> cache = new HashMap<String, Object>();

    public SymbolInspector(ServiceProvider serviceProvider, Component repaintComp) {
        this(SymbolInspector.getOptions(serviceProvider), repaintComp);
    }

    public SymbolInspector(ToolOptions options, Component repaintComp) {
        this.optionsObject = options;
        this.optionsObject.addOptionsChangeListener((OptionsChangeListener)this);
        this.repaintComp = repaintComp;
    }

    public void optionsChanged(ToolOptions options, String name, Object oldValue, Object newValue) {
        if (options.getName().equals("Listing Display")) {
            if (this.cache.containsKey(name)) {
                this.cache.put(name, newValue);
            }
            if (this.repaintComp != null) {
                this.repaintComp.repaint();
            }
        }
    }

    public void dispose() {
        if (this.optionsObject != null) {
            this.optionsObject.removeOptionsChangeListener((OptionsChangeListener)this);
            this.optionsObject = null;
        }
        this.repaintComp = null;
    }

    @Deprecated(since="11.3", forRemoval=true)
    public void setProgram(Program p) {
    }

    @Deprecated(since="11.3", forRemoval=true)
    public Program getProgram() {
        return null;
    }

    public boolean isBadReferenceSymbol(Symbol s) {
        Memory memory = this.getMemory(s);
        if (memory == null) {
            return true;
        }
        Address a = s.getAddress();
        if (a.isMemoryAddress()) {
            return !memory.contains(s.getAddress());
        }
        return false;
    }

    public boolean isDataSymbol(Symbol s) {
        if (this.isBadReferenceSymbol(s)) {
            return false;
        }
        Address addr = s.getAddress();
        Listing listing = this.getListing(s);
        Data data = listing.getDataContaining(addr);
        return data != null;
    }

    public boolean isDeadCodeSymbol(Symbol s) {
        if (this.isBadReferenceSymbol(s)) {
            return false;
        }
        Program program = s.getProgram();
        ReferenceManager refMgr = program.getReferenceManager();
        return !refMgr.hasReferencesTo(s.getAddress());
    }

    public boolean isEntryPointSymbol(Symbol s) {
        if (this.isBadReferenceSymbol(s)) {
            return false;
        }
        return s.isExternalEntryPoint();
    }

    public boolean isFunctionSymbol(Symbol s) {
        if (this.isBadReferenceSymbol(s)) {
            return false;
        }
        return s.getSymbolType() == SymbolType.FUNCTION;
    }

    public boolean isVariableSymbol(Symbol s) {
        Symbol parent = s.getParentSymbol();
        if (parent == null || !this.isFunctionSymbol(parent)) {
            return false;
        }
        SymbolType type = s.getSymbolType();
        return type == SymbolType.PARAMETER || type == SymbolType.LOCAL_VAR || type == SymbolType.GLOBAL_VAR;
    }

    public boolean isGlobalSymbol(Symbol s) {
        return s.isGlobal();
    }

    public boolean isInstructionSymbol(Symbol s) {
        if (this.isBadReferenceSymbol(s)) {
            return false;
        }
        Address addr = s.getAddress();
        Listing listing = this.getListing(s);
        Instruction instr = listing.getInstructionContaining(addr);
        return instr != null;
    }

    public boolean isLocalSymbol(Symbol s) {
        for (Symbol p = s.getParentSymbol(); p != null; p = p.getParentSymbol()) {
            if (!(p instanceof FunctionSymbol)) continue;
            return true;
        }
        return false;
    }

    public boolean isNonPrimarySymbol(Symbol s) {
        if (this.isBadReferenceSymbol(s)) {
            return false;
        }
        return !s.isPrimary();
    }

    public boolean isOffcutSymbol(Symbol s) {
        if (this.isBadReferenceSymbol(s)) {
            return false;
        }
        Address addr = s.getAddress();
        Listing listing = this.getListing(s);
        CodeUnit cu = listing.getCodeUnitContaining(addr);
        if (cu != null && cu.getLength() > 1) {
            return cu.getMinAddress().compareTo((Object)addr) < 0;
        }
        return false;
    }

    public boolean isPrimarySymbol(Symbol s) {
        if (this.isBadReferenceSymbol(s)) {
            return false;
        }
        return s.isPrimary();
    }

    public boolean isSubroutineSymbol(Symbol s) {
        Reference[] refsTo;
        if (this.isBadReferenceSymbol(s)) {
            return false;
        }
        for (Reference element : refsTo = s.getReferences(null)) {
            if (!element.getReferenceType().isCall()) continue;
            return true;
        }
        return false;
    }

    public boolean isExternalSymbol(Symbol s) {
        return s.getAddress().isExternalAddress();
    }

    public ColorAndStyle getColorAndStyle(Symbol s) {
        ScreenElement se = this.getScreenElement(s);
        Color color = this.getColor(se);
        int style = this.getStyle(se);
        return new ColorAndStyle(color, style);
    }

    public ColorAndStyle getColorAndStyle(Program p, Reference r) {
        ScreenElement se = this.getScreenElement(p, r);
        if (se == null) {
            return null;
        }
        Color color = this.getColor(se);
        int style = this.getStyle(se);
        return new ColorAndStyle(color, style);
    }

    public Color getColor(Symbol s) {
        return this.getColor(this.getScreenElement(s));
    }

    public int getStyle(Symbol s) {
        return this.getStyle(this.getScreenElement(s));
    }

    public ScreenElement getScreenElement(Symbol s) {
        if (s == null) {
            return null;
        }
        if (this.isExternalSymbol(s)) {
            return this.getExternalScreenElement(s);
        }
        if (this.isBadReferenceSymbol(s)) {
            return OptionsGui.BAD_REF_ADDR;
        }
        if (this.isOffcutSymbol(s)) {
            return OptionsGui.XREF_OFFCUT;
        }
        if (this.isEntryPointSymbol(s)) {
            return OptionsGui.ENTRY_POINT;
        }
        if (this.isDeadCodeSymbol(s)) {
            return OptionsGui.LABELS_UNREFD;
        }
        if (this.isFunctionSymbol(s)) {
            Function f = (Function)s.getObject();
            return this.getFunctionScreenElement(f);
        }
        if (this.isVariableSymbol(s)) {
            if (s.getSymbolType() == SymbolType.PARAMETER) {
                Function function = (Function)s.getParentNamespace();
                return function.hasCustomVariableStorage() ? OptionsGui.FUN_PARAM_CUSTOM : OptionsGui.FUN_PARAM_DYNAMIC;
            }
            return OptionsGui.FUN_VARIABLE;
        }
        if (this.isPrimarySymbol(s)) {
            return OptionsGui.LABELS_PRIMARY;
        }
        if (this.isLocalSymbol(s)) {
            return OptionsGui.LABELS_LOCAL;
        }
        if (this.isNonPrimarySymbol(s)) {
            return OptionsGui.LABELS_NON_PRIMARY;
        }
        return null;
    }

    public ScreenElement getScreenElement(Program p, Reference r) {
        if (r.isExternalReference()) {
            ExternalLocation extLoc = ((ExternalReference)r).getExternalLocation();
            String libName = extLoc.getLibraryName();
            return this.getExternalPathScreenElement(p, libName);
        }
        return null;
    }

    public Color getOffcutSymbolColor() {
        return this.getColor(OptionsGui.XREF_OFFCUT);
    }

    public int getOffcutSymbolStyle() {
        return this.getStyle(OptionsGui.XREF_OFFCUT);
    }

    private Listing getListing(Symbol s) {
        Program p = s.getProgram();
        if (p != null) {
            return p.getListing();
        }
        return null;
    }

    private Memory getMemory(Symbol s) {
        Program p = s.getProgram();
        if (p != null) {
            return p.getMemory();
        }
        return null;
    }

    private ScreenElement getExternalScreenElement(Symbol s) {
        Program p = s.getProgram();
        String libName = this.getExternalName(s);
        return this.getExternalPathScreenElement(p, libName);
    }

    private ScreenElement getExternalPathScreenElement(Program p, String libName) {
        ExternalManager externalManager = p.getExternalManager();
        if ("<EXTERNAL>".equals(libName)) {
            return OptionsGui.EXT_REF_UNRESOLVED;
        }
        String path = externalManager.getExternalLibraryPath(libName);
        if (path == null || path.length() == 0) {
            return OptionsGui.EXT_REF_UNRESOLVED;
        }
        return OptionsGui.EXT_REF_RESOLVED;
    }

    private ScreenElement getFunctionScreenElement(Function function) {
        if (function == null || !function.isThunk()) {
            return OptionsGui.FUN_NAME;
        }
        Function thunkedFunction = function.getThunkedFunction(true);
        if (thunkedFunction == null) {
            return OptionsGui.EXT_REF_UNRESOLVED;
        }
        if (thunkedFunction.isExternal()) {
            ExternalLocation location = thunkedFunction.getExternalLocation();
            String libName = location.getLibraryName();
            return this.getExternalPathScreenElement(function.getProgram(), libName);
        }
        return OptionsGui.FUN_NAME;
    }

    private String getExternalName(Symbol s) {
        if (!s.isExternal()) {
            return null;
        }
        if (s.getSymbolType() == SymbolType.LIBRARY) {
            return s.getName();
        }
        Symbol parent = s.getParentSymbol();
        while (parent.getSymbolType() != SymbolType.GLOBAL) {
            if (parent.getSymbolType() == SymbolType.LIBRARY) {
                return parent.getName();
            }
            parent = parent.getParentSymbol();
        }
        return null;
    }

    private static ToolOptions getOptions(ServiceProvider serviceProvider) {
        OptionsService service = (OptionsService)serviceProvider.getService(OptionsService.class);
        return service.getOptions("Listing Display");
    }

    private Color getColor(ScreenElement se) {
        if (se == null) {
            return GThemeDefaults.Colors.FOREGROUND;
        }
        return se.getDefaultColor();
    }

    private int getStyle(ScreenElement se) {
        if (se == null) {
            return -1;
        }
        String optionName = se.getStyleOptionName();
        Integer style = (Integer)this.cache.get(optionName);
        if (style == null) {
            style = this.optionsObject.getInt(optionName, -1);
            this.cache.put(optionName, style);
        }
        return style;
    }
}

